/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library.channel;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.SparseArray;
import com.inuker.bluetooth.library.BluetoothContext;
import com.inuker.bluetooth.library.channel.CRC16;
import com.inuker.bluetooth.library.channel.ChannelCallback;
import com.inuker.bluetooth.library.channel.ChannelEvent;
import com.inuker.bluetooth.library.channel.ChannelState;
import com.inuker.bluetooth.library.channel.ChannelStateBlock;
import com.inuker.bluetooth.library.channel.IChannel;
import com.inuker.bluetooth.library.channel.IChannelStateHandler;
import com.inuker.bluetooth.library.channel.Timer;
import com.inuker.bluetooth.library.channel.packet.ACKPacket;
import com.inuker.bluetooth.library.channel.packet.CTRPacket;
import com.inuker.bluetooth.library.channel.packet.DataPacket;
import com.inuker.bluetooth.library.channel.packet.Packet;
import com.inuker.bluetooth.library.utils.BluetoothLog;
import com.inuker.bluetooth.library.utils.ByteUtils;
import com.inuker.bluetooth.library.utils.proxy.ProxyBulk;
import com.inuker.bluetooth.library.utils.proxy.ProxyInterceptor;
import com.inuker.bluetooth.library.utils.proxy.ProxyUtils;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;

public abstract class Channel
implements IChannel,
ProxyInterceptor {
    private static final long TIMEOUT = 5000L;
    private static final int MSG_WRITE_CALLBACK = 1;
    private static final String TIMER_EXCEPTION = "exception";
    private ChannelState mCurrentState = ChannelState.IDLE;
    private byte[] mBytesToWrite;
    private SparseArray<Packet> mPacketRecv;
    private int mCurrentSync;
    private int mTotalBytes;
    private int mFrameCount;
    private ChannelCallback mChannelCallback;
    private Handler mWorkerHandler;
    private IChannel mChannel;
    private int mLastSync;
    private final IChannelStateHandler mSyncPacketHandler = new IChannelStateHandler(){

        @Override
        public void handleState(Object ... args) {
            Channel.this.assertRuntime(false);
            DataPacket dataPacket = (DataPacket)args[0];
            if (dataPacket.getSeq() != Channel.this.mCurrentSync) {
                BluetoothLog.w(String.format("sync packet not matched!!", new Object[0]));
                return;
            }
            if (!Channel.this.onDataPacketRecvd(dataPacket)) {
                BluetoothLog.w(String.format("sync packet repeated!!", new Object[0]));
                return;
            }
            Channel.this.mLastSync = Channel.this.mCurrentSync;
            Channel.this.mCurrentSync = 0;
            Channel.this.startSyncPacket();
        }
    };
    private final IChannelStateHandler mRecvDataHandler = new IChannelStateHandler(){

        @Override
        public void handleState(Object ... args) {
            Channel.this.assertRuntime(false);
            DataPacket dataPacket = (DataPacket)args[0];
            if (!Channel.this.onDataPacketRecvd(dataPacket)) {
                BluetoothLog.w(String.format("dataPacket repeated!!", new Object[0]));
                return;
            }
            if (dataPacket.getSeq() == Channel.this.mFrameCount) {
                Channel.this.startSyncPacket();
            } else {
                Channel.this.startTimer(5000L, new Timer.TimerCallback("WaitData"){

                    @Override
                    public void onTimerCallback() {
                        Channel.this.startSyncPacket();
                    }
                });
            }
        }
    };
    private final IChannelStateHandler mRecvCTRHandler = new IChannelStateHandler(){

        @Override
        public void handleState(Object ... args) {
            Channel.this.assertRuntime(false);
            CTRPacket ctrPacket = (CTRPacket)args[0];
            Channel.this.mFrameCount = ctrPacket.getFrameCount();
            ACKPacket ackPacket = new ACKPacket(1);
            Channel.this.setCurrentState(ChannelState.READY);
            Channel.this.performWrite(ackPacket, new ChannelCallback(){

                @Override
                public void onCallback(int code) {
                    Channel.this.assertRuntime(false);
                    if (code == 0) {
                        Channel.this.setCurrentState(ChannelState.READING);
                        Channel.this.startTimer();
                    } else {
                        Channel.this.resetChannelStatus();
                    }
                }
            });
        }
    };
    private final IChannelStateHandler mWaitStartACKHandler = new IChannelStateHandler(){

        @Override
        public void handleState(Object ... args) {
            Channel.this.assertRuntime(false);
            Channel.this.setCurrentState(ChannelState.WAIT_START_ACK);
            Channel.this.startTimer();
        }
    };
    private final Timer.TimerCallback mTimeoutHandler = new Timer.TimerCallback(this.getClass().getSimpleName()){

        @Override
        public void onTimerCallback() {
            Channel.this.assertRuntime(false);
            Channel.this.onSendCallback(-2);
            Channel.this.resetChannelStatus();
        }
    };
    private final IChannelStateHandler mRecvACKHandler = new IChannelStateHandler(){

        @Override
        public void handleState(Object ... args) {
            Channel.this.assertRuntime(false);
            ACKPacket ackPacket = (ACKPacket)args[0];
            switch (ackPacket.getStatus()) {
                case 1: {
                    Channel.this.stopTimer();
                    Channel.this.setCurrentState(ChannelState.WRITING);
                    Channel.this.sendDataPacket(0, true);
                    break;
                }
                case 5: {
                    int index = ackPacket.getSeq();
                    if (index < 1 || index > Channel.this.mFrameCount) break;
                    Channel.this.sendDataPacket(index - 1, false);
                    Channel.this.startTimer();
                    break;
                }
                case 0: {
                    Channel.this.onSendCallback(0);
                    Channel.this.resetChannelStatus();
                    break;
                }
                default: {
                    Channel.this.onSendCallback(-1);
                    Channel.this.resetChannelStatus();
                }
            }
        }
    };
    private final ChannelStateBlock[] STATE_MACHINE = new ChannelStateBlock[]{new ChannelStateBlock(ChannelState.READY, ChannelEvent.SEND_CTR, this.mWaitStartACKHandler), new ChannelStateBlock(ChannelState.WAIT_START_ACK, ChannelEvent.RECV_ACK, this.mRecvACKHandler), new ChannelStateBlock(ChannelState.SYNC, ChannelEvent.RECV_ACK, this.mRecvACKHandler), new ChannelStateBlock(ChannelState.IDLE, ChannelEvent.RECV_CTR, this.mRecvCTRHandler), new ChannelStateBlock(ChannelState.READING, ChannelEvent.RECV_DATA, this.mRecvDataHandler), new ChannelStateBlock(ChannelState.SYNC_ACK, ChannelEvent.RECV_DATA, this.mSyncPacketHandler)};
    private final IChannel mChannelImpl = new IChannel(){

        @Override
        public void write(byte[] bytes, ChannelCallback callback) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onRead(byte[] bytes) {
            Channel.this.performOnRead(bytes);
        }

        @Override
        public void onRecv(byte[] bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void send(byte[] value, ChannelCallback callback) {
            Channel.this.performSend(value, callback);
        }
    };
    private final Handler.Callback mCallback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ChannelCallback callback = (ChannelCallback)msg.obj;
                    callback.onCallback(msg.arg1);
                    break;
                }
                default: {
                    ProxyBulk.safeInvoke(msg.obj);
                }
            }
            return false;
        }
    };

    public Channel() {
        this.mPacketRecv = new SparseArray();
        this.mChannel = (IChannel)ProxyUtils.getProxy(this.mChannelImpl, this);
        HandlerThread thread = new HandlerThread(this.getClass().getSimpleName());
        thread.start();
        this.mWorkerHandler = new Handler(thread.getLooper(), this.mCallback);
    }

    @Override
    public final void onRead(byte[] bytes) {
        this.mChannel.onRead(bytes);
    }

    @Override
    public final void send(byte[] value, ChannelCallback callback) {
        BluetoothLog.e(String.format(">>> send %s", new String(value)));
        this.mChannel.send(value, callback);
    }

    private void performWrite(Packet packet, final ChannelCallback callback) {
        this.assertRuntime(false);
        if (callback == null) {
            throw new NullPointerException("callback can't be null");
        }
        if (!this.isTimerOn()) {
            this.startExceptionTimer();
        }
        final byte[] bytes = packet.toBytes();
        BluetoothLog.w(String.format("%s: %s", this.getLogTag(), packet));
        BluetoothContext.post(new Runnable(){

            @Override
            public void run() {
                Channel.this.write(bytes, new WriteCallback(callback));
            }
        });
    }

    private void sendStartFlowPacket() {
        this.assertRuntime(false);
        CTRPacket flowPacket = new CTRPacket(this.mFrameCount);
        this.performWrite(flowPacket, new ChannelCallback(){

            @Override
            public void onCallback(int code) {
                Channel.this.assertRuntime(false);
                if (code == 0) {
                    Channel.this.onPostState(ChannelEvent.SEND_CTR, new Object[0]);
                } else {
                    Channel.this.onSendCallback(-1);
                    Channel.this.resetChannelStatus();
                }
            }
        });
    }

    private void onSendCallback(int code) {
        this.assertRuntime(false);
        BluetoothLog.v(String.format("%s: code = %d", this.getLogTag(), code));
        if (this.mChannelCallback != null) {
            this.mChannelCallback.onCallback(code);
        }
    }

    private boolean onDataPacketRecvd(DataPacket packet) {
        this.assertRuntime(false);
        if (this.mPacketRecv.get(packet.getSeq()) != null) {
            return false;
        }
        if (packet.getSeq() == this.mFrameCount) {
            packet.setLastFrame();
        }
        this.mPacketRecv.put(packet.getSeq(), (Object)packet);
        this.mTotalBytes += packet.getDataLength();
        this.stopTimer();
        return true;
    }

    private void startSyncPacket() {
        this.assertRuntime(false);
        BluetoothLog.v(this.getLogTag());
        this.startTimer();
        this.setCurrentState(ChannelState.SYNC);
        if (!this.syncLostPacket()) {
            final byte[] bytes = this.getTotalRecvdBytes();
            if (!ByteUtils.isEmpty(bytes)) {
                ACKPacket ackPacket = new ACKPacket(0);
                this.performWrite(ackPacket, new ChannelCallback(){

                    @Override
                    public void onCallback(int code) {
                        Channel.this.assertRuntime(false);
                        Channel.this.resetChannelStatus();
                        if (code == 0) {
                            Channel.this.dispatchOnReceive(bytes);
                        }
                    }
                });
            } else {
                this.resetChannelStatus();
            }
        }
    }

    private void dispatchOnReceive(byte[] bytes) {
        BluetoothLog.e(String.format(">>> receive: %s", new String(bytes)));
        BluetoothContext.post(new RecvCallback(bytes));
    }

    private byte[] getTotalRecvdBytes() {
        this.assertRuntime(false);
        if (this.mPacketRecv.size() != this.mFrameCount) {
            throw new IllegalStateException();
        }
        BluetoothLog.v(String.format("%s: totalBytes = %d", this.getLogTag(), this.mTotalBytes));
        ByteBuffer buffer = ByteBuffer.allocate(this.mTotalBytes);
        for (int i = 1; i <= this.mFrameCount; ++i) {
            DataPacket packet = (DataPacket)this.mPacketRecv.get(i);
            packet.fillByteBuffer(buffer);
            if (i != this.mFrameCount || this.checkCRC(buffer.array(), packet.getCrc())) continue;
            BluetoothLog.e(String.format("check crc failed!!", new Object[0]));
            return ByteUtils.EMPTY_BYTES;
        }
        return buffer.array();
    }

    private boolean syncLostPacket() {
        int i;
        this.assertRuntime(false);
        BluetoothLog.v(this.getLogTag());
        for (i = this.mLastSync + 1; i <= this.mFrameCount && this.mPacketRecv.get(i) != null; ++i) {
        }
        if (i <= this.mFrameCount) {
            this.mCurrentSync = i;
            ACKPacket ackPacket = new ACKPacket(5, i);
            this.performWrite(ackPacket, new ChannelCallback(){

                @Override
                public void onCallback(int code) {
                    Channel.this.assertRuntime(false);
                    if (code == 0) {
                        Channel.this.setCurrentState(ChannelState.SYNC_ACK);
                        Channel.this.startTimer();
                    } else {
                        Channel.this.resetChannelStatus();
                    }
                }
            });
            return true;
        }
        return false;
    }

    private void resetChannelStatus() {
        this.assertRuntime(false);
        BluetoothLog.v(this.getLogTag());
        this.stopTimer();
        this.setCurrentState(ChannelState.IDLE);
        this.mBytesToWrite = null;
        this.mFrameCount = 0;
        this.mChannelCallback = null;
        this.mPacketRecv.clear();
        this.mCurrentSync = 0;
        this.mLastSync = 0;
        this.mTotalBytes = 0;
    }

    private void sendDataPacket(final int index, final boolean looped) {
        this.assertRuntime(false);
        if (index >= this.mFrameCount) {
            BluetoothLog.v(String.format("%s: all packets sended!!", this.getLogTag()));
            this.setCurrentState(ChannelState.SYNC);
            this.startTimer(15000L);
            return;
        }
        BluetoothLog.v(String.format("%s: index = %d, looped = %b", this.getLogTag(), index + 1, looped));
        int start = index * 18;
        int end = Math.min(this.mBytesToWrite.length, (index + 1) * 18);
        DataPacket dataPacket = new DataPacket(index + 1, this.mBytesToWrite, start, end);
        this.performWrite(dataPacket, new ChannelCallback(){

            @Override
            public void onCallback(int code) {
                Channel.this.assertRuntime(false);
                if (code != 0) {
                    BluetoothLog.w(String.format(">>> packet %d write failed", index));
                }
                if (looped) {
                    Channel.this.sendDataPacket(index + 1, looped);
                }
            }
        });
    }

    private void setCurrentState(ChannelState state) {
        this.assertRuntime(false);
        BluetoothLog.v(String.format("%s: state = %s", new Object[]{this.getLogTag(), state}));
        this.mCurrentState = state;
    }

    private void onPostState(ChannelEvent event, Object ... args) {
        this.assertRuntime(false);
        BluetoothLog.v(String.format("%s: state = %s, event = %s", new Object[]{this.getLogTag(), this.mCurrentState, event}));
        for (ChannelStateBlock block : this.STATE_MACHINE) {
            if (block.state != this.mCurrentState || block.event != event) continue;
            block.handler.handleState(args);
            break;
        }
    }

    private void assertRuntime(boolean sync) {
        Looper target;
        Looper looper = target = sync ? Looper.getMainLooper() : this.mWorkerHandler.getLooper();
        if (Looper.myLooper() != target) {
            throw new RuntimeException();
        }
    }

    private void performOnRead(byte[] bytes) {
        this.assertRuntime(false);
        Packet packet = Packet.getPacket(bytes);
        BluetoothLog.w(String.format("%s: %s", this.getLogTag(), packet));
        switch (packet.getName()) {
            case "ack": {
                this.onPostState(ChannelEvent.RECV_ACK, packet);
                break;
            }
            case "data": {
                this.onPostState(ChannelEvent.RECV_DATA, packet);
                break;
            }
            case "ctr": {
                this.onPostState(ChannelEvent.RECV_CTR, packet);
                break;
            }
        }
    }

    private void performSend(byte[] value, ChannelCallback callback) {
        this.assertRuntime(false);
        if (this.mCurrentState != ChannelState.IDLE) {
            callback.onCallback(-3);
            return;
        }
        this.mCurrentState = ChannelState.READY;
        this.mChannelCallback = (ChannelCallback)ProxyUtils.getUIProxy(callback);
        this.mTotalBytes = value.length;
        this.mFrameCount = this.getFrameCount(this.mTotalBytes);
        BluetoothLog.v(String.format("%s: totalBytes = %d, frameCount = %d", this.getLogTag(), this.mTotalBytes, this.mFrameCount));
        this.mBytesToWrite = Arrays.copyOf(value, value.length + 2);
        byte[] crc = CRC16.get(value);
        System.arraycopy(crc, 0, this.mBytesToWrite, value.length, 2);
        this.sendStartFlowPacket();
    }

    @Override
    public boolean onIntercept(Object object, Method method, Object[] args) {
        this.mWorkerHandler.obtainMessage(0, (Object)new ProxyBulk(object, method, args)).sendToTarget();
        return true;
    }

    private String getLogTag() {
        return String.format("%s.%s", this.getClass().getSimpleName(), BluetoothContext.getCurrentMethodName());
    }

    private int getFrameCount(int totalBytes) {
        int total = totalBytes + 2;
        return 1 + (total - 1) / 18;
    }

    private void startTimer() {
        this.startTimer(5000L);
    }

    private void startExceptionTimer() {
        this.startTimer(5000L, new Timer.TimerCallback(TIMER_EXCEPTION){

            @Override
            public void onTimerCallback() throws TimeoutException {
                throw new TimeoutException();
            }
        });
    }

    private void startTimer(long duration) {
        this.startTimer(duration, this.mTimeoutHandler);
    }

    private void startTimer(long duration, Timer.TimerCallback callback) {
        BluetoothLog.v(String.format("%s: duration = %d", this.getLogTag(), duration));
        Timer.start(callback, duration);
    }

    private void stopTimer() {
        BluetoothLog.v(this.getLogTag());
        Timer.stop();
    }

    private boolean isTimerOn() {
        return Timer.isRunning();
    }

    private boolean isExceptionTimerOn() {
        return TIMER_EXCEPTION.equals(Timer.getName());
    }

    private boolean checkCRC(byte[] bytes, byte[] crc0) {
        return ByteUtils.equals(crc0, CRC16.get(bytes));
    }

    private class RecvCallback
    implements Runnable {
        private byte[] bytes;

        RecvCallback(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public void run() {
            Channel.this.onRecv(this.bytes);
        }
    }

    private class WriteCallback
    implements ChannelCallback {
        ChannelCallback callback;

        WriteCallback(ChannelCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onCallback(int code) {
            if (Channel.this.isExceptionTimerOn()) {
                Channel.this.stopTimer();
            }
            Channel.this.mWorkerHandler.obtainMessage(1, code, 0, (Object)this.callback).sendToTarget();
        }
    }
}

