/*
 * Decompiled with CFR 0.152.
 */
package com.constant;

import com.blankj.utilcode.util.PathUtils;
import java.io.File;

public class DeviceConstant {
    public static final String INTENT_DEV_ID = "devId";
    public static final String INTENT_GROUP_ID = "groupId";
    public static final String INTENT_DEVICE_RESP = "device";
    public static final String INTENT_DEVICE_NAME = "deviceName";
    public static final String DIY_CAMERA_PORTRAIT_MONITOR_PAGE = "/diy/camera/index";
    public static final String H5_OFFLINE_DOWNLOAD_URL = PathUtils.getExternalAppDataPath() + File.separator + "h5OfflineDownload" + File.separator;
    public static final String H5_OFFLINE_UNZIP_URL_PRE = PathUtils.getExternalAppDataPath() + File.separator + "h5Offline" + File.separator;
    public static final int DEV_ONLY_IP_ONLINE = 64;
    public static final String LIGHT_WHITE_WORK_MODE = "White";
    public static final int RETRY_TIMES = 3;
    public static final String STRING_DEVICE_STATE_ON = "ON";
    public static final String STRING_DEVICE_STATE_OFF = "OFF";
    public static final int DEV_SET_PWD_TIMES = 3;
    public static final int DEV_GET_PWD_TIMES = 3;
    public static final int RECOMMEND_NAME_SIZE = 6;
    public static final String SUPPORT_STREAM = "mainStream";
    public static final int DEVICE_LOW_POWER_TYPE = 21;
    public static final int SHOW_BOTTOM_LEFT_TIPS_TIME = 3000;
    public static final int UPGRADE_START = 0;
    public static int SWITCH_MODE = 1;
    public static int SWITCH_STATE = 2;

    public static enum DevTransTypeEnum {
        COM("com"),
        NET_IP("netIp");

        private final String transType;

        private DevTransTypeEnum(String transType) {
            this.transType = transType;
        }

        public String getTransType() {
            return this.transType;
        }
    }

    public static enum DevRotateEnum {
        ROTATE_0(0, false),
        ROTATE_90(1, true),
        ROTATE_180(2, false),
        ROTATE_270(3, true);

        private boolean isPortrait;
        private int type;

        private DevRotateEnum(int type, boolean isPortrait) {
            this.type = type;
            this.isPortrait = isPortrait;
        }

        public boolean isPortrait() {
            return this.isPortrait;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum DevPidTypeEnum {
        IOT_DOORBELL("ui_doorbell", true),
        IOT_LX_DOORLOCK("ui_doorlock", true),
        BLUE_TOOTH_DOORLOCK("ui_doorlock_ctrl", false),
        DIY_CAMERA("ui_ctrl_camera", false),
        BLE_PET_FEED("ui_feed_no_video", false),
        VIDEO_PET_FEED("ui_feed_have_video", false);

        private final String type;
        private boolean isLowPower;

        private DevPidTypeEnum(String type, boolean isLowPower) {
            this.type = type;
            this.isLowPower = isLowPower;
        }

        public String getType() {
            return this.type;
        }

        public boolean isLowPower() {
            return this.isLowPower;
        }
    }

    public static enum DevSharedStateEnum {
        WAIT_ACCEPT("toBeAccepted"),
        DELETED("deleted"),
        ACCEPTED("accepted"),
        UN_EFFECTIVE("ineffective");

        private final String status;

        private DevSharedStateEnum(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }

    public static enum DevChargeEnum {
        BATTERY("Battery"),
        SOCKET("Socket");

        private final String chargeMode;

        private DevChargeEnum(String chargeMode) {
            this.chargeMode = chargeMode;
        }

        public String getChargeMode() {
            return this.chargeMode;
        }
    }

    public static enum DevPropEnum {
        TEMP_PWD("tempPwd"),
        POWER_SAVING_MODE("powerSavingMode"),
        IPR_DETECTION("loiteringDetection"),
        SleepThresholdSwitch("sleepThresholdSwitch"),
        DEV_MIC("devMic"),
        SWITCH_TYPE("switchType"),
        DEV_SPEAKER("devSpeaker"),
        POWER_SWITCH("powerSwitch"),
        BATTERY_POWER("batteryPower"),
        SLEEP_STATE("sleepState"),
        MANUAL_FEEDING("feed"),
        PERIPHERALS("Peripherals"),
        VIDEO_CORRIDOR_MODE("videoCorridorMode"),
        ROTATE("Rotate"),
        AUTO_LOCK("autoLock"),
        VIDEO_ROATE("videoRotate");

        private final String prop;

        private DevPropEnum(String prop) {
            this.prop = prop;
        }

        public String getProp() {
            return this.prop;
        }
    }

    public static enum DevStateEnum {
        WAKE_UP("WakeUp", 4),
        DEEP_SLEEP("DeepSleep", 5),
        LIGHT_SLEEP("LightSleep", 2),
        PREPARE_SLEEP("PreSleep", 6),
        MASTER_CTRL_SLEEP("Sleep", 2),
        MASTER_CTRL_WAKE("Wake", 4);

        private final String devState;
        private final int devStateType;

        private DevStateEnum(String devState, int type) {
            this.devState = devState;
            this.devStateType = type;
        }

        public String getDevState() {
            return this.devState;
        }

        public int getDevStateType() {
            return this.devStateType;
        }
    }

    public static interface DevStateConstant {
        public static final int DEV_SLEEP_STATE_TYPE = 0;
        public static final int DEV_FUN_STATE_TYPE = 1;
        public static final int DEV_ERROR_STATE_TYPE = 2;
        public static final int DEV_MASTER_CTRL_STATE_TYPE = 3;

        public static enum DevFunStatus {
            REMOTE_UNLOCK("remoteUnlock", 1),
            REMOTE_UNLOCK_FAILED("remoteUnlockFailed", 1),
            FEEDING_STATUS("feedingStatus", 1),
            MANUAL_FEED("feed", 1),
            POWER_SWITCH("powerSwitch", 1),
            FEEDING_ERROR("feedingError", 2),
            SLEEP_STATE("sleepState", 0),
            MASTER_CTRL_STATE("masterSleepState", 3),
            POWER_CONSUME("powerConsume", 1),
            BATTERY_POWER("batteryPower", 1),
            WIFI_SIGNAL("wifiSignal", 1),
            SWITCH_STATE("chnLevel", 1),
            AUTO_LOCK("autoLock", 1),
            POWER_MODE("powerMode", 1),
            PLUG_VOLTAGE("plugVoltage", 1),
            PLUG_POWER("plugPower", 1),
            PLUG_CURRENT("plugCurrent", 1),
            LOG("log", 1),
            CHILD_LOCK_SWITCH("childLockSwitch", 1),
            INDICATOR_SWITCH("indicatorSwitch", 1),
            TIMERS("timers", 1),
            DEVICE_DEL("deviceDel", 1),
            DEVICE_ADD("deviceAdd", 1),
            COLD_AND_WARM("coldAndWarmValue", 1),
            WHITE_BRIGHTNESS("whiteBrightness", 1),
            SLIDE_CONTROL("slideControl", 1),
            COLOR_LIGHT("coloredLight", 1),
            WORK_MODE("workMode", 1);

            private final String eventId;
            private final int type;

            private DevFunStatus(String eventId, int type) {
                this.eventId = eventId;
                this.type = type;
            }

            public String getEventId() {
                return this.eventId;
            }

            public int getType() {
                return this.type;
            }
        }
    }

    public static interface AddDevConstant {
        public static final int ADD_DEV_BY_QUICK_CONFIG = 1;
        public static final int ADD_DEV_BY_4G = 2;
        public static final int ADD_DEV_BY_4G_WIRED = 10;
        public static final int ADD_DEV_BY_WIRED = 11;
        public static final int ADD_DEV_BY_SCAN_QR_CODE = 3;
        public static final int ADD_DEV_BY_AP = 4;
        public static final int ADD_DEV_BY_LAN = 5;
        public static final int ADD_DEV_BY_WBS = 6;
        public static final int RETRIEVE_PASSWORD = 7;
        public static final int ADD_DEV_BY_DVR_NVR = 8;
        public static final int ADD_IOT = 9;
        public static final int ADD_DEV_BY_BLE = 12;
        public static final int ADD_DEV_BY_WIFI = 13;
        public static final int ADD_DEV_BY_QR = 14;
        public static final int ADD_DEV_BY_PRE = 15;
    }

    public static interface PushConstant {
        public static final String IS_NEED_LINK_PUSH = "is_need_link_push";
        public static final String NOTIFICATIN_CHANNEL_ID = "AlarmPush";
        public static final String NEW_WIFI_PWD_PREFIX = "new_wifi_pwd_";
        public static final String NEW_PUSH_MSG_PREFIX = "new_push_msg_";
        public static final String NOTIFICATION_CHANNEL_DEV_NOTIFY = "jf_dev_notify";
        public static final String NOTIFICATION_XIAOMI_CHANNEL_DEV_NOTIFY = "106203";
        public static final String NOTIFICATION_CHANNEL_DEV_ALARM = "jf_dev_alarm";
        public static final String NOTIFICATION_XIAOMI_CHANNEL_DEV_ALARM = "106264";
        public static final String NOTIFICATION_CHANNEL_DEV_CALL = "jf_dev_call";
        public static final String NOTIFICATION_XIAOMI_CHANNEL_DEV_CALL = "106206";
        public static final String DEVICE_SUBSCRIBE_STATUS_PREFIX = "device_subscribe_status_";
        public static final boolean IS_PUSH_DEFAULT = true;
        public static final String SP_K_OPEN_CALL_UI = "IDR_OPEN_CALL_VIEW";
    }
}

