/*
 * Decompiled with CFR 0.152.
 */
package com.xmgl.vrsoft;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.AccelerateDecelerateInterpolator;

public class TraceRebound {
    private boolean mFinished = false;
    private double mCurrValue = 0.0;
    private ValueAnimator mAnimator = null;

    public TraceRebound(double from, double to, int duration) {
        this.mCurrValue = from;
        double tp1 = to - (to - from) / 5.0;
        this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{(float)from, (float)to, (float)tp1, (float)to});
        this.mAnimator.setDuration((long)duration);
        this.mAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                float value = ((Float)arg0.getAnimatedValue()).floatValue();
                TraceRebound.this.mCurrValue = value;
            }
        });
        this.mAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator arg0) {
            }

            public void onAnimationRepeat(Animator arg0) {
            }

            public void onAnimationEnd(Animator arg0) {
                TraceRebound.this.mFinished = true;
            }

            public void onAnimationCancel(Animator arg0) {
            }
        });
        this.mAnimator.start();
    }

    public boolean isFinish() {
        return this.mFinished;
    }

    public double getValue() {
        return this.mCurrValue;
    }
}

