/*
 * Decompiled with CFR 0.152.
 */
package com.video.opengl;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.content.res.Configuration;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.opengl.GLSurfaceView;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.video.opengl.OnPlayViewTouchListener;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class GLSurfaceView20
extends GLSurfaceView
implements GLSurfaceView.Renderer {
    private static String TAG = "GLSurfaceView20";
    private static final boolean DEBUG = false;
    private boolean surfaceCreated = false;
    private boolean openGLCreated = false;
    private boolean nativeFunctionsRegisted = false;
    private ReentrantLock nativeFunctionLock = new ReentrantLock();
    private long nativeObject = 0L;
    private int viewWidth = 0;
    private int viewHeight = 0;
    private boolean isFirst = true;
    private float minX;
    private float minY;
    private GL10 mOpenglesAgent;
    private boolean isLanscape;
    public static final float DEFAULT_MAX_SCALE = 4.0f;
    public static final float DEFAULT_MIN_SCALE = 1.0f;
    private float maxScale = 4.0f;
    private float minScale = 1.0f;
    private float total;
    private float beforeScale = 1.0f;
    private float scale = 1.0f;
    private float translationX = 0.0f;
    private float translationY = 0.0f;
    private float scaleOffsetX = 0.0f;
    private float scaleOffsetY = 0.0f;
    private View zoomChild;
    private OnPlayViewTouchListener onPlayViewTouchListener;
    private SurfaceHolder mSurfaceHolder;
    public int mStartX;
    public int mStartY;
    public int mScaleBitmapW;
    public int mScaleBitmapH;
    public int mSrcBitmapW;
    public int mSrcBitmapH;
    public float mTargetX;
    public float mTargetY;
    public float mTargetW;
    public float mTargetH;
    public float bitmapScale = 1.0f;
    private int scaleLevel = 0;
    private int LIMIT_MODE = -1;
    public boolean IS_TOP = false;
    public boolean IS_BOTTOM = false;
    public boolean IS_RIGHT = true;
    public boolean IS_LEFT = true;
    public static final int VIDEO_MODE_NONE = 0;
    public static final int VIDEO_MODE_FIT = 1;
    public static final int VIDEO_MODE_CENTER = 2;
    public static final int VIDEO_MODE_FILL = 3;
    public static final int VIDEO_MODE_CUSTOM = 4;
    public float mDensity;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private int mVideoMode = 4;
    private View.OnTouchListener mOnTouchListener;
    private int touchMode = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private boolean mTouchable = true;
    private boolean mIsHorizontalFlipOpen = false;
    private boolean mIsVerticalFlipOpen = false;
    private boolean mIs90DegreeFlipOpen = false;
    private boolean isStopZoom = false;

    public static SurfaceView CreateRenderer(Context context, boolean useOpenGLES2) {
        if (useOpenGLES2 && GLSurfaceView20.IsSupported(context)) {
            return new GLSurfaceView20(context);
        }
        return null;
    }

    public void setOnPlayViewTouchListener(OnPlayViewTouchListener listener) {
        this.onPlayViewTouchListener = listener;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        this.resetScaleInfo();
        if (newConfig.orientation == 2) {
            this.isLanscape = true;
        } else if (newConfig.orientation == 1) {
            this.isLanscape = false;
        }
        super.onConfigurationChanged(newConfig);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    private void adjustPosition() {
        this.translationX = this.between(this.translationX, (float)(-this.zoomChild.getWidth()) * (this.scale - 1.0f), 0.0f);
        this.translationY = this.between(this.translationY, (float)(-this.zoomChild.getHeight()) * (this.scale - 1.0f), 0.0f);
    }

    private float between(float now, float lower, float upper) {
        return Math.max(lower, Math.min(upper, now));
    }

    public static boolean UseOpenGL2(Object renderWindow) {
        return GLSurfaceView20.class.isInstance(renderWindow);
    }

    public GLSurfaceView20(Context context) {
        super(context);
        this.init(false, 0, 0);
        this.zoomChild = this;
        this.mSurfaceHolder = this.getHolder();
        if (this.mTouchable) {
            this.setOnTouchListener(new TouchListener());
        }
        try {
            DisplayMetrics dm = new DisplayMetrics();
            ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(dm);
            this.mDensity = dm.density;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Video show GLSurfaceView20(\u8f6f\u89e3\u7801\u663e\u793a)1");
    }

    public GLSurfaceView20(Context context, boolean translucent, int depth, int stencil) {
        super(context);
        this.init(translucent, depth, stencil);
        System.out.println("Video show GLSurfaceView20(\u8f6f\u89e3\u7801\u663e\u793a)2");
    }

    private void init(boolean translucent, int depth, int stencil) {
        if (translucent) {
            this.getHolder().setFormat(-3);
        }
        this.setEGLContextFactory(new ContextFactory());
        this.setEGLConfigChooser(translucent ? new ConfigChooser(8, 8, 8, 8, depth, stencil) : new ConfigChooser(5, 6, 5, 0, depth, stencil));
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    public void setVideoMode(int ratioMode) {
        this.mVideoMode = ratioMode;
    }

    public void setVideoSize(int vidWidth, int vidHeight) {
        this.mVideoWidth = vidWidth;
        this.mVideoHeight = vidHeight;
    }

    private static void checkEglError(String prompt, EGL10 egl) {
        int error;
        while ((error = egl.eglGetError()) != 12288) {
            Log.e((String)TAG, (String)String.format("%s: EGL error: 0x%x", prompt, error));
        }
    }

    public static boolean IsSupported(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo info = am.getDeviceConfigurationInfo();
        return info.reqGlEsVersion >= 131072;
    }

    public void onDrawFrame(GL10 gl) {
        this.nativeFunctionLock.lock();
        if (!this.nativeFunctionsRegisted || !this.surfaceCreated) {
            this.nativeFunctionLock.unlock();
            return;
        }
        if (!this.openGLCreated) {
            if (this.CreateOpenGLNative(this.nativeObject, this.viewWidth, this.viewHeight) != 0) {
                this.nativeFunctionLock.unlock();
                return;
            }
            this.openGLCreated = true;
        }
        if (this.openGLCreated) {
            gl.glClear(16640);
            gl.glClear(16384);
            if (this.mVideoMode != 4 && this.mVideoWidth > 0 && this.mVideoHeight > 0) {
                this.onDrawByVideoMode(this.viewWidth, this.viewHeight, this.mVideoWidth, this.mVideoHeight, this.mVideoMode, this.mOpenglesAgent);
            } else {
                this.onDrawByVideoMode(this.viewWidth, this.viewHeight, this.viewWidth, this.viewHeight, this.mVideoMode, this.mOpenglesAgent);
            }
            this.SetReverse(this.nativeObject, this.mIsVerticalFlipOpen ? 1 : 0, this.mIsHorizontalFlipOpen ? 1 : 0, this.mIs90DegreeFlipOpen ? 1 : 0);
            this.DrawNative(this.nativeObject);
        }
        this.nativeFunctionLock.unlock();
    }

    @Deprecated
    public void Change_RawPicture_Size(SurfaceView view, int width, int height) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, height);
        if ((float)Math.round(this.scale) == this.minScale) {
            params.leftMargin = 0;
            params.topMargin = 0;
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            if ((float)Math.round(this.scale) > this.maxScale) {
                this.scale = this.maxScale;
                return;
            }
            if (this.minX > 0.0f && this.minY > 0.0f) {
                int leftScale = (int)(this.minX / this.beforeScale * this.scale);
                int topScale = (int)(this.minY / this.beforeScale * this.scale);
                leftScale = this.viewWidth - leftScale < this.viewWidth / 3 ? this.viewWidth / 3 : leftScale;
                topScale = this.viewHeight - topScale < this.viewHeight / 3 ? this.viewHeight / 3 : topScale;
                params.leftMargin = leftScale * -1;
                params.topMargin = topScale * -1;
                view.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.viewWidth = width;
        this.viewHeight = height;
        if (this.bitmapScale == 1.0f) {
            this.mScaleBitmapH = this.viewHeight;
            this.mScaleBitmapW = this.viewWidth;
        }
        this.mOpenglesAgent.glViewport(this.mStartX, this.mStartY, this.viewWidth, this.viewHeight);
        this.surfaceCreated = true;
        this.nativeFunctionLock.lock();
        if (this.nativeFunctionsRegisted && this.CreateOpenGLNative(this.nativeObject, width, height) == 0) {
            this.openGLCreated = true;
        }
        this.nativeFunctionLock.unlock();
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.mOpenglesAgent = gl;
    }

    public void onDrawVideo(int ViewWidth, int ViewHeight, int framewidth, int frameheight) {
    }

    public void onDrawByVideoMode(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, GL10 gl) {
        if (this.mOpenglesAgent == null) {
            return;
        }
        switch (paramInt5) {
            case 0: 
            case 2: {
                float f1 = (paramInt1 > paramInt3 ? Math.abs(paramInt1 - paramInt3) : 0) / 2;
                float f2 = (paramInt2 > paramInt4 ? Math.abs(paramInt2 - paramInt4) : 0) / 2;
                float f3 = f1 + (float)paramInt3 > (float)paramInt1 ? paramInt1 : paramInt3;
                float f4 = f2 + (float)paramInt4 > (float)paramInt2 ? paramInt2 : paramInt4;
                gl.glViewport((int)f1, (int)f2, (int)f3, (int)f4);
                break;
            }
            case 1: {
                float f1 = (float)paramInt1 / (float)paramInt3;
                float f2 = (float)paramInt2 / (float)paramInt4;
                float f3 = f1 < f2 ? f1 : f2;
                float f4 = (float)paramInt3 * f3;
                float f5 = (float)paramInt4 * f3;
                float f6 = 0.0f;
                float f7 = 0.0f;
                if ((float)paramInt1 / f4 > (float)paramInt2 / f5) {
                    f6 = ((float)paramInt1 - f4) / 2.0f;
                } else {
                    f7 = ((float)paramInt2 - f5) / 2.0f;
                }
                gl.glViewport((int)(f6 + 1.0f), (int)(f7 + 1.0f), (int)(f4 - 2.0f), (int)(f5 - 2.0f));
                break;
            }
            case 3: {
                gl.glViewport(0, 0, paramInt1, paramInt2);
                break;
            }
            case 4: {
                float f1 = paramInt1 / paramInt3;
                float f2 = paramInt2 / paramInt4;
                float f3 = f1 < f2 ? f1 : f2;
                float f4 = (float)paramInt3 * f3;
                float f5 = (float)paramInt4 * f3;
                float f6 = 0.0f;
                float f7 = 0.0f;
                if ((float)paramInt1 / f4 > (float)paramInt2 / f5) {
                    f6 = ((float)paramInt1 - f4) / 2.0f;
                } else {
                    f7 = ((float)paramInt2 - f5) / 2.0f;
                }
                if (this.scaleOffsetX != 0.0f) {
                    if (((float)this.mScaleBitmapW - f4) / 2.0f > Math.abs(this.scaleOffsetX)) {
                        f6 += this.scaleOffsetX;
                    } else if ((float)this.mScaleBitmapW - f4 > 0.0f) {
                        f6 = this.scaleOffsetX > 0.0f ? (f6 += ((float)this.mScaleBitmapW - f4) / 2.0f) : (f6 -= ((float)this.mScaleBitmapW - f4) / 2.0f);
                    }
                }
                if (this.scaleOffsetY != 0.0f) {
                    if (((float)this.mScaleBitmapH - f5) / 2.0f > Math.abs(this.scaleOffsetY)) {
                        f7 += this.scaleOffsetY;
                    } else if ((float)this.mScaleBitmapH - f5 > 0.0f) {
                        f7 = this.scaleOffsetY > 0.0f ? (f7 += ((float)this.mScaleBitmapH - f5) / 2.0f) : (f7 -= ((float)this.mScaleBitmapH - f5) / 2.0f);
                    }
                }
                this.mTargetX = f6;
                this.mTargetY = f7;
                this.mTargetW = f4;
                this.mTargetH = f5;
                this.mSrcBitmapW = paramInt3;
                this.mSrcBitmapH = paramInt4;
                gl.glViewport((int)(f6 + 1.0f + (float)this.mStartX), (int)(f7 + 1.0f + (float)this.mStartY), this.mScaleBitmapW, this.mScaleBitmapH);
            }
        }
    }

    public void resetScaleInfo() {
        this.bitmapScale = 1.0f;
        this.mStartY = 0;
        this.mStartX = 0;
    }

    public void RegisterNativeObject(long nativeObject) {
        this.nativeFunctionLock.lock();
        this.nativeObject = nativeObject;
        this.nativeFunctionsRegisted = true;
        this.nativeFunctionLock.unlock();
    }

    public void DeRegisterNativeObject() {
        this.nativeFunctionLock.lock();
        this.nativeFunctionsRegisted = false;
        this.openGLCreated = false;
        this.nativeObject = 0L;
        this.nativeFunctionLock.unlock();
    }

    public void ReDraw() {
        this.requestRender();
    }

    private native int CreateOpenGLNative(long var1, int var3, int var4);

    private native void DrawNative(long var1);

    public void cleanUp() {
        this.DeRegisterNativeObject();
    }

    private native void SetReverse(long var1, int var3, int var4, int var5);

    public void setHorizontalFlip(boolean isOpen) {
        this.mIsHorizontalFlipOpen = isOpen;
    }

    public void setVerticalFlip(boolean isOpen) {
        this.mIsVerticalFlipOpen = isOpen;
    }

    public void set90DegreeFlip(boolean isOpen) {
        this.mIs90DegreeFlipOpen = isOpen;
    }

    public void setGestureListener(View.OnTouchListener onTouchListener) {
        this.mOnTouchListener = onTouchListener;
    }

    public void setScaleLevel(int scaleLevel) {
        this.scaleLevel = scaleLevel;
        this.ReDraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(float scale) {
        GLSurfaceView20 gLSurfaceView20 = this;
        synchronized (gLSurfaceView20) {
            System.out.println("setScale:" + scale);
            if (this.scaleLevel > 0) {
                float changeScale = (float)this.scaleLevel * this.maxScale;
                scale /= changeScale;
            }
            this.bitmapScale = scale;
            this.mScaleBitmapW = (int)((float)this.viewWidth * scale);
            this.mScaleBitmapH = (int)((float)this.viewHeight * scale);
            this.mStartX = (this.viewWidth - this.mScaleBitmapW) / 2;
            this.mStartY = (this.viewHeight - this.mScaleBitmapH) / 2;
        }
    }

    public void setMaxScale(float maxScale) {
        this.maxScale = maxScale;
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public void setMinScale(float minScale) {
        this.minScale = minScale;
    }

    public float getMinScale() {
        return this.minScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopZoom(boolean isStop) {
        GLSurfaceView20 gLSurfaceView20 = this;
        synchronized (gLSurfaceView20) {
            this.isStopZoom = isStop;
        }
    }

    public void setScaleOffsetX(float offsetX) {
        this.scaleOffsetX = offsetX;
    }

    public void setScaleOffsetY(float offsetY) {
        this.scaleOffsetY = offsetY;
    }

    public void setTouchable(boolean isTouchable) {
        this.mTouchable = isTouchable;
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] s_configAttribs2 = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        private int[] mValue = new int[1];

        public ConfigChooser(int r, int g, int b, int a, int depth, int stencil) {
            this.mRedSize = r;
            this.mGreenSize = g;
            this.mBlueSize = b;
            this.mAlphaSize = a;
            this.mDepthSize = depth;
            this.mStencilSize = stencil;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            egl.eglChooseConfig(display, s_configAttribs2, null, 0, num_config);
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            egl.eglChooseConfig(display, s_configAttribs2, configs, numConfigs, num_config);
            return this.chooseConfig(egl, display, configs);
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            EGLConfig[] eGLConfigArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                EGLConfig config = eGLConfigArray[n2];
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d >= this.mDepthSize && s >= this.mStencilSize) {
                    int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                    int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                    int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                    int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                    if (r == this.mRedSize && g == this.mGreenSize && b == this.mBlueSize && a == this.mAlphaSize) {
                        return config;
                    }
                }
                ++n2;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }

        private void printConfigs(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            int numConfigs = configs.length;
            Log.w((String)TAG, (String)String.format("%d configurations", numConfigs));
            int i = 0;
            while (i < numConfigs) {
                Log.w((String)TAG, (String)String.format("Configuration %d:\n", i));
                this.printConfig(egl, display, configs[i]);
                ++i;
            }
        }

        private void printConfig(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attributes = new int[]{12320, 12321, 12322, 12323, 12324, 12325, 12326, 12327, 12328, 12329, 12330, 12331, 12332, 12333, 12334, 12335, 12336, 12337, 12338, 12339, 12340, 12343, 12342, 12341, 12345, 12346, 12347, 12348, 12349, 12350, 12351, 12352, 12354};
            String[] names = new String[]{"EGL_BUFFER_SIZE", "EGL_ALPHA_SIZE", "EGL_BLUE_SIZE", "EGL_GREEN_SIZE", "EGL_RED_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_CONFIG_CAVEAT", "EGL_CONFIG_ID", "EGL_LEVEL", "EGL_MAX_PBUFFER_HEIGHT", "EGL_MAX_PBUFFER_PIXELS", "EGL_MAX_PBUFFER_WIDTH", "EGL_NATIVE_RENDERABLE", "EGL_NATIVE_VISUAL_ID", "EGL_NATIVE_VISUAL_TYPE", "EGL_PRESERVED_RESOURCES", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_SURFACE_TYPE", "EGL_TRANSPARENT_TYPE", "EGL_TRANSPARENT_RED_VALUE", "EGL_TRANSPARENT_GREEN_VALUE", "EGL_TRANSPARENT_BLUE_VALUE", "EGL_BIND_TO_TEXTURE_RGB", "EGL_BIND_TO_TEXTURE_RGBA", "EGL_MIN_SWAP_INTERVAL", "EGL_MAX_SWAP_INTERVAL", "EGL_LUMINANCE_SIZE", "EGL_ALPHA_MASK_SIZE", "EGL_COLOR_BUFFER_TYPE", "EGL_RENDERABLE_TYPE", "EGL_CONFORMANT"};
            int[] value = new int[1];
            int i = 0;
            while (i < attributes.length) {
                int attribute = attributes[i];
                String name = names[i];
                if (egl.eglGetConfigAttrib(display, config, attribute, value)) {
                    Log.w((String)TAG, (String)String.format("  %s: %d\n", name, value[0]));
                } else {
                    while (egl.eglGetError() != 12288) {
                    }
                }
                ++i;
            }
        }
    }

    private static class ContextFactory
    implements GLSurfaceView.EGLContextFactory {
        private static int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private ContextFactory() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig eglConfig) {
            Log.w((String)TAG, (String)"creating OpenGL ES 2.0 context");
            GLSurfaceView20.checkEglError("Before eglCreateContext", egl);
            int[] attrib_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
            EGLContext context = egl.eglCreateContext(display, eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
            GLSurfaceView20.checkEglError("After eglCreateContext", egl);
            return context;
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            egl.eglDestroyContext(display, context);
        }
    }

    class TouchListener
    implements View.OnTouchListener {
        private PointF startPoint = new PointF();
        private Matrix matrix = new Matrix();
        private Matrix currentMatrix = new Matrix();
        private float startDis;
        private PointF midPoint;
        private int m_offset = 10;
        private float preScale;
        private float fingerScale = 0.0f;
        private int level = 0;
        private static final float MIN_SPCE = 10.0f;
        private static final int MIN_DISTANCE = 0;
        private float oldDist = 1.0f;
        private PointF start = new PointF();
        private PointF mid = new PointF();
        PointF startOffset = new PointF();

        TouchListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onTouch(View v, MotionEvent event) {
            if (GLSurfaceView20.this.mOnTouchListener != null) {
                GLSurfaceView20.this.mOnTouchListener.onTouch(v, event);
            }
            if (!GLSurfaceView20.this.mTouchable) {
                return false;
            }
            switch (event.getAction() & 0xFF) {
                case 0: {
                    System.out.println(String.valueOf(TAG) + "--->ACTION_DOWN");
                    GLSurfaceView20.this.touchMode = 1;
                    TouchListener touchListener = this;
                    synchronized (touchListener) {
                        if (GLSurfaceView20.this.isStopZoom) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    this.preScale = GLSurfaceView20.this.bitmapScale;
                    this.fingerScale = 0.0f;
                    this.level = GLSurfaceView20.this.scaleLevel;
                    System.out.println("onTouch:" + this.preScale + " " + this.level);
                    if (GLSurfaceView20.this.bitmapScale == 1.0f) {
                        GLSurfaceView20.this.IS_TOP = false;
                        GLSurfaceView20.this.IS_RIGHT = false;
                    }
                    this.start.set(event.getX(), event.getY());
                    this.startOffset.set((float)GLSurfaceView20.this.mStartX, (float)GLSurfaceView20.this.mStartY);
                    if (GLSurfaceView20.this.onPlayViewTouchListener == null) break;
                    GLSurfaceView20.this.onPlayViewTouchListener.onScale(this.fingerScale, GLSurfaceView20.this.bitmapScale, v, event);
                    break;
                }
                case 2: {
                    if (GLSurfaceView20.this.touchMode == 1) {
                        System.out.println(String.valueOf(TAG) + "--->ACTION_DRAG-->" + GLSurfaceView20.this.bitmapScale);
                        if ((double)GLSurfaceView20.this.bitmapScale > 1.0) {
                            int h;
                            int w;
                            float dtX = event.getX() - this.start.x;
                            float dtY = event.getY() - this.start.y;
                            this.start.set(event.getX(), event.getY());
                            GLSurfaceView20.this.mStartX = (int)((float)GLSurfaceView20.this.mStartX + dtX);
                            GLSurfaceView20.this.mStartY = (int)((float)GLSurfaceView20.this.mStartY - dtY);
                            if (dtX > 0.0f) {
                                if (GLSurfaceView20.this.mScaleBitmapW < GLSurfaceView20.this.viewWidth) {
                                    if ((float)GLSurfaceView20.this.viewWidth - (GLSurfaceView20.this.mTargetX + (float)GLSurfaceView20.this.mStartX + (float)GLSurfaceView20.this.mScaleBitmapW) < 0.0f) {
                                        GLSurfaceView20.this.mStartX = GLSurfaceView20.this.viewWidth - (int)(GLSurfaceView20.this.mTargetX + (float)GLSurfaceView20.this.mScaleBitmapW) - 0;
                                    }
                                } else {
                                    w = GLSurfaceView20.this.mScaleBitmapW - GLSurfaceView20.this.viewWidth + 0;
                                    if ((float)(GLSurfaceView20.this.viewWidth + w) - (GLSurfaceView20.this.mTargetX + (float)GLSurfaceView20.this.mStartX + (float)GLSurfaceView20.this.mScaleBitmapW) < 0.0f) {
                                        GLSurfaceView20.this.mStartX = GLSurfaceView20.this.viewWidth + w - (int)(GLSurfaceView20.this.mTargetX + (float)GLSurfaceView20.this.mScaleBitmapW);
                                        GLSurfaceView20.this.IS_LEFT = true;
                                    } else {
                                        GLSurfaceView20.this.IS_LEFT = false;
                                    }
                                }
                            } else if (GLSurfaceView20.this.mScaleBitmapW < GLSurfaceView20.this.viewWidth) {
                                if (GLSurfaceView20.this.mTargetX - (float)Math.abs(GLSurfaceView20.this.mStartX) < 0.0f) {
                                    GLSurfaceView20.this.mStartX = (int)(-(GLSurfaceView20.this.mTargetX - 0.0f));
                                }
                            } else {
                                w = GLSurfaceView20.this.mScaleBitmapW - GLSurfaceView20.this.viewWidth;
                                if (GLSurfaceView20.this.mTargetX + (float)w - (float)Math.abs(GLSurfaceView20.this.mStartX) < 0.0f) {
                                    GLSurfaceView20.this.IS_RIGHT = true;
                                    GLSurfaceView20.this.mStartX = (int)(-(GLSurfaceView20.this.mTargetX + (float)w));
                                } else {
                                    GLSurfaceView20.this.IS_RIGHT = false;
                                }
                                System.out.println(String.valueOf(TAG) + "--->ACTION_LEFT-->mStartX==" + GLSurfaceView20.this.mStartX + "mTargetX-->" + GLSurfaceView20.this.mTargetX + "viewWidth-->" + GLSurfaceView20.this.viewWidth + "mScaleBitmapW - viewWidth->" + w);
                            }
                            if (dtY > 0.0f) {
                                System.out.println(String.valueOf(TAG) + "--->ACTION_DRAG-->dtY" + dtY);
                                if (GLSurfaceView20.this.mScaleBitmapH < GLSurfaceView20.this.viewHeight) {
                                    if (GLSurfaceView20.this.mTargetY - (float)Math.abs(GLSurfaceView20.this.mStartY) < 0.0f) {
                                        GLSurfaceView20.this.mStartY = (int)(-(GLSurfaceView20.this.mTargetY - 0.0f));
                                    }
                                } else {
                                    h = GLSurfaceView20.this.mScaleBitmapH - GLSurfaceView20.this.viewHeight + 0;
                                    GLSurfaceView20.this.IS_TOP = GLSurfaceView20.this.mTargetY + (float)h - (float)Math.abs(GLSurfaceView20.this.mStartY) < 0.0f;
                                    if (GLSurfaceView20.this.mTargetY + (float)h - (float)Math.abs(GLSurfaceView20.this.mStartY) < 0.0f) {
                                        GLSurfaceView20.this.mStartY = (int)(-(GLSurfaceView20.this.mTargetY + (float)h));
                                        System.out.println(String.valueOf(TAG) + "--->ACTION_DRAG-->mStartY==" + GLSurfaceView20.this.mStartY);
                                    }
                                }
                            } else if (GLSurfaceView20.this.mScaleBitmapH < GLSurfaceView20.this.viewHeight) {
                                if ((float)GLSurfaceView20.this.viewHeight - (GLSurfaceView20.this.mTargetY + (float)GLSurfaceView20.this.mStartY + (float)GLSurfaceView20.this.mScaleBitmapH) < 0.0f) {
                                    GLSurfaceView20.this.mStartY = GLSurfaceView20.this.viewHeight - (int)(GLSurfaceView20.this.mTargetY + (float)GLSurfaceView20.this.mScaleBitmapH) - 0;
                                }
                            } else {
                                h = GLSurfaceView20.this.mScaleBitmapH - GLSurfaceView20.this.viewHeight + 0;
                                Log.i((String)"Drag-->Up", (String)("mTargetY=" + GLSurfaceView20.this.mTargetY));
                                if ((float)(GLSurfaceView20.this.viewHeight + h) - (GLSurfaceView20.this.mTargetY + (float)GLSurfaceView20.this.mStartY + (float)GLSurfaceView20.this.mScaleBitmapH) < 0.0f) {
                                    GLSurfaceView20.this.mStartY = GLSurfaceView20.this.viewHeight + h - (int)(GLSurfaceView20.this.mTargetY + (float)GLSurfaceView20.this.mScaleBitmapH);
                                }
                                GLSurfaceView20.this.IS_BOTTOM = (float)(GLSurfaceView20.this.viewHeight + h) - (GLSurfaceView20.this.mTargetY + (float)GLSurfaceView20.this.mStartY + (float)GLSurfaceView20.this.mScaleBitmapH) < 0.0f;
                            }
                            if (GLSurfaceView20.this.onPlayViewTouchListener != null) {
                                GLSurfaceView20.this.onPlayViewTouchListener.onBoundary(GLSurfaceView20.this.IS_LEFT, GLSurfaceView20.this.IS_RIGHT);
                            }
                        }
                        if (GLSurfaceView20.this.onPlayViewTouchListener == null) break;
                        GLSurfaceView20.this.onPlayViewTouchListener.onScale(-1.0f, GLSurfaceView20.this.bitmapScale, v, event);
                        break;
                    }
                    if (GLSurfaceView20.this.touchMode != 2 || GLSurfaceView20.this.isStopZoom) break;
                    float newDist = this.spacing(event);
                    if (newDist > 10.0f) {
                        this.fingerScale = newDist / this.oldDist * this.preScale + (float)this.level * (GLSurfaceView20.this.maxScale - 1.0f);
                        System.out.println("fingerScale:" + this.fingerScale + "scaleLevel:" + this.level + " dist:" + newDist / this.oldDist + " preScale:" + this.preScale);
                        this.fingerScale = Math.max(this.fingerScale, GLSurfaceView20.this.minScale);
                        this.dealWithScale(this.fingerScale);
                    }
                    if (GLSurfaceView20.this.onPlayViewTouchListener == null) break;
                    GLSurfaceView20.this.onPlayViewTouchListener.onScale(this.fingerScale, GLSurfaceView20.this.bitmapScale, v, event);
                    break;
                }
                case 1: {
                    if (GLSurfaceView20.this.onPlayViewTouchListener != null) {
                        GLSurfaceView20.this.onPlayViewTouchListener.onScale(this.fingerScale, GLSurfaceView20.this.bitmapScale, v, event);
                    }
                    GLSurfaceView20.this.touchMode = 0;
                    if (!((double)GLSurfaceView20.this.bitmapScale <= 1.0)) break;
                    GLSurfaceView20.this.resetScaleInfo();
                    break;
                }
                case 6: {
                    GLSurfaceView20.this.touchMode = 0;
                    if (!((double)GLSurfaceView20.this.bitmapScale <= 1.0)) break;
                    GLSurfaceView20.this.resetScaleInfo();
                    break;
                }
                case 5: {
                    this.oldDist = this.spacing(event);
                    if (!(this.oldDist > 10.0f)) break;
                    this.midPoint(this.mid, event);
                    GLSurfaceView20.this.touchMode = 2;
                }
            }
            return true;
        }

        private void dealWithScale(float scale) {
            scale = Math.min(scale, GLSurfaceView20.this.maxScale);
            scale = Math.max(scale, GLSurfaceView20.this.minScale);
            System.out.println("scale:" + scale + "preScale:" + this.preScale);
            GLSurfaceView20.this.bitmapScale = scale;
            GLSurfaceView20.this.mScaleBitmapW = (int)((float)GLSurfaceView20.this.viewWidth * GLSurfaceView20.this.bitmapScale);
            GLSurfaceView20.this.mScaleBitmapH = (int)((float)GLSurfaceView20.this.viewHeight * GLSurfaceView20.this.bitmapScale);
            float dtX = (scale - this.preScale) * (float)GLSurfaceView20.this.mSrcBitmapW / 2.0f;
            float dtY = (scale - this.preScale) * (float)GLSurfaceView20.this.mSrcBitmapH / 2.0f;
            if (GLSurfaceView20.this.bitmapScale == 1.0f) {
                GLSurfaceView20.this.IS_RIGHT = true;
                GLSurfaceView20.this.IS_LEFT = true;
            } else {
                GLSurfaceView20.this.IS_RIGHT = false;
                GLSurfaceView20.this.IS_LEFT = false;
            }
            if (GLSurfaceView20.this.bitmapScale != 1.0f && (float)(GLSurfaceView20.this.mScaleBitmapH - GLSurfaceView20.this.viewHeight) - Math.abs(this.startOffset.y - dtY) < 0.0f) {
                GLSurfaceView20.this.IS_TOP = true;
            }
            if (GLSurfaceView20.this.bitmapScale != 1.0f && (float)(GLSurfaceView20.this.mScaleBitmapW - GLSurfaceView20.this.viewWidth) - Math.abs(this.startOffset.x - dtX) < 0.0f) {
                GLSurfaceView20.this.IS_RIGHT = true;
            }
            if (GLSurfaceView20.this.IS_TOP) {
                GLSurfaceView20.this.mStartY = -(GLSurfaceView20.this.mScaleBitmapH - GLSurfaceView20.this.viewHeight);
            } else if (GLSurfaceView20.this.mStartY <= 0) {
                GLSurfaceView20.this.mStartY = (int)(this.startOffset.y - dtY);
            }
            if (GLSurfaceView20.this.IS_RIGHT) {
                GLSurfaceView20.this.mStartX = -(GLSurfaceView20.this.mScaleBitmapW - GLSurfaceView20.this.viewWidth);
            } else if (GLSurfaceView20.this.mStartX <= 0) {
                GLSurfaceView20.this.mStartX = (int)(this.startOffset.x - dtX);
            }
        }

        public float spacing(MotionEvent event) {
            float x = event.getX(0) - event.getX(1);
            float y = event.getY(0) - event.getY(1);
            return (float)Math.sqrt(x * x + y * y);
        }

        public void midPoint(PointF point, MotionEvent event) {
            float x = event.getX(0) + event.getX(1);
            float y = event.getY(0) + event.getY(1);
            point.set(x / 2.0f, y / 2.0f);
        }
    }
}

