/*
 * Decompiled with CFR 0.152.
 */
package com.lib.decoder;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.SurfaceTexture;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.lib.decoder.XMediaDec;
import com.video.opengl.OnPlayViewTouchListener;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

@SuppressLint(value={"NewApi"})
public class VideoDecoder
extends GLSurfaceView
implements SurfaceHolder.Callback,
View.OnTouchListener {
    public static final String TAG = "VideoDecoder";
    public static final int VIDEO_MODE_NONE = 0;
    public static final int VIDEO_MODE_FIT = 1;
    public static final int VIDEO_MODE_CENTER = 2;
    public static final int VIDEO_MODE_FILL = 3;
    public static final int VIDEO_MODE_CUSTOM = 4;
    private float scale = 1.0f;
    private float translationX = 0.0f;
    private float translationY = 0.0f;
    private float scaleOffsetX = 0.0f;
    private float scaleOffsetY = 0.0f;
    private View zoomChild;
    private OnPlayViewTouchListener listener;
    private int mStartX;
    private int mStartY;
    private int mScaleBitmapW;
    private int mScaleBitmapH;
    private int mSrcBitmapW;
    private int mSrcBitmapH;
    private float mTargetX;
    private float mTargetY;
    private float mTargetW;
    private float mTargetH;
    private float bitmapScale = 1.0f;
    private float fingerScale;
    private int LIMIT_MODE = -1;
    private boolean IS_TOP = false;
    private boolean IS_BOTTOM = false;
    private boolean IS_RIGHT = false;
    private boolean IS_LEFT = false;
    private boolean _bSFCreate = false;
    private OnHardDecorderResultListener mOnHardDecorderResultListener;
    private HardDecodeRenderer mRenderer;
    private SurfaceTexture videoTexture = null;
    int[] textures = new int[1];
    private ReentrantLock nativeFunctionLock = new ReentrantLock();
    XMediaDec _mediaDec;
    private int mode = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private static final float MAX_SCALE = 4.0f;
    private static final float MIN_SCALE = 1.0f;
    private static final float MIN_SPCE = 10.0f;
    private static final int MIN_DISTANCE = 0;
    private float preScale;
    private float oldDist = 1.0f;
    private PointF start = new PointF();
    private PointF mid = new PointF();
    private PointF startOffset = new PointF();
    private int viewWidth = 0;
    private int viewHeight = 0;
    private GestureDetector mDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            VideoDecoder videoDecoder = VideoDecoder.this;
            videoDecoder.translationX = videoDecoder.translationX - distanceX;
            VideoDecoder videoDecoder2 = VideoDecoder.this;
            videoDecoder2.translationY = videoDecoder2.translationY - distanceY;
            VideoDecoder.this.translationX = VideoDecoder.this.between(VideoDecoder.this.translationX, (float)(-VideoDecoder.this.zoomChild.getWidth() / 2) * (VideoDecoder.this.scale - 1.0f), 0.0f);
            VideoDecoder.this.translationY = VideoDecoder.this.between(VideoDecoder.this.translationY, (float)(-VideoDecoder.this.zoomChild.getHeight() / 2) * (VideoDecoder.this.scale - 1.0f), 0.0f);
            if (VideoDecoder.this.listener != null) {
                VideoDecoder.this.listener.onTrans(VideoDecoder.this.translationX + VideoDecoder.this.scaleOffsetX, VideoDecoder.this.translationY + VideoDecoder.this.scaleOffsetY);
            }
            return false;
        }
    });
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n";
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private int mProgram;
    private int muMVPMatrixHandle;
    private int muSTMatrixHandle;
    private int maPositionHandle;
    private int maTextureHandle;
    private final float[] mTriangleVerticesData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int TRIANGLE_VERTICES_DATA_STRIDE_BYTES = 20;
    private static final int TRIANGLE_VERTICES_DATA_POS_OFFSET = 0;
    private static final int TRIANGLE_VERTICES_DATA_UV_OFFSET = 3;
    private float[] mSTMatrix = new float[16];
    private FloatBuffer mTriangleVertices;
    private float[] mMVPMatrix = new float[16];

    public VideoDecoder(Context context) {
        super(context);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.setOnTouchListener(this);
        this.zoomChild = this;
        this.setEGLContextClientVersion(2);
        this.setPreserveEGLContextOnPause(true);
        this.mRenderer = new HardDecodeRenderer();
        this.setRenderer(this.mRenderer);
        this.setRenderMode(0);
        System.out.println("Video show VideoDecoder(\u786c\u89e3\u7801\u663e\u793a)");
        this._mediaDec = new XMediaDec();
    }

    private boolean checkIsTSmall(int x, int y, int w, int h) {
        int w2 = w + x;
        int h2 = h + y;
        return w2 < this.viewWidth || h2 < this.viewHeight;
    }

    public void setOnHardDecorderResultListener(OnHardDecorderResultListener hardDecorderResultListener) {
        this.mOnHardDecorderResultListener = hardDecorderResultListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int InputData(int[] pFrameInfo, byte[] pBuffer) {
        VideoDecoder videoDecoder = this;
        synchronized (videoDecoder) {
            block5: {
                if (this._bSFCreate && this.videoTexture != null) break block5;
                return 0;
            }
            int nRet = this._mediaDec.InputData(pFrameInfo, pBuffer);
            if (nRet == 0) {
                this.mSrcBitmapW = this._mediaDec.GetWidth();
                this.mSrcBitmapH = this._mediaDec.GetHeight();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceChanged(SurfaceHolder arg0, int arg1, int arg2, int arg3) {
        super.surfaceChanged(arg0, arg1, arg2, arg3);
        VideoDecoder videoDecoder = this;
        synchronized (videoDecoder) {
            this.CloseDec();
            this._bSFCreate = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceCreated(SurfaceHolder sh) {
        super.surfaceCreated(sh);
        VideoDecoder videoDecoder = this;
        synchronized (videoDecoder) {
            this._bSFCreate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed(SurfaceHolder sh) {
        VideoDecoder videoDecoder = this;
        synchronized (videoDecoder) {
            this._bSFCreate = false;
            this.CloseDec();
        }
        super.surfaceDestroyed(sh);
    }

    public void CloseDec() {
        this._mediaDec.CloseDec();
    }

    private synchronized void refreshFrame() {
        if (this.videoTexture == null) {
            return;
        }
        this.requestRender();
    }

    public void setOnZoomListener(OnPlayViewTouchListener listener) {
        this.listener = listener;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.mode = 1;
                this.preScale = this.bitmapScale;
                if (this.bitmapScale == 1.0f) {
                    this.IS_TOP = false;
                    this.IS_RIGHT = false;
                }
                this.start.set(event.getX(), event.getY());
                this.startOffset.set((float)this.mStartX, (float)this.mStartY);
                if (this.listener == null) break;
                this.listener.onScale(this.fingerScale, this.bitmapScale, v, event);
                break;
            }
            case 2: {
                float newDist;
                if (this.listener != null) {
                    this.listener.onScale(this.fingerScale, this.bitmapScale, v, event);
                }
                if (this.mode == 1) {
                    int h;
                    int w;
                    if (!((double)this.bitmapScale > 1.0)) break;
                    float dtX = event.getX() - this.start.x;
                    float dtY = event.getY() - this.start.y;
                    boolean needReDraw = false;
                    if (dtX > 1.0f || dtY > 1.0f) {
                        needReDraw = true;
                    }
                    this.start.set(event.getX(), event.getY());
                    this.mStartX = (int)((float)this.mStartX + dtX);
                    this.mStartY = (int)((float)this.mStartY - dtY);
                    if (dtX > 0.0f) {
                        if (this.mScaleBitmapW < this.viewWidth) {
                            if ((float)this.viewWidth - (this.mTargetX + (float)this.mStartX + (float)this.mScaleBitmapW) < 0.0f) {
                                this.mStartX = this.viewWidth - (int)(this.mTargetX + (float)this.mScaleBitmapW) - 0;
                            }
                        } else {
                            w = this.mScaleBitmapW - this.viewWidth + 0;
                            if ((float)(this.viewWidth + w) - (this.mTargetX + (float)this.mStartX + (float)this.mScaleBitmapW) < 0.0f) {
                                this.mStartX = this.viewWidth + w - (int)(this.mTargetX + (float)this.mScaleBitmapW);
                                this.IS_LEFT = true;
                            } else {
                                this.IS_LEFT = false;
                            }
                        }
                    } else if (this.mScaleBitmapW < this.viewWidth) {
                        if (this.mTargetX - (float)Math.abs(this.mStartX) < 0.0f) {
                            this.mStartX = (int)(-(this.mTargetX - 0.0f));
                        }
                    } else {
                        w = this.mScaleBitmapW - this.viewWidth + 0;
                        this.IS_RIGHT = this.mTargetX + (float)w - (float)Math.abs(this.mStartX) < 0.0f;
                        if (this.mTargetX + (float)w - (float)Math.abs(this.mStartX) < 0.0f) {
                            this.mStartX = (int)(-(this.mTargetX + (float)w));
                        }
                    }
                    if (dtY > 0.0f) {
                        if (this.mScaleBitmapH < this.viewHeight) {
                            if (this.mTargetY - (float)Math.abs(this.mStartY) < 0.0f) {
                                this.mStartY = (int)(-(this.mTargetY - 0.0f));
                            }
                        } else {
                            h = this.mScaleBitmapH - this.viewHeight + 0;
                            this.IS_TOP = this.mTargetY + (float)h - (float)Math.abs(this.mStartY) < 0.0f;
                            if (this.mTargetY + (float)h - (float)Math.abs(this.mStartY) < 0.0f) {
                                this.mStartY = (int)(-(this.mTargetY + (float)h));
                            }
                        }
                    } else if (this.mScaleBitmapH < this.viewHeight) {
                        if ((float)this.viewHeight - (this.mTargetY + (float)this.mStartY + (float)this.mScaleBitmapH) < 0.0f) {
                            this.mStartY = this.viewHeight - (int)(this.mTargetY + (float)this.mScaleBitmapH) - 0;
                        }
                    } else {
                        h = this.mScaleBitmapH - this.viewHeight + 0;
                        if ((float)(this.viewHeight + h) - (this.mTargetY + (float)this.mStartY + (float)this.mScaleBitmapH) < 0.0f) {
                            this.mStartY = this.viewHeight + h - (int)(this.mTargetY + (float)this.mScaleBitmapH);
                        }
                        this.IS_BOTTOM = (float)(this.viewHeight + h) - (this.mTargetY + (float)this.mStartY + (float)this.mScaleBitmapH) < 0.0f;
                    }
                    if (!needReDraw) break;
                    this.refreshFrame();
                    break;
                }
                if (this.mode != 2 || !((newDist = this.spacing(event)) > 10.0f)) break;
                this.fingerScale = newDist / this.oldDist * this.preScale;
                float scale = Math.min(this.fingerScale, 4.0f);
                scale = Math.max(this.fingerScale, 1.0f);
                boolean needReDraw = (double)Math.abs(this.bitmapScale - scale) > 0.1;
                this.bitmapScale = scale;
                if (this.listener != null) {
                    this.listener.onScale(this.fingerScale, this.bitmapScale, v, event);
                }
                this.mScaleBitmapW = (int)((float)this.viewWidth * this.bitmapScale);
                this.mScaleBitmapH = (int)((float)this.viewHeight * this.bitmapScale);
                float dtX = (scale - this.preScale) * (float)this.mSrcBitmapW / 2.0f;
                float dtY = (scale - this.preScale) * (float)this.mSrcBitmapH / 2.0f;
                if (this.bitmapScale != 1.0f && (float)(this.mScaleBitmapH - this.viewHeight) - Math.abs(this.startOffset.y - dtY) < 0.0f) {
                    this.IS_TOP = true;
                }
                if (this.bitmapScale != 1.0f && (float)(this.mScaleBitmapW - this.viewWidth) - Math.abs(this.startOffset.x - dtX) < 0.0f) {
                    this.IS_RIGHT = true;
                }
                if (this.IS_TOP) {
                    this.mStartY = -(this.mScaleBitmapH - this.viewHeight);
                } else if (this.mStartY <= 0) {
                    this.mStartY = (int)(this.startOffset.y - dtY);
                }
                if (this.IS_RIGHT) {
                    this.mStartX = -(this.mScaleBitmapW - this.viewWidth);
                } else if (this.mStartX <= 0) {
                    this.mStartX = (int)(this.startOffset.x - dtX);
                }
                if (!needReDraw) break;
                this.refreshFrame();
                break;
            }
            case 1: {
                if (this.listener != null) {
                    this.listener.onScale(this.fingerScale, this.bitmapScale, v, event);
                }
                this.mode = 0;
                if (!((double)this.bitmapScale <= 1.0)) break;
                this.resetScaleInfo();
                break;
            }
            case 6: {
                this.mode = 0;
                if (!((double)this.bitmapScale <= 1.0)) break;
                this.resetScaleInfo();
                break;
            }
            case 5: {
                this.oldDist = this.spacing(event);
                if (!(this.oldDist > 10.0f)) break;
                this.midPoint(this.mid, event);
                this.mode = 2;
            }
        }
        return this.mDetector.onTouchEvent(event);
    }

    public float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    public void midPoint(PointF point, MotionEvent event) {
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.set(x / 2.0f, y / 2.0f);
    }

    public void resetScaleInfo() {
        this.bitmapScale = 1.0f;
        this.mStartY = 0;
        this.mStartX = 0;
    }

    private float between(float now, float lower, float upper) {
        return Math.max(lower, Math.min(upper, now));
    }

    public void changeStream() {
        this.mStartX = 0;
        this.mScaleBitmapW = this.viewWidth;
        this.mStartY = 0;
        this.mScaleBitmapH = this.viewHeight;
        this.bitmapScale = 1.0f;
    }

    public void change_RawPicture_Size(SurfaceView view, int width, int height) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, height);
        if ((float)Math.round(this.scale) == 1.0f) {
            params.leftMargin = 0;
            params.topMargin = 0;
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        } else if ((float)Math.round(this.scale) > 4.0f) {
            this.scale = 4.0f;
            return;
        }
    }

    public void changeSurfaceViewRatio(float ratio) {
        int width = (int)(ratio * (float)this.getWidth());
        int height = (int)(ratio * (float)this.getHeight());
        this.change_RawPicture_Size((SurfaceView)this, width, height);
    }

    private static MediaCodecInfo selectCodec(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        int i = 0;
        while (i < numCodecs) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (codecInfo.isEncoder()) {
                String[] types = codecInfo.getSupportedTypes();
                int j = 0;
                while (j < types.length) {
                    if (types[j].equalsIgnoreCase(mimeType)) {
                        return codecInfo;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private static int findNonSurfaceColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType(mimeType);
        int i = 0;
        while (i < capabilities.colorFormats.length) {
            int colorFormat = capabilities.colorFormats[i];
            if (colorFormat != 2130708361) {
                return colorFormat;
            }
            ++i;
        }
        return 0;
    }

    private int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        this.checkGlError("glCreateShader type=" + shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Log.e((String)TAG, (String)("Could not compile shader " + shaderType + ":"));
            Log.e((String)TAG, (String)(" " + GLES20.glGetShaderInfoLog((int)shader)));
            GLES20.glDeleteShader((int)shader);
            shader = 0;
        }
        return shader;
    }

    private int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = this.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int pixelShader = this.loadShader(35632, fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        this.checkGlError("glCreateProgram");
        if (program == 0) {
            Log.e((String)TAG, (String)"Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vertexShader);
        this.checkGlError("glAttachShader");
        GLES20.glAttachShader((int)program, (int)pixelShader);
        this.checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            Log.e((String)TAG, (String)"Could not link program: ");
            Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)program));
            GLES20.glDeleteProgram((int)program);
            program = 0;
        }
        return program;
    }

    private void setupGraphics() {
        this.mProgram = this.createProgram(VERTEX_SHADER, FRAGMENT_SHADER);
        if (this.mProgram == 0) {
            throw new RuntimeException("failed creating program");
        }
        this.maPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aPosition");
        this.checkGlError("glGetAttribLocation aPosition");
        if (this.maPositionHandle == -1) {
            throw new RuntimeException("Could not get attrib location for aPosition");
        }
        this.maTextureHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTextureCoord");
        this.checkGlError("glGetAttribLocation aTextureCoord");
        if (this.maTextureHandle == -1) {
            throw new RuntimeException("Could not get attrib location for aTextureCoord");
        }
        this.muMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uMVPMatrix");
        this.checkGlError("glGetUniformLocation uMVPMatrix");
        if (this.muMVPMatrixHandle == -1) {
            throw new RuntimeException("Could not get attrib location for uMVPMatrix");
        }
        this.muSTMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uSTMatrix");
        this.checkGlError("glGetUniformLocation uSTMatrix");
        if (this.muSTMatrixHandle == -1) {
            throw new RuntimeException("Could not get attrib location for uSTMatrix");
        }
        GLES20.glGenTextures((int)1, (int[])this.textures, (int)0);
        GLES20.glBindTexture((int)36197, (int)this.textures[0]);
        this.checkGlError("glBindTexture mTextureID");
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.checkGlError("glTexParameter");
    }

    public void drawFrame(SurfaceTexture st) {
        this.checkGlError("onDrawFrame start");
        st.getTransformMatrix(this.mSTMatrix);
        GLES20.glClearColor((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.mProgram);
        this.checkGlError("glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.textures[0]);
        this.mTriangleVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.maPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.mTriangleVertices);
        this.checkGlError("glVertexAttribPointer maPosition");
        GLES20.glEnableVertexAttribArray((int)this.maPositionHandle);
        this.checkGlError("glEnableVertexAttribArray maPositionHandle");
        this.mTriangleVertices.position(3);
        GLES20.glVertexAttribPointer((int)this.maTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.mTriangleVertices);
        this.checkGlError("glVertexAttribPointer maTextureHandle");
        GLES20.glEnableVertexAttribArray((int)this.maTextureHandle);
        this.checkGlError("glEnableVertexAttribArray maTextureHandle");
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.muSTMatrixHandle, (int)1, (boolean)false, (float[])this.mSTMatrix, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.checkGlError("glDrawArrays");
        GLES20.glFinish();
    }

    public void checkGlError(String op) {
        int error;
        while ((error = GLES20.glGetError()) != 0) {
            Log.e((String)"SurfaceTest", (String)(String.valueOf(op) + ": glError " + GLUtils.getEGLErrorString((int)error)));
        }
    }

    class HardDecodeRenderer
    implements GLSurfaceView.Renderer {
        HardDecodeRenderer() {
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            VideoDecoder.this.viewWidth = width;
            VideoDecoder.this.viewHeight = height;
            if (VideoDecoder.this.bitmapScale == 1.0f) {
                VideoDecoder.this.mScaleBitmapH = VideoDecoder.this.viewHeight;
                VideoDecoder.this.mScaleBitmapW = VideoDecoder.this.viewWidth;
            } else if (VideoDecoder.this.checkIsTSmall(VideoDecoder.this.mStartX, VideoDecoder.this.mStartY, VideoDecoder.this.mScaleBitmapW, VideoDecoder.this.mScaleBitmapH)) {
                VideoDecoder.this.mStartX = 0;
                VideoDecoder.this.mScaleBitmapW = VideoDecoder.this.viewWidth;
                VideoDecoder.this.mStartY = 0;
                VideoDecoder.this.mScaleBitmapH = VideoDecoder.this.viewHeight;
                VideoDecoder.this.bitmapScale = 1.0f;
            }
            gl.glViewport(VideoDecoder.this.mStartX, VideoDecoder.this.mStartY, VideoDecoder.this.viewWidth, VideoDecoder.this.viewHeight);
        }

        public void onDrawFrame(GL10 gl) {
            VideoDecoder.this.nativeFunctionLock.lock();
            int x = VideoDecoder.this.mStartX;
            int y = VideoDecoder.this.mStartY;
            int w = VideoDecoder.this.mScaleBitmapW;
            int h = VideoDecoder.this.mScaleBitmapH;
            if (VideoDecoder.this.checkIsTSmall(x, y, w, h)) {
                x = 0;
                w = VideoDecoder.this.viewWidth;
                y = 0;
                h = VideoDecoder.this.viewHeight;
            } else {
                if (x > 0) {
                    x = 0;
                }
                if (y > 0) {
                    y = 0;
                }
            }
            gl.glViewport(x, y, w, h);
            VideoDecoder.this.videoTexture.updateTexImage();
            VideoDecoder.this.videoTexture.getTransformMatrix(VideoDecoder.this.mMVPMatrix);
            VideoDecoder.this.drawFrame(VideoDecoder.this.videoTexture);
            VideoDecoder.this.nativeFunctionLock.unlock();
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            VideoDecoder.this.setupGraphics();
            VideoDecoder.this.mTriangleVertices = ByteBuffer.allocateDirect(VideoDecoder.this.mTriangleVerticesData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            VideoDecoder.this.mTriangleVertices.put(VideoDecoder.this.mTriangleVerticesData).position(0);
            Matrix.setIdentityM((float[])VideoDecoder.this.mSTMatrix, (int)0);
            VideoDecoder.this.videoTexture = new SurfaceTexture(VideoDecoder.this.textures[0]);
            VideoDecoder.this._mediaDec.SetSurfacTexture(VideoDecoder.this.videoTexture);
            VideoDecoder.this.videoTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        VideoDecoder.this.requestRender();
                    }
                }
            });
        }
    }

    public static interface OnHardDecorderResultListener {
        public void onError(int var1);
    }
}

