/*
 * Decompiled with CFR 0.152.
 */
package com.hujiang.gradle.plugin.android.aspectjx.internal.utils;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0003J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0003J\u0016\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0015J\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/utils/JarMerger;", "", "jarFile", "Ljava/io/File;", "(Ljava/io/File;)V", "buffer", "", "closer", "Lcom/google/common/io/Closer;", "getCloser", "()Lcom/google/common/io/Closer;", "closer$delegate", "Lkotlin/Lazy;", "filter", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/utils/JarMerger$IZipEntryFilter;", "jarOutputStream", "Ljava/util/jar/JarOutputStream;", "getJarOutputStream", "()Ljava/util/jar/JarOutputStream;", "jarOutputStream$delegate", "addEntry", "", "path", "", "bytes", "addFolder", "folder", "addFolderWithPath", "addJar", "file", "removeEntryTimestamp", "", "close", "setFilter", "IZipEntryFilter", "aspectjx"})
public final class JarMerger {
    @NotNull
    private final File jarFile;
    @NotNull
    private final byte[] buffer;
    @NotNull
    private final Lazy closer$delegate;
    @NotNull
    private final Lazy jarOutputStream$delegate;
    @Nullable
    private IZipEntryFilter filter;

    public JarMerger(@NotNull File jarFile) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        this.jarFile = jarFile;
        this.buffer = new byte[8192];
        this.closer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Closer>(this){
            final /* synthetic */ JarMerger this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Closer invoke() {
                FileUtils.forceMkdir((File)JarMerger.access$getJarFile$p(this.this$0).getParentFile());
                return Closer.create();
            }
        }));
        this.jarOutputStream$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JarOutputStream>(this){
            final /* synthetic */ JarMerger this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final JarOutputStream invoke() {
                FileOutputStream fos = (FileOutputStream)JarMerger.access$getCloser(this.this$0).register((Closeable)new FileOutputStream(JarMerger.access$getJarFile$p(this.this$0)));
                return (JarOutputStream)JarMerger.access$getCloser(this.this$0).register((Closeable)new JarOutputStream(fos));
            }
        }));
    }

    private final Closer getCloser() {
        Lazy lazy = this.closer$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-closer>(...)");
        return (Closer)object;
    }

    private final JarOutputStream getJarOutputStream() {
        Lazy lazy = this.jarOutputStream$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-jarOutputStream>(...)");
        return (JarOutputStream)object;
    }

    public final void setFilter(@NotNull IZipEntryFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        this.filter = filter;
    }

    public final void addFolder(@NotNull File folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        this.addFolderWithPath(folder, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFolderWithPath(File folder, String path) {
        File[] fileArray = folder.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            if (file.isFile()) {
                String entryPath = path + file.getName();
                IZipEntryFilter iZipEntryFilter = this.filter;
                boolean bl = iZipEntryFilter != null ? iZipEntryFilter.checkEntry(entryPath) : false;
                if (!bl) continue;
                this.getJarOutputStream().putNextEntry(new JarEntry(entryPath));
                Closeable closeable = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    FileInputStream fis = (FileInputStream)closeable;
                    boolean bl2 = false;
                    int count = 0;
                    while (true) {
                        int n;
                        int it = n = fis.read(this.buffer);
                        boolean bl3 = false;
                        count = it;
                        if (n == -1) break;
                        this.getJarOutputStream().write(this.buffer, 0, count);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                this.getJarOutputStream().closeEntry();
                continue;
            }
            if (!file.isDirectory()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            this.addFolderWithPath(file, path + file.getName() + '/');
        }
    }

    public final void addJar(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.addJar(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addJar(@NotNull File file, boolean removeEntryTimestamp) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closer localCloser = Closer.create();
        Closeable closeable = (Closeable)localCloser;
        Throwable throwable = null;
        try {
            Closer it = (Closer)closeable;
            boolean bl = false;
            FileInputStream fis = (FileInputStream)localCloser.register((Closeable)new FileInputStream(file));
            ZipInputStream zis = (ZipInputStream)localCloser.register((Closeable)new ZipInputStream(fis));
            ZipEntry zipEntry = null;
            while (true) {
                JarEntry newEntry;
                boolean bl2;
                ZipEntry entry;
                ZipEntry zipEntry2;
                ZipEntry it2 = zipEntry2 = zis.getNextEntry();
                boolean bl3 = false;
                zipEntry = it2;
                if (zipEntry2 == null) break;
                Intrinsics.checkNotNull((Object)zipEntry);
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                IZipEntryFilter iZipEntryFilter = this.filter;
                if (iZipEntryFilter != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    bl2 = !iZipEntryFilter.checkEntry(name);
                } else {
                    bl2 = false;
                }
                if (bl2) continue;
                JarEntry jarEntry = newEntry = entry.getMethod() == 0 ? new JarEntry(entry) : new JarEntry(name);
                if (removeEntryTimestamp) {
                    newEntry.setTime(0L);
                }
                this.getJarOutputStream().putNextEntry(newEntry);
                int count = 0;
                while (true) {
                    int n;
                    int it3 = n = zis.read(this.buffer);
                    boolean bl4 = false;
                    count = it3;
                    if (n == -1) break;
                    this.getJarOutputStream().write(this.buffer, 0, count);
                }
                this.getJarOutputStream().closeEntry();
                zis.closeEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void addEntry(@NotNull String path, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.getJarOutputStream().putNextEntry(new JarEntry(path));
        this.getJarOutputStream().write(bytes);
        this.getJarOutputStream().closeEntry();
    }

    public final void close() {
        this.getCloser().close();
    }

    public static final /* synthetic */ File access$getJarFile$p(JarMerger $this) {
        return $this.jarFile;
    }

    public static final /* synthetic */ Closer access$getCloser(JarMerger $this) {
        return $this.getCloser();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/utils/JarMerger$IZipEntryFilter;", "", "checkEntry", "", "archivePath", "", "aspectjx"})
    public static interface IZipEntryFilter {
        public boolean checkEntry(@NotNull String var1);
    }
}

