/*
 * Decompiled with CFR 0.152.
 */
package com.hujiang.gradle.plugin.android.aspectjx.internal.utils;

import com.android.build.api.transform.JarInput;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.hujiang.gradle.plugin.android.aspectjx.AJXPlugin;
import com.hujiang.gradle.plugin.android.aspectjx.internal.utils.AspectJClassVisitor;
import com.hujiang.gradle.plugin.android.aspectjx.internal.utils.FileType;
import com.hujiang.gradle.plugin.android.aspectjx.internal.utils.JarMerger;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ'\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010\u00a2\u0006\u0002\u0010\u0011J!\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bJ\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J \u0010\u001f\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010!J*\u0010\"\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010!2\u0006\u0010#\u001a\u00020$H\u0002J \u0010%\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010!J*\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0!2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0!J\u0010\u0010+\u001a\n -*\u0004\u0018\u00010,0,H\u0002J\u0016\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bJ\u001c\u0010.\u001a\u00020/2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\b0!2\u0006\u00101\u001a\u00020\bJ)\u00103\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010\u00a2\u0006\u0002\u0010\u0011J#\u00103\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u00104\u001a\u0004\u0018\u00010\u000e2\u0006\u00105\u001a\u00020\u0001J\u000e\u00106\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/utils/AJXUtils;", "", "()V", "gson", "Lcom/google/gson/Gson;", "countOfFiles", "", "file", "Ljava/io/File;", "fileType", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/utils/FileType;", "fromJsonStringThrowEx", "T", "jsonString", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "typeOfT", "Ljava/lang/reflect/Type;", "(Ljava/lang/String;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "isAspectClass", "", "classFile", "bytes", "", "isClassFile", "filePath", "isContained", "str", "filter", "isExcludeFilterMatched", "filters", "", "isFilterMatched", "filterPolicy", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/utils/AJXUtils$FilterPolicy;", "isIncludeFilterMatched", "isJarInputMatched", "jarInput", "Lcom/android/build/api/transform/JarInput;", "includes", "excludes", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mergeJar", "", "sourceDir", "targetJar", "sourceDirList", "optFromJsonString", "optToJsonString", "any", "toJsonStringThrowEx", "FilterPolicy", "aspectjx"})
public final class AJXUtils {
    @NotNull
    public static final AJXUtils INSTANCE = new AJXUtils();
    @NotNull
    private static final Gson gson;

    private AJXUtils() {
    }

    public final boolean isAspectClass(@NotNull File classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        if (this.isClassFile(classFile)) {
            return this.isAspectClass(FileUtils.readFileToByteArray((File)classFile));
        }
        return false;
    }

    public final boolean isAspectClass(@Nullable byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        try {
            ClassReader classReader = new ClassReader(bytes);
            ClassWriter classWriter = new ClassWriter(classReader, 3);
            AspectJClassVisitor aspectJClassVisitor = new AspectJClassVisitor(classWriter);
            classReader.accept((ClassVisitor)aspectJClassVisitor, 8);
            return aspectJClassVisitor.isAspectClass();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @NotNull
    public final FileType fileType(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String filePath = string2;
        if (StringsKt.endsWith$default((String)filePath, (String)".java", (boolean)false, (int)2, null)) {
            return FileType.JAVA;
        }
        if (StringsKt.endsWith$default((String)filePath, (String)".class", (boolean)false, (int)2, null)) {
            return FileType.CLASS;
        }
        if (StringsKt.endsWith$default((String)filePath, (String)".jar", (boolean)false, (int)2, null)) {
            return FileType.JAR;
        }
        if (StringsKt.endsWith$default((String)filePath, (String)".kt", (boolean)false, (int)2, null)) {
            return FileType.KOTLIN;
        }
        if (StringsKt.endsWith$default((String)filePath, (String)".groovy", (boolean)false, (int)2, null)) {
            return FileType.GROOVY;
        }
        return FileType.DEFAULT;
    }

    public final boolean isClassFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.fileType(file) == FileType.CLASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isClassFile(@Nullable String filePath) {
        String string = filePath;
        String string2 = string;
        if (string == null) return false;
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
        string2 = string3;
        if (string3 == null) return false;
        if (!StringsKt.endsWith$default((String)string2, (String)".class", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final <T> T fromJsonStringThrowEx(@NotNull String jsonString, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)gson.fromJson(jsonString, clazz);
    }

    @Nullable
    public final <T> T optFromJsonString(@NotNull String jsonString, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            return (T)gson.fromJson(jsonString, clazz);
        }
        catch (Throwable e) {
            this.logger().warn("optFromJsonString(" + jsonString + ", " + clazz, e);
            return null;
        }
    }

    public final <T> T fromJsonStringThrowEx(@NotNull String jsonString, @NotNull Type typeOfT) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        return (T)gson.fromJson(jsonString, typeOfT);
    }

    @Nullable
    public final <T> T optFromJsonString(@NotNull String jsonString, @NotNull Type typeOfT) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        try {
            return (T)gson.fromJson(jsonString, typeOfT);
        }
        catch (JsonSyntaxException e) {
            this.logger().warn("optFromJsonString(" + jsonString + ", " + typeOfT, (Throwable)e);
            return null;
        }
    }

    @NotNull
    public final String toJsonStringThrowEx(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        String string = gson.toJson(any);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(any)");
        return string;
    }

    @Nullable
    public final String optToJsonString(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        try {
            return gson.toJson(any);
        }
        catch (Throwable throwable) {
            this.logger().warn("optToJsonString(" + any, throwable);
            return null;
        }
    }

    public final boolean isExcludeFilterMatched(@Nullable String str, @Nullable List<String> filters) {
        return this.isFilterMatched(str, filters, FilterPolicy.EXCLUDE);
    }

    public final boolean isIncludeFilterMatched(@Nullable String str, @Nullable List<String> filters) {
        return this.isFilterMatched(str, filters, FilterPolicy.INCLUDE);
    }

    private final boolean isFilterMatched(String str, List<String> filters, FilterPolicy filterPolicy) {
        if (str == null) {
            return false;
        }
        Collection collection = filters;
        if (collection == null || collection.isEmpty()) {
            return filterPolicy == FilterPolicy.INCLUDE;
        }
        for (String s : filters) {
            if (!this.isContained(str, s)) continue;
            return true;
        }
        return false;
    }

    private final boolean isContained(String str, String filter) {
        if (str == null) {
            return false;
        }
        if (StringsKt.contains$default((CharSequence)str, (CharSequence)filter, (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)filter, (CharSequence)"/", (boolean)false, (int)2, null)) {
            CharSequence charSequence = str;
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
            return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)StringsKt.replace$default((String)filter, (String)"/", (String)string, (boolean)false, (int)4, null), (boolean)false, (int)2, null);
        }
        if (StringsKt.contains$default((CharSequence)filter, (CharSequence)"\\", (boolean)false, (int)2, null)) {
            CharSequence charSequence = str;
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
            return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)StringsKt.replace$default((String)filter, (String)"\\", (String)string, (boolean)false, (int)4, null), (boolean)false, (int)2, null);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int countOfFiles(@NotNull File file) {
        int n;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isFile()) {
            n = 1;
        } else {
            void var3_3;
            File[] files = file.listFiles();
            int total = 0;
            if (files != null) {
                File[] it = files;
                boolean bl = false;
                for (File f : it) {
                    Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
                    total += INSTANCE.countOfFiles(f);
                }
            }
            n = var3_3;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isJarInputMatched(@NotNull JarInput jarInput, @NotNull List<String> includes, @NotNull List<String> excludes) {
        Intrinsics.checkNotNullParameter((Object)jarInput, (String)"jarInput");
        Intrinsics.checkNotNullParameter(includes, (String)"includes");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        Closeable closeable = new JarFile(jarInput.getFile());
        Throwable throwable = null;
        try {
            JarFile it = (JarFile)closeable;
            boolean bl = false;
            boolean isIncludeMatched = includes.isEmpty();
            boolean isExcludeMatched = false;
            Enumeration<JarEntry> entries = it.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entryName = jarEntry.getName();
                if (jarEntry.isDirectory() || !INSTANCE.isClassFile(entryName)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)entryName, (String)"entryName");
                String tranEntryName = StringsKt.replace$default((String)StringsKt.replace$default((String)entryName, (String)"/", (String)".", (boolean)false, (int)4, null), (String)"\\", (String)".", (boolean)false, (int)4, null);
                if (!isIncludeMatched && INSTANCE.isIncludeFilterMatched(tranEntryName, includes)) {
                    isIncludeMatched = true;
                }
                if (!INSTANCE.isExcludeFilterMatched(tranEntryName, excludes)) continue;
                isExcludeMatched = true;
                break;
            }
            boolean bl2 = isIncludeMatched && !isExcludeMatched;
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void mergeJar(@NotNull File sourceDir, @NotNull File targetJar) {
        Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
        Intrinsics.checkNotNullParameter((Object)targetJar, (String)"targetJar");
        this.mergeJar(CollectionsKt.listOf((Object)sourceDir), targetJar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mergeJar(@NotNull List<? extends File> sourceDirList, @NotNull File targetJar) {
        Intrinsics.checkNotNullParameter(sourceDirList, (String)"sourceDirList");
        Intrinsics.checkNotNullParameter((Object)targetJar, (String)"targetJar");
        if (!targetJar.getParentFile().exists()) {
            FileUtils.forceMkdir((File)targetJar.getParentFile());
        }
        FileUtils.deleteQuietly((File)targetJar);
        try (JarMerger jarMerger = new JarMerger(targetJar);){
            jarMerger.setFilter(new JarMerger.IZipEntryFilter(){

                public boolean checkEntry(@NotNull String archivePath) {
                    Intrinsics.checkNotNullParameter((Object)archivePath, (String)"archivePath");
                    return StringsKt.endsWith$default((String)archivePath, (String)".class", (boolean)false, (int)2, null);
                }
            });
            Iterable $this$forEach$iv = sourceDirList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                jarMerger.addFolder(it);
            }
        }
    }

    private final Logger logger() {
        return LoggerFactory.getLogger(AJXPlugin.class);
    }

    static {
        Gson gson = new GsonBuilder().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder().create()");
        AJXUtils.gson = gson;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/utils/AJXUtils$FilterPolicy;", "", "(Ljava/lang/String;I)V", "INCLUDE", "EXCLUDE", "aspectjx"})
    public static final class FilterPolicy
    extends Enum<FilterPolicy> {
        public static final /* enum */ FilterPolicy INCLUDE = new FilterPolicy();
        public static final /* enum */ FilterPolicy EXCLUDE = new FilterPolicy();
        private static final /* synthetic */ FilterPolicy[] $VALUES;

        public static FilterPolicy[] values() {
            return (FilterPolicy[])$VALUES.clone();
        }

        public static FilterPolicy valueOf(String value) {
            return Enum.valueOf(FilterPolicy.class, value);
        }

        static {
            $VALUES = filterPolicyArray = new FilterPolicy[]{FilterPolicy.INCLUDE, FilterPolicy.EXCLUDE};
        }
    }
}

