/*
 * Decompiled with CFR 0.152.
 */
package com.hujiang.gradle.plugin.android.aspectjx;

import com.android.Version;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.BaseExtension;
import com.hujiang.gradle.plugin.android.aspectjx.AJXExtension;
import com.hujiang.gradle.plugin.android.aspectjx.AJXTransform;
import com.hujiang.gradle.plugin.android.aspectjx.LoggerHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/AJXPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "wasApplied", "", "apply", "", "project", "doApply", "logQuiet", "msg", "", "Companion", "aspectjx"})
public final class AJXPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean wasApplied;
    @NotNull
    private static final String[] PREREQ_PLUGIN_OPTIONS;

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getExtensions().create("aspectjx", AJXExtension.class, new Object[0]);
        Action applyWithPrerequisitePlugin = arg_0 -> AJXPlugin.apply$lambda-0(this, project, arg_0);
        String[] $this$forEach$iv = PREREQ_PLUGIN_OPTIONS;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            project.getPluginManager().withPlugin(it, applyWithPrerequisitePlugin);
        }
        project.afterEvaluate(arg_0 -> AJXPlugin.apply$lambda-2(this, arg_0));
    }

    private final void doApply(Project project) {
        Logger logger = project.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
        LoggerHolder.INSTANCE.setLogger(logger);
        String gradleVersion = project.getGradle().getGradleVersion();
        String dependencyGav = "org.aspectj:aspectjrt:1.9.7";
        this.logQuiet("agp version[" + Version.ANDROID_GRADLE_PLUGIN_VERSION + ']');
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.0")) > 0) {
            this.logQuiet("gradle version[" + gradleVersion + "] > 4.0");
            project.getDependencies().add("implementation", (Object)dependencyGav);
            this.logQuiet("auto add dependency: 'implementation " + dependencyGav + '\'');
        } else {
            this.logQuiet("gradle version[" + gradleVersion + "] < 4.0");
            project.getDependencies().add("compile", (Object)dependencyGav);
            this.logQuiet("auto add dependency: 'compile " + dependencyGav + '\'');
        }
        BaseExtension android = (BaseExtension)project.getExtensions().getByType(BaseExtension.class);
        android.registerTransform((Transform)new AJXTransform(project), new Object[0]);
        this.logQuiet("register AJXTransform:" + android.getTransforms());
    }

    private final void logQuiet(String msg) {
        LoggerHolder.INSTANCE.getLogger().quiet("[ajx] " + msg);
    }

    private static final void apply$lambda-0(AJXPlugin this$0, Project $project, AppliedPlugin it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        if (this$0.wasApplied) {
            LoggerHolder.INSTANCE.getLogger().info("The android-aspectjx plugin was already applied to the project: " + $project.getPath() + " and will not be applied again after plugin: " + it.getId());
        } else {
            this$0.wasApplied = true;
            this$0.doApply($project);
        }
    }

    private static final void apply$lambda-2(AJXPlugin this$0, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.wasApplied) {
            throw new GradleException("The android-aspectjx plugin could not be applied during project evaluation. One of the Android plugins must be applied to the project first.");
        }
    }

    static {
        String[] stringArray = new String[]{"com.android.application", "com.android.feature", "com.android.dynamic-feature", "com.android.library", "android", "android-library"};
        PREREQ_PLUGIN_OPTIONS = stringArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/AJXPlugin$Companion;", "", "()V", "PREREQ_PLUGIN_OPTIONS", "", "", "[Ljava/lang/String;", "aspectjx"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

