/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiErrorResponse;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ErrorHandlingFacade;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.web.filter.OncePerRequestFilter;

public class FilterChainExceptionHandlerFilter
extends OncePerRequestFilter {
    private final ErrorHandlingFacade errorHandlingFacade;
    private final ObjectMapper objectMapper;

    public FilterChainExceptionHandlerFilter(ErrorHandlingFacade errorHandlingFacade, ObjectMapper objectMapper) {
        this.errorHandlingFacade = errorHandlingFacade;
        this.objectMapper = objectMapper;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            ApiErrorResponse errorResponse = this.errorHandlingFacade.handle(ex);
            response.setStatus(errorResponse.getHttpStatus().value());
            String jsonResponseBody = this.objectMapper.writeValueAsString((Object)errorResponse);
            response.getWriter().write(jsonResponseBody);
        }
    }
}

