/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper;

import io.github.wimdeblauwe.errorhandlingspringbootstarter.ErrorHandlingProperties;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.server.ResponseStatusException;

public class HttpStatusMapper {
    private final ErrorHandlingProperties properties;

    public HttpStatusMapper(ErrorHandlingProperties properties) {
        this.properties = properties;
    }

    public HttpStatusCode getHttpStatus(Throwable exception) {
        return this.getHttpStatus(exception, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public HttpStatusCode getHttpStatus(Throwable exception, HttpStatus defaultHttpStatus) {
        HttpStatusCode status = this.getHttpStatusFromPropertiesOrAnnotation(exception.getClass());
        if (status != null) {
            return status;
        }
        if (exception instanceof ResponseStatusException) {
            return ((ResponseStatusException)exception).getStatusCode();
        }
        return defaultHttpStatus;
    }

    private HttpStatusCode getHttpStatusFromPropertiesOrAnnotation(Class<?> exceptionClass) {
        if (exceptionClass == null) {
            return null;
        }
        String exceptionClassName = exceptionClass.getName();
        if (this.properties.getHttpStatuses().containsKey(exceptionClassName)) {
            return (HttpStatusCode)this.properties.getHttpStatuses().get(exceptionClassName);
        }
        ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.getAnnotation(exceptionClass, ResponseStatus.class);
        if (responseStatus != null) {
            return responseStatus.value();
        }
        if (this.properties.isSearchSuperClassHierarchy()) {
            return this.getHttpStatusFromPropertiesOrAnnotation(exceptionClass.getSuperclass());
        }
        return null;
    }
}

