/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter.handler;

import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiErrorResponse;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiFieldError;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiGlobalError;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiParameterError;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ErrorHandlingProperties;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.handler.AbstractApiExceptionHandler;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorCodeMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorMessageMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.HttpStatusMapper;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

public class ConstraintViolationApiExceptionHandler
extends AbstractApiExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstraintViolationApiExceptionHandler.class);
    private final ErrorHandlingProperties properties;

    public ConstraintViolationApiExceptionHandler(ErrorHandlingProperties properties, HttpStatusMapper httpStatusMapper, ErrorCodeMapper errorCodeMapper, ErrorMessageMapper errorMessageMapper) {
        super(httpStatusMapper, errorCodeMapper, errorMessageMapper);
        this.properties = properties;
    }

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof ConstraintViolationException;
    }

    @Override
    public ApiErrorResponse handle(Throwable exception) {
        ConstraintViolationException ex = (ConstraintViolationException)exception;
        ApiErrorResponse response = new ApiErrorResponse((HttpStatusCode)HttpStatus.BAD_REQUEST, this.getErrorCode(exception), this.getMessage(ex));
        Set violations = ex.getConstraintViolations();
        violations.stream().sorted(Comparator.comparing(constraintViolation -> constraintViolation.getPropertyPath().toString())).map(constraintViolation -> {
            Optional<Path.Node> leafNode = this.getLeafNode(constraintViolation.getPropertyPath());
            if (leafNode.isPresent()) {
                Path.Node node = leafNode.get();
                ElementKind elementKind = node.getKind();
                if (elementKind == ElementKind.PROPERTY) {
                    return new ApiFieldError(this.getCode((ConstraintViolation<?>)constraintViolation), node.toString(), this.getMessage((ConstraintViolation<?>)constraintViolation), constraintViolation.getInvalidValue(), this.getPath((ConstraintViolation<?>)constraintViolation));
                }
                if (elementKind == ElementKind.BEAN) {
                    return new ApiGlobalError(this.getCode((ConstraintViolation<?>)constraintViolation), this.getMessage((ConstraintViolation<?>)constraintViolation));
                }
                if (elementKind == ElementKind.PARAMETER) {
                    return new ApiParameterError(this.getCode((ConstraintViolation<?>)constraintViolation), node.toString(), this.getMessage((ConstraintViolation<?>)constraintViolation), constraintViolation.getInvalidValue());
                }
                LOGGER.warn("Unable to convert constraint violation with element kind {}: {}", (Object)elementKind, constraintViolation);
                return null;
            }
            LOGGER.warn("Unable to convert constraint violation: {}", constraintViolation);
            return null;
        }).forEach(error -> {
            if (error instanceof ApiFieldError) {
                response.addFieldError((ApiFieldError)error);
            } else if (error instanceof ApiGlobalError) {
                response.addGlobalError((ApiGlobalError)error);
            } else if (error instanceof ApiParameterError) {
                response.addParameterError((ApiParameterError)error);
            }
        });
        return response;
    }

    private Optional<Path.Node> getLeafNode(Path path) {
        return StreamSupport.stream(path.spliterator(), false).reduce((a, b) -> b);
    }

    private String getPath(ConstraintViolation<?> constraintViolation) {
        if (!this.properties.isAddPathToError()) {
            return null;
        }
        return this.getPathWithoutPrefix(constraintViolation.getPropertyPath());
    }

    private String getPathWithoutPrefix(Path path) {
        String collect = StreamSupport.stream(path.spliterator(), false).limit(2L).map(Path.Node::getName).collect(Collectors.joining("."));
        String substring = path.toString().substring(collect.length());
        return substring.startsWith(".") ? substring.substring(1) : substring;
    }

    private String getCode(ConstraintViolation<?> constraintViolation) {
        String code = constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName();
        String fieldSpecificCode = constraintViolation.getPropertyPath().toString() + "." + code;
        return this.errorCodeMapper.getErrorCode(fieldSpecificCode, code);
    }

    private String getMessage(ConstraintViolation<?> constraintViolation) {
        String code = constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName();
        String fieldSpecificCode = constraintViolation.getPropertyPath().toString() + "." + code;
        return this.errorMessageMapper.getErrorMessage(fieldSpecificCode, code, constraintViolation.getMessage());
    }

    private String getMessage(ConstraintViolationException exception) {
        return "Validation failed. Error count: " + exception.getConstraintViolations().size();
    }
}

