/*
 * Decompiled with CFR 0.152.
 */
package com.github.bohnman;

import com.github.bohnman.Package;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class PackageInfoMojo
extends AbstractMojo {
    private static final String PACKAGE_INFO_JAVA = "package-info.java";
    private static final Pattern PACKAGE_STATEMENT_PATTERN = Pattern.compile("^\\s*package\\s[\\S]+?\\s*;$", 8);
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}/src/main/java")
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/package-info")
    private File outputDirectory;
    @Parameter
    private List<Package> packages;
    @Parameter(defaultValue="(\\s*//\\s*<replace>\\s*)(.*?)(\\s*//\\s*</replace>\\s*)")
    private Pattern inlineReplacePattern;
    @Parameter(defaultValue="true")
    private boolean generate;
    @Parameter(defaultValue="true")
    private boolean inline;
    @Component
    private BuildContext buildContext;
    private Map<String, String> templateCache = new HashMap<String, String>();

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setPackages(List<Package> packages) {
        this.packages = packages;
    }

    public void setInlineReplacePattern(String inlineReplacePattern) {
        this.inlineReplacePattern = Pattern.compile(inlineReplacePattern, 8);
    }

    public void setGenerate(boolean generate) {
        this.generate = generate;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)String.format("Generating package-info.java: %s", new Object[]{this}));
            this.generate();
            this.getLog().info((CharSequence)"Adding generated code to project sources");
            this.addSourceRoot();
            this.getLog().debug((CharSequence)"Done.");
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            throw new MojoExecutionException("Error generating package info files", e);
        }
    }

    private void generate() throws MojoExecutionException {
        if (this.packages == null || this.packages.isEmpty()) {
            this.getLog().warn((CharSequence)"Skipping generate. No <packages/> declaration found.");
            return;
        }
        if (!this.sourceDirectory.exists()) {
            this.getLog().info((CharSequence)String.format("Skipping generate. No Source Directory found in this module: [%s].", this.sourceDirectory.getAbsolutePath()));
            return;
        }
        this.validate();
        this.loadTemplates();
        if (this.buildContext == null) {
            this.getLog().info((CharSequence)String.format("Using defaultBuildContext", new Object[0]));
            this.buildContext = new DefaultBuildContext();
        }
        this.walk(this.sourceDirectory, this.outputDirectory, "");
    }

    private void addSourceRoot() {
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private void validate() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Validating parameters");
        if (!this.sourceDirectory.isDirectory()) {
            throw new MojoExecutionException(String.format("Source Directory [%s] is not a directory.", this.sourceDirectory.getAbsolutePath()));
        }
        if (this.generate) {
            if (this.outputDirectory.exists() && !this.outputDirectory.isDirectory()) {
                throw new MojoExecutionException(String.format("Output Directory [%s] is not a directory.", this.outputDirectory.getAbsolutePath()));
            }
            if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                throw new MojoExecutionException(String.format("Failed to create Output Directory [%s].", this.outputDirectory.getAbsolutePath()));
            }
        }
        for (int i = 0; i < this.packages.size(); ++i) {
            Package pkg = this.packages.get(i);
            if (StringUtils.isEmpty((String)pkg.getPattern())) {
                throw new MojoExecutionException(String.format("<package/>[%s]: <pattern/> is required.", i));
            }
            if (pkg.getTemplate() == null) {
                throw new MojoExecutionException(String.format("<package/>[%s]: <template/> is required.", i));
            }
            if (!pkg.getTemplate().exists()) {
                throw new MojoExecutionException(String.format("<package/>[%s]: template [%s] does not exist.", i, pkg.getTemplate()));
            }
            if (pkg.getTemplate().isFile()) continue;
            throw new MojoExecutionException(String.format("<package/>[%s]: template [%s] is not a file.", i, pkg.getTemplate()));
        }
    }

    private void loadTemplates() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Loading templates");
        for (int i = 0; i < this.packages.size(); ++i) {
            Package pkg = this.packages.get(i);
            try {
                String source = this.loadTemplate(pkg.getTemplate());
                this.templateCache.put(pkg.getTemplate().getAbsolutePath(), source);
                this.getLog().debug((CharSequence)String.format("Loaded template %s", source));
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("<package/>[%s]: Error loading template [%s]", i, pkg.getTemplate()), (Exception)e);
            }
        }
    }

    private String loadTemplate(File template) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(template);){
            String string = IOUtil.toString((InputStream)inputStream);
            return string;
        }
    }

    private void walk(File currentSourceDirectory, File currentOutputDirectory, String packageName) throws MojoExecutionException {
        File[] childSourceDirectories;
        File[] javaFiles = currentSourceDirectory.listFiles(file -> file.isFile() && file.getName().endsWith(".java"));
        if (javaFiles != null && javaFiles.length > 0) {
            File packageInfo = Arrays.stream(javaFiles).filter(javaFile -> javaFile.getName().equals(PACKAGE_INFO_JAVA)).findAny().orElse(null);
            Package pkg = this.findMatch(packageName);
            if (pkg == null) {
                this.getLog().debug((CharSequence)String.format("Package [%s] does not match any patterns", packageName));
            } else if (packageInfo == null) {
                if (this.generate) {
                    this.write(pkg, packageName, currentOutputDirectory);
                }
            } else if (this.inline) {
                this.replacePackageInfo(pkg, packageName, packageInfo);
            } else {
                this.getLog().debug((CharSequence)String.format("Skipping package [%s], main source already has a package-info.java", packageName));
            }
        }
        if ((childSourceDirectories = currentSourceDirectory.listFiles(file -> file.isDirectory() && !file.isHidden())) != null && childSourceDirectories.length > 0) {
            for (File childSourceDirectory : childSourceDirectories) {
                String childName = childSourceDirectory.getName();
                String childPackageName = packageName.isEmpty() ? childName : packageName + '.' + childName;
                this.walk(childSourceDirectory, new File(currentOutputDirectory, childName), childPackageName);
            }
        }
    }

    private void replacePackageInfo(Package pkg, String packageName, File packageInfo) throws MojoExecutionException {
        String packageInfoContents;
        this.getLog().debug((CharSequence)String.format("Existing package-info.java found: [%s], looking for replacement markers", packageInfo));
        if (this.templateCache.containsKey(packageInfo.getAbsolutePath())) {
            this.getLog().debug((CharSequence)String.format("%s is a template file, skipping.", packageInfo));
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(packageInfo);){
            packageInfoContents = IOUtil.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Unable to read %s", packageInfo), (Exception)e);
        }
        Matcher matcher = this.inlineReplacePattern.matcher(packageInfoContents);
        if (!matcher.find()) {
            this.getLog().debug((CharSequence)String.format("Replace Pattern [%s] not found, skipping.", this.inlineReplacePattern));
            return;
        }
        StringBuffer buffer = new StringBuffer();
        String templateSource = this.templateCache.get(pkg.getTemplate().getAbsolutePath());
        String replacement = packageName.isEmpty() ? "" : String.format("package %s;", packageName);
        String packageSource = PACKAGE_STATEMENT_PATTERN.matcher(templateSource).replaceFirst(replacement);
        matcher.appendReplacement(buffer, String.format("$1%s$3", packageSource));
        matcher.appendTail(buffer);
        String replacedSource = buffer.toString();
        if (!replacedSource.equals(packageInfoContents)) {
            try (OutputStream outputStream = this.buildContext.newFileOutputStream(packageInfo);){
                IOUtil.copy((InputStream)new ByteArrayInputStream(replacedSource.getBytes()), (OutputStream)outputStream);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Unable to write to [%s]", packageInfo), (Exception)e);
            }
        }
    }

    private Package findMatch(String packageName) {
        for (Package pkg : this.packages) {
            if (!this.matches(pkg, packageName)) continue;
            return pkg;
        }
        return null;
    }

    private boolean matches(Package pkg, String packageName) {
        return SelectorUtils.matchPath((String)pkg.getPattern(), (String)packageName, (String)".", (boolean)pkg.isCaseSensitive());
    }

    private void write(Package pkg, String packageName, File currentOutputDirectory) throws MojoExecutionException {
        this.getLog().debug((CharSequence)String.format("Writing package [%s] to [%s].", packageName, currentOutputDirectory));
        if (!currentOutputDirectory.exists() && !currentOutputDirectory.mkdirs()) {
            throw new MojoExecutionException(String.format("Unable to create [%s]", currentOutputDirectory));
        }
        File packageInfoOutputFile = new File(currentOutputDirectory, PACKAGE_INFO_JAVA);
        String replacement = packageName.isEmpty() ? "" : String.format("package %s;", packageName);
        String templateSource = this.templateCache.get(pkg.getTemplate().getAbsolutePath());
        String packageSource = PACKAGE_STATEMENT_PATTERN.matcher(templateSource).replaceFirst(replacement);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(packageSource.getBytes());
             OutputStream outputStream = this.buildContext.newFileOutputStream(packageInfoOutputFile);){
            this.write(inputStream, outputStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Error writing [%s] to [%s]", packageSource, packageInfoOutputFile), (Exception)e);
        }
    }

    private void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    public String toString() {
        return "{sourceDirectory=" + this.sourceDirectory + ", outputDirectory=" + this.outputDirectory + ", packages=" + this.packages + ", inlineReplacePattern='" + this.inlineReplacePattern + '\'' + ", generate=" + this.generate + ", inline=" + this.inline + '}';
    }
}

