/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.CatalogFactoryBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CatalogFactory<C extends Context> {
    public static final String DELIMITER = ":";
    private static final ConcurrentHashMap<ClassLoader, CatalogFactory<?>> FACTORIES = new ConcurrentHashMap();

    public abstract Catalog<C> getCatalog();

    public abstract void setCatalog(Catalog<C> var1);

    public abstract Catalog<C> getCatalog(String var1);

    public abstract void addCatalog(String var1, Catalog<C> var2);

    public abstract Iterator<String> getNames();

    public <CMD extends Command<C>> CMD getCommand(String commandID) {
        int splitPos;
        String commandName = commandID;
        String catalogName = null;
        Catalog<C> catalog = null;
        if (commandID != null && (splitPos = commandID.indexOf(DELIMITER)) != -1) {
            catalogName = commandID.substring(0, splitPos);
            commandName = commandID.substring(splitPos + DELIMITER.length());
            if (commandName.contains(DELIMITER)) {
                throw new IllegalArgumentException("commandID [" + commandID + "] has too many delimiters (reserved for future use)");
            }
        }
        if (catalogName != null) {
            catalog = this.getCatalog(catalogName);
            if (catalog == null) {
                Logger logger = LoggerFactory.getLogger(CatalogFactory.class);
                logger.warn("No catalog found for name: {}.", (Object)catalogName);
                return null;
            }
        } else {
            catalog = this.getCatalog();
            if (catalog == null) {
                Logger logger = LoggerFactory.getLogger(CatalogFactory.class);
                logger.warn("No default catalog found.");
                return null;
            }
        }
        return catalog.getCommand(commandName);
    }

    public static <C extends Context> CatalogFactory<C> getInstance() {
        ClassLoader cl = CatalogFactory.getClassLoader();
        CatalogFactory ret = FACTORIES.computeIfAbsent(cl, k -> new CatalogFactoryBase());
        return ret;
    }

    public static void clear() {
        FACTORIES.remove(CatalogFactory.getClassLoader());
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = CatalogFactory.class.getClassLoader();
        }
        return cl;
    }
}

