/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch.mapping.jackson3;

import com.flipkart.zjsonpatch.mapping.IteratorDecorator;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import com.flipkart.zjsonpatch.mapping.ObjectNodeWrapper;
import com.flipkart.zjsonpatch.mapping.jackson3.Jackson3NodeWrapper;
import java.util.Iterator;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class Jackson3ObjectNodeWrapper
extends Jackson3NodeWrapper
implements ObjectNodeWrapper {
    private final ObjectNode objectNode;

    public Jackson3ObjectNodeWrapper(ObjectNode objectNode) {
        super((JsonNode)objectNode);
        this.objectNode = objectNode;
    }

    @Override
    public JsonNodeWrapper put(String fieldName, JsonNodeWrapper value) {
        if (value == null) {
            this.objectNode.putNull(fieldName);
            return this;
        }
        Jackson3NodeWrapper jackson3Value = (Jackson3NodeWrapper)value;
        this.objectNode.set(fieldName, jackson3Value.getJackson3Node());
        return this;
    }

    @Override
    public JsonNodeWrapper set(String fieldName, JsonNodeWrapper value) {
        if (value == null) {
            this.objectNode.set(fieldName, null);
            return this;
        }
        Jackson3NodeWrapper jackson3Value = (Jackson3NodeWrapper)value;
        this.objectNode.set(fieldName, jackson3Value.getJackson3Node());
        return this;
    }

    @Override
    public JsonNodeWrapper replace(String fieldName, JsonNodeWrapper value) {
        if (value == null) {
            JsonNode result = this.objectNode.replace(fieldName, null);
            return result != null ? new Jackson3NodeWrapper(result) : null;
        }
        JsonNode result = this.objectNode.replace(fieldName, ((Jackson3NodeWrapper)value).getJackson3Node());
        return result != null ? new Jackson3NodeWrapper(result) : null;
    }

    @Override
    public JsonNodeWrapper remove(String fieldName) {
        JsonNode result = this.objectNode.remove(fieldName);
        return result != null ? new Jackson3NodeWrapper(result) : null;
    }

    @Override
    public Iterator<JsonNodeWrapper> iterator() {
        return new IteratorDecorator(this.objectNode.iterator());
    }
}

