/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.zjsonpatch.AbstractJsonPatch;
import com.flipkart.zjsonpatch.CompatibilityFlags;
import com.flipkart.zjsonpatch.CopyingApplyProcessor;
import com.flipkart.zjsonpatch.InPlaceApplyProcessor;
import com.flipkart.zjsonpatch.InvalidJsonPatchException;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import com.flipkart.zjsonpatch.NoopProcessor;
import com.flipkart.zjsonpatch.mapping.JacksonVersionBridge;
import com.flipkart.zjsonpatch.mapping.JsonNodeFactoryWrapper;
import com.flipkart.zjsonpatch.mapping.jackson2.Jackson2NodeFactory;
import java.util.EnumSet;

public final class JsonPatch
extends AbstractJsonPatch {
    private static final JsonNodeFactoryWrapper FACTORY = new Jackson2NodeFactory();

    private JsonPatch() {
    }

    public static void validate(JsonNode patch, EnumSet<CompatibilityFlags> flags) throws InvalidJsonPatchException {
        JsonPatch.process(JacksonVersionBridge.wrap(patch), NoopProcessor.INSTANCE, flags, FACTORY);
    }

    public static void validate(JsonNode patch) throws InvalidJsonPatchException {
        JsonPatch.validate(patch, CompatibilityFlags.defaults());
    }

    public static JsonNode apply(JsonNode patch, JsonNode source, EnumSet<CompatibilityFlags> flags) throws JsonPatchApplicationException {
        CopyingApplyProcessor processor = new CopyingApplyProcessor(JacksonVersionBridge.wrap(source), flags);
        JsonPatch.process(JacksonVersionBridge.wrap(patch), processor, flags, FACTORY);
        return (JsonNode)JacksonVersionBridge.unwrap(processor.result());
    }

    public static JsonNode apply(JsonNode patch, JsonNode source) throws JsonPatchApplicationException {
        return JsonPatch.apply(patch, source, CompatibilityFlags.defaults());
    }

    public static void applyInPlace(JsonNode patch, JsonNode source) {
        JsonPatch.applyInPlace(patch, source, CompatibilityFlags.defaults());
    }

    public static void applyInPlace(JsonNode patch, JsonNode source, EnumSet<CompatibilityFlags> flags) {
        InPlaceApplyProcessor processor = new InPlaceApplyProcessor(JacksonVersionBridge.wrap(source), flags);
        JsonPatch.process(JacksonVersionBridge.wrap(patch), processor, flags, FACTORY);
    }
}

