/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.flipkart.zjsonpatch.CompatibilityFlags;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import com.flipkart.zjsonpatch.JsonPatchProcessor;
import com.flipkart.zjsonpatch.JsonPatchTestFailedException;
import com.flipkart.zjsonpatch.JsonPointer;
import com.flipkart.zjsonpatch.JsonPointerEvaluationException;
import com.flipkart.zjsonpatch.Operation;
import com.flipkart.zjsonpatch.RefToken;
import com.flipkart.zjsonpatch.mapping.ArrayNodeWrapper;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import com.flipkart.zjsonpatch.mapping.ObjectNodeWrapper;
import java.util.EnumSet;

class InPlaceApplyProcessor
implements JsonPatchProcessor {
    private JsonNodeWrapper target;
    private EnumSet<CompatibilityFlags> flags;

    InPlaceApplyProcessor(JsonNodeWrapper target) {
        this(target, CompatibilityFlags.defaults());
    }

    InPlaceApplyProcessor(JsonNodeWrapper target, EnumSet<CompatibilityFlags> flags) {
        this.target = target;
        this.flags = flags;
    }

    public JsonNodeWrapper result() {
        return this.target;
    }

    protected boolean allowRootReplacement() {
        return false;
    }

    @Override
    public void move(JsonPointer fromPath, JsonPointer toPath) throws JsonPointerEvaluationException {
        JsonNodeWrapper valueNode = fromPath.evaluate(this.target);
        this.remove(fromPath);
        this.set(toPath, valueNode, Operation.MOVE);
    }

    @Override
    public void copy(JsonPointer fromPath, JsonPointer toPath) throws JsonPointerEvaluationException {
        JsonNodeWrapper valueNode = fromPath.evaluate(this.target);
        JsonNodeWrapper valueToCopy = valueNode != null ? valueNode.deepCopy() : null;
        this.set(toPath, valueToCopy, Operation.COPY);
    }

    private static String show(JsonNodeWrapper value) {
        if (value == null || value.isNull()) {
            return "null";
        }
        if (value.isArray()) {
            return "array";
        }
        if (value.isObject()) {
            return "object";
        }
        return "value " + value.toString();
    }

    @Override
    public void test(JsonPointer path, JsonNodeWrapper value) throws JsonPointerEvaluationException {
        JsonNodeWrapper valueNode = path.evaluate(this.target);
        if (!valueNode.equals(value)) {
            throw new JsonPatchTestFailedException("Expected " + InPlaceApplyProcessor.show(value) + " but found " + InPlaceApplyProcessor.show(valueNode), path);
        }
    }

    @Override
    public void add(JsonPointer path, JsonNodeWrapper value) throws JsonPointerEvaluationException {
        this.set(path, value, Operation.ADD);
    }

    @Override
    public void replace(JsonPointer path, JsonNodeWrapper value) throws JsonPointerEvaluationException {
        if (path.isRoot()) {
            if (!this.allowRootReplacement()) {
                throw new JsonPatchApplicationException("Cannot replace root document", Operation.REPLACE, path);
            }
            this.target = value;
            return;
        }
        JsonNodeWrapper parentNode = path.getParent().evaluate(this.target);
        RefToken token = path.last();
        if (parentNode.isObject()) {
            if (!this.flags.contains((Object)CompatibilityFlags.ALLOW_MISSING_TARGET_OBJECT_ON_REPLACE) && !parentNode.has(token.getField())) {
                throw new JsonPatchApplicationException("Missing field \"" + token.getField() + "\"", Operation.REPLACE, path.getParent());
            }
            parentNode.objectValue().replace(token.getField(), value);
        } else if (parentNode.isArray()) {
            if (token.getIndex() >= parentNode.size()) {
                throw new JsonPatchApplicationException("Array index " + token.getIndex() + " out of bounds", Operation.REPLACE, path.getParent());
            }
            parentNode.arrayValue().set(token.getIndex(), value);
        } else {
            throw new JsonPatchApplicationException("Can't reference past scalar value", Operation.REPLACE, path.getParent());
        }
    }

    @Override
    public void remove(JsonPointer path) throws JsonPointerEvaluationException {
        if (path.isRoot()) {
            throw new JsonPatchApplicationException("Cannot remove document root", Operation.REMOVE, path);
        }
        JsonNodeWrapper parentNode = path.getParent().evaluate(this.target);
        RefToken token = path.last();
        if (parentNode.isObject()) {
            if (this.flags.contains((Object)CompatibilityFlags.FORBID_REMOVE_MISSING_OBJECT) && !parentNode.has(token.getField())) {
                throw new JsonPatchApplicationException("Missing field " + token.getField(), Operation.REMOVE, path.getParent());
            }
            parentNode.objectValue().remove(token.getField());
        } else if (parentNode.isArray()) {
            if (!this.flags.contains((Object)CompatibilityFlags.REMOVE_NONE_EXISTING_ARRAY_ELEMENT) && token.getIndex() >= parentNode.size()) {
                throw new JsonPatchApplicationException("Array index " + token.getIndex() + " out of bounds", Operation.REMOVE, path.getParent());
            }
            parentNode.arrayValue().remove(token.getIndex());
        } else {
            throw new JsonPatchApplicationException("Cannot reference past scalar value", Operation.REMOVE, path.getParent());
        }
    }

    private void set(JsonPointer path, JsonNodeWrapper value, Operation forOp) throws JsonPointerEvaluationException {
        if (path.isRoot()) {
            if (!this.allowRootReplacement()) {
                throw new JsonPatchApplicationException("Cannot replace root document", forOp, path);
            }
            this.target = value;
            return;
        }
        JsonNodeWrapper parentNode = path.getParent().evaluate(this.target);
        if (!parentNode.isContainerNode()) {
            throw new JsonPatchApplicationException("Cannot reference past scalar value", forOp, path.getParent());
        }
        if (parentNode.isArray()) {
            this.addToArray(path, value, parentNode);
        } else {
            this.addToObject(path, parentNode, value);
        }
    }

    private void addToObject(JsonPointer path, JsonNodeWrapper node, JsonNodeWrapper value) {
        ObjectNodeWrapper target = node.objectValue();
        String key = path.last().getField();
        target.set(key, value);
    }

    private void addToArray(JsonPointer path, JsonNodeWrapper value, JsonNodeWrapper parentNode) {
        ArrayNodeWrapper target = parentNode.arrayValue();
        int idx = path.last().getIndex();
        if (idx == Integer.MIN_VALUE) {
            target.add(value);
        } else {
            if (idx > target.size()) {
                throw new JsonPatchApplicationException("Array index " + idx + " out of bounds", Operation.ADD, path.getParent());
            }
            target.insert(idx, value);
        }
    }
}

