/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.flipkart.zjsonpatch.AbstractJsonPatch;
import com.flipkart.zjsonpatch.CompatibilityFlags;
import com.flipkart.zjsonpatch.CopyingApplyProcessor;
import com.flipkart.zjsonpatch.InPlaceApplyProcessor;
import com.flipkart.zjsonpatch.InvalidJsonPatchException;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import com.flipkart.zjsonpatch.NoopProcessor;
import com.flipkart.zjsonpatch.mapping.JacksonVersionBridge;
import com.flipkart.zjsonpatch.mapping.JsonNodeFactoryWrapper;
import com.flipkart.zjsonpatch.mapping.jackson3.Jackson3NodeFactory;
import java.util.EnumSet;
import tools.jackson.databind.JsonNode;

public final class Jackson3JsonPatch
extends AbstractJsonPatch {
    private static final JsonNodeFactoryWrapper FACTORY = new Jackson3NodeFactory();

    private Jackson3JsonPatch() {
    }

    public static void validate(JsonNode patch, EnumSet<CompatibilityFlags> flags) throws InvalidJsonPatchException {
        Jackson3JsonPatch.process(JacksonVersionBridge.wrap(patch), NoopProcessor.INSTANCE, flags, FACTORY);
    }

    public static void validate(JsonNode patch) throws InvalidJsonPatchException {
        Jackson3JsonPatch.validate(patch, CompatibilityFlags.defaults());
    }

    public static JsonNode apply(JsonNode patch, JsonNode source, EnumSet<CompatibilityFlags> flags) throws JsonPatchApplicationException {
        CopyingApplyProcessor processor = new CopyingApplyProcessor(JacksonVersionBridge.wrap(source), flags);
        Jackson3JsonPatch.process(JacksonVersionBridge.wrap(patch), processor, flags, FACTORY);
        return (JsonNode)JacksonVersionBridge.unwrap(processor.result());
    }

    public static JsonNode apply(JsonNode patch, JsonNode source) throws JsonPatchApplicationException {
        return Jackson3JsonPatch.apply(patch, source, CompatibilityFlags.defaults());
    }

    public static void applyInPlace(JsonNode patch, JsonNode source) {
        Jackson3JsonPatch.applyInPlace(patch, source, CompatibilityFlags.defaults());
    }

    public static void applyInPlace(JsonNode patch, JsonNode source, EnumSet<CompatibilityFlags> flags) {
        InPlaceApplyProcessor processor = new InPlaceApplyProcessor(JacksonVersionBridge.wrap(source), flags);
        Jackson3JsonPatch.process(JacksonVersionBridge.wrap(patch), processor, flags, FACTORY);
    }
}

