/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.zjsonpatch.JsonPointerEvaluationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonPointer {
    private final RefToken[] tokens;
    public static final JsonPointer ROOT = new JsonPointer(new RefToken[0]);
    static final int LAST_INDEX = Integer.MIN_VALUE;

    private JsonPointer(RefToken[] tokens) {
        this.tokens = tokens;
    }

    public JsonPointer(List<RefToken> tokens) {
        this.tokens = tokens.toArray(new RefToken[0]);
    }

    public static JsonPointer parse(String path) throws IllegalArgumentException {
        StringBuilder reftoken = null;
        ArrayList<RefToken> result = new ArrayList<RefToken>();
        block7: for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (i == 0) {
                if (c != '/') {
                    throw new IllegalArgumentException("Missing leading slash");
                }
                reftoken = new StringBuilder();
                continue;
            }
            switch (c) {
                case '~': {
                    switch (path.charAt(++i)) {
                        case '0': 
                        case '1': 
                        case '2': {
                            reftoken.append('~');
                            reftoken.append(path.charAt(i));
                            continue block7;
                        }
                    }
                    throw new IllegalArgumentException("Invalid escape sequence ~" + path.charAt(i) + " at index " + i);
                }
                case '/': {
                    result.add(RefToken.parse(reftoken.toString()));
                    reftoken.setLength(0);
                    continue block7;
                }
                default: {
                    reftoken.append(c);
                }
            }
        }
        if (reftoken == null) {
            return ROOT;
        }
        result.add(RefToken.parse(reftoken.toString()));
        return new JsonPointer(result);
    }

    public boolean isRoot() {
        return this.tokens.length == 0;
    }

    JsonPointer append(String field) {
        RefToken[] newTokens = Arrays.copyOf(this.tokens, this.tokens.length + 1);
        newTokens[this.tokens.length] = new RefToken(field, null, null);
        return new JsonPointer(newTokens);
    }

    JsonPointer append(int index) {
        RefToken[] newTokens = Arrays.copyOf(this.tokens, this.tokens.length + 1);
        newTokens[this.tokens.length] = new RefToken(Integer.toString(index), index, null);
        return new JsonPointer(newTokens);
    }

    int size() {
        return this.tokens.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (RefToken token : this.tokens) {
            sb.append('/');
            sb.append(token);
        }
        return sb.toString();
    }

    public List<RefToken> decompose() {
        return Arrays.asList((RefToken[])this.tokens.clone());
    }

    public RefToken get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.tokens.length) {
            throw new IndexOutOfBoundsException("Illegal index: " + index);
        }
        return this.tokens[index];
    }

    public RefToken last() {
        if (this.isRoot()) {
            throw new IllegalStateException("Root pointers contain no reference tokens");
        }
        return this.tokens[this.tokens.length - 1];
    }

    public JsonPointer getParent() {
        return this.isRoot() ? this : new JsonPointer(Arrays.copyOf(this.tokens, this.tokens.length - 1));
    }

    private void error(int atToken, String message, JsonNode document) throws JsonPointerEvaluationException {
        throw new JsonPointerEvaluationException(message, new JsonPointer(Arrays.copyOf(this.tokens, atToken)), document);
    }

    public JsonNode evaluate(JsonNode document) throws JsonPointerEvaluationException {
        JsonNode current = document;
        for (int idx = 0; idx < this.tokens.length; ++idx) {
            RefToken token = this.tokens[idx];
            if (current.isArray()) {
                if (token.isArrayIndex()) {
                    if (token.getIndex() == Integer.MIN_VALUE || token.getIndex() >= current.size()) {
                        this.error(idx, "Array index " + token + " is out of bounds", document);
                    }
                    current = current.get(token.getIndex());
                    continue;
                }
                if (token.isArrayKeyRef()) {
                    KeyRef keyRef = token.getKeyRef();
                    JsonNode foundArrayNode = null;
                    for (int arrayIdx = 0; arrayIdx < current.size(); ++arrayIdx) {
                        JsonNode arrayNode = current.get(arrayIdx);
                        if (!this.matches(keyRef, arrayNode)) continue;
                        foundArrayNode = arrayNode;
                        break;
                    }
                    if (foundArrayNode == null) {
                        this.error(idx, "Array has no matching object for key reference " + token, document);
                    }
                    current = foundArrayNode;
                    continue;
                }
                this.error(idx, "Can't reference field \"" + token.getField() + "\" on array", document);
                continue;
            }
            if (current.isObject()) {
                if (!current.has(token.getField())) {
                    this.error(idx, "Missing field \"" + token.getField() + "\"", document);
                }
                current = current.get(token.getField());
                continue;
            }
            this.error(idx, "Can't reference past scalar value", document);
        }
        return current;
    }

    private boolean matches(KeyRef keyRef, JsonNode arrayNode) {
        boolean matches = false;
        if (arrayNode.has(keyRef.key)) {
            JsonNode valueNode = arrayNode.get(keyRef.key);
            if (valueNode.isTextual()) {
                matches = Objects.equals(keyRef.value, valueNode.textValue());
            } else if (valueNode.isNumber() || valueNode.isBoolean()) {
                matches = Objects.equals(keyRef.value, valueNode.toString());
            }
        }
        return matches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPointer that = (JsonPointer)o;
        return Arrays.equals(this.tokens, that.tokens);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tokens);
    }

    static class RefToken {
        private final String decodedToken;
        private final Integer index;
        private final KeyRef keyRef;
        private static final Pattern DECODED_TILDA_PATTERN = Pattern.compile("~0");
        private static final Pattern DECODED_SLASH_PATTERN = Pattern.compile("~1");
        private static final Pattern DECODED_EQUALS_PATTERN = Pattern.compile("~2");
        private static final Pattern ENCODED_TILDA_PATTERN = Pattern.compile("~");
        private static final Pattern ENCODED_SLASH_PATTERN = Pattern.compile("/");
        private static final Pattern ENCODED_EQUALS_PATTERN = Pattern.compile("=");
        private static final Pattern VALID_ARRAY_IND = Pattern.compile("-|0|(?:[1-9][0-9]*)");
        private static final Pattern VALID_ARRAY_KEY_REF = Pattern.compile("([^=]+)=([^=]+)");

        private RefToken(String decodedToken, Integer arrayIndex, KeyRef arrayKeyRef) {
            if (decodedToken == null) {
                throw new IllegalArgumentException("Token can't be null");
            }
            this.decodedToken = decodedToken;
            this.index = arrayIndex;
            this.keyRef = arrayKeyRef;
        }

        private static String decodePath(Object object) {
            String path = object.toString();
            path = DECODED_SLASH_PATTERN.matcher(path).replaceAll("/");
            path = DECODED_TILDA_PATTERN.matcher(path).replaceAll("~");
            return DECODED_EQUALS_PATTERN.matcher(path).replaceAll("=");
        }

        private static String encodePath(Object object) {
            String path = object.toString();
            path = ENCODED_TILDA_PATTERN.matcher(path).replaceAll("~0");
            path = ENCODED_SLASH_PATTERN.matcher(path).replaceAll("~1");
            return ENCODED_EQUALS_PATTERN.matcher(path).replaceAll("~2");
        }

        public static RefToken parse(String rawToken) {
            if (rawToken == null) {
                throw new IllegalArgumentException("Token can't be null");
            }
            Integer index = null;
            Matcher indexMatcher = VALID_ARRAY_IND.matcher(rawToken);
            if (indexMatcher.matches()) {
                if (indexMatcher.group().equals("-")) {
                    index = Integer.MIN_VALUE;
                } else {
                    try {
                        int validInt = Integer.parseInt(indexMatcher.group());
                        index = validInt;
                    }
                    catch (NumberFormatException validInt) {
                        // empty catch block
                    }
                }
            }
            KeyRef keyRef = null;
            Matcher arrayKeyRefMatcher = VALID_ARRAY_KEY_REF.matcher(rawToken);
            if (arrayKeyRefMatcher.matches()) {
                keyRef = new KeyRef(RefToken.decodePath(arrayKeyRefMatcher.group(1)), RefToken.decodePath(arrayKeyRefMatcher.group(2)));
            }
            return new RefToken(RefToken.decodePath(rawToken), index, keyRef);
        }

        public boolean isArrayIndex() {
            return this.index != null;
        }

        public boolean isArrayKeyRef() {
            return this.keyRef != null;
        }

        public int getIndex() {
            if (!this.isArrayIndex()) {
                throw new IllegalStateException("Object operation on array index target");
            }
            return this.index;
        }

        public KeyRef getKeyRef() {
            if (!this.isArrayKeyRef()) {
                throw new IllegalStateException("Object operation on array key ref target");
            }
            return this.keyRef;
        }

        public String getField() {
            return this.decodedToken;
        }

        public String toString() {
            if (this.isArrayKeyRef()) {
                return RefToken.encodePath(this.keyRef.key) + "=" + RefToken.encodePath(this.keyRef.value);
            }
            return RefToken.encodePath(this.decodedToken);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RefToken refToken = (RefToken)o;
            return this.decodedToken.equals(refToken.decodedToken);
        }

        public int hashCode() {
            return this.decodedToken.hashCode();
        }
    }

    static class KeyRef {
        private String key;
        private String value;

        public KeyRef(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyRef keyRef = (KeyRef)o;
            return Objects.equals(this.key, keyRef.key) && Objects.equals(this.value, keyRef.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }
}

