/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.eclipse.jgit.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.outerj.eclipse.jgit.diff.RawTextTokenizer;
import org.outerj.eclipse.jgit.util.IntList;

public final class RawParseUtils {
    public static final Charset UTF8_CHARSET;
    private static final byte[] digits10;
    private static final byte[] digits16;
    private static final byte[] footerLineKeyChars;
    private static final Map<String, Charset> encodingAliases;
    private static final byte[] base10byte;
    public static final RawTextTokenizer MAP_LINES;
    public static final RawTextTokenizer MAP_SENTENCES;

    public static final int match(byte[] b, int ptr, byte[] src) {
        if (ptr + src.length > b.length) {
            return -1;
        }
        int i = 0;
        while (i < src.length) {
            if (b[ptr] != src[i]) {
                return -1;
            }
            ++i;
            ++ptr;
        }
        return ptr;
    }

    public static int formatBase10(byte[] b, int o, int value) {
        boolean isneg;
        if (value == 0) {
            b[--o] = 48;
            return o;
        }
        boolean bl = isneg = value < 0;
        if (isneg) {
            value = -value;
        }
        while (value != 0) {
            b[--o] = base10byte[value % 10];
            value /= 10;
        }
        if (isneg) {
            b[--o] = 45;
        }
        return o;
    }

    public static final int parseHexInt16(byte[] bs, int p) {
        int r = digits16[bs[p]] << 4;
        r |= digits16[bs[p + 1]];
        r <<= 4;
        r |= digits16[bs[p + 2]];
        r <<= 4;
        if ((r |= digits16[bs[p + 3]]) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r;
    }

    public static final int parseHexInt32(byte[] bs, int p) {
        int r = digits16[bs[p]] << 4;
        r |= digits16[bs[p + 1]];
        r <<= 4;
        r |= digits16[bs[p + 2]];
        r <<= 4;
        r |= digits16[bs[p + 3]];
        r <<= 4;
        r |= digits16[bs[p + 4]];
        r <<= 4;
        r |= digits16[bs[p + 5]];
        r <<= 4;
        byte last = digits16[bs[p + 7]];
        if ((r |= digits16[bs[p + 6]]) < 0 || last < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r << 4 | last;
    }

    public static final long parseHexInt64(byte[] bs, int p) {
        long r = digits16[bs[p]] << 4;
        r |= (long)digits16[bs[p + 1]];
        r <<= 4;
        r |= (long)digits16[bs[p + 2]];
        r <<= 4;
        r |= (long)digits16[bs[p + 3]];
        r <<= 4;
        r |= (long)digits16[bs[p + 4]];
        r <<= 4;
        r |= (long)digits16[bs[p + 5]];
        r <<= 4;
        r |= (long)digits16[bs[p + 6]];
        r <<= 4;
        r |= (long)digits16[bs[p + 7]];
        r <<= 4;
        r |= (long)digits16[bs[p + 8]];
        r <<= 4;
        r |= (long)digits16[bs[p + 9]];
        r <<= 4;
        r |= (long)digits16[bs[p + 10]];
        r <<= 4;
        r |= (long)digits16[bs[p + 11]];
        r <<= 4;
        r |= (long)digits16[bs[p + 12]];
        r <<= 4;
        r |= (long)digits16[bs[p + 13]];
        r <<= 4;
        byte last = digits16[bs[p + 15]];
        if ((r |= (long)digits16[bs[p + 14]]) < 0L || last < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r << 4 | (long)last;
    }

    public static final int parseHexInt4(byte digit) {
        byte r = digits16[digit];
        if (r < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r;
    }

    public static final int next(byte[] b, int ptr, char chrA) {
        int sz = b.length;
        while (ptr < sz) {
            if (b[ptr++] != chrA) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int nextLF(byte[] b, int ptr) {
        return RawParseUtils.next(b, ptr, '\n');
    }

    public static final int nextLF(byte[] b, int ptr, char chrA) {
        int sz = b.length;
        while (ptr < sz) {
            byte c;
            if ((c = b[ptr++]) != chrA && c != 10) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int nextSentenceDelimiter(byte[] b, int ptr) {
        int chrA = 46;
        int chrB = 44;
        int sz = b.length;
        while (ptr < sz) {
            byte c;
            if ((c = b[ptr++]) != 46 && c != 44 && c != 10) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int prev(byte[] b, int ptr, char chrA) {
        if (ptr == b.length) {
            --ptr;
        }
        while (ptr >= 0) {
            if (b[ptr--] != chrA) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int prevLF(byte[] b, int ptr) {
        return RawParseUtils.prev(b, ptr, '\n');
    }

    public static final int prevLF(byte[] b, int ptr, char chrA) {
        if (ptr == b.length) {
            --ptr;
        }
        while (ptr >= 0) {
            byte c;
            if ((c = b[ptr--]) != chrA && c != 10) continue;
            return ptr;
        }
        return ptr;
    }

    public static final IntList lineMap(byte[] buf, int ptr, int end) {
        IntList map = new IntList((end - ptr) / 36);
        map.fillTo(1, Integer.MIN_VALUE);
        while (ptr < end) {
            map.add(ptr);
            ptr = RawParseUtils.nextLF(buf, ptr);
        }
        map.add(end);
        return map;
    }

    public static final IntList sentenceMap(byte[] buf, int ptr, int end) {
        IntList map = new IntList((end - ptr) / 10);
        map.fillTo(1, Integer.MIN_VALUE);
        while (ptr < end) {
            map.add(ptr);
            ptr = RawParseUtils.nextSentenceDelimiter(buf, ptr);
        }
        map.add(end);
        return map;
    }

    public static int endOfFooterLineKey(byte[] raw, int ptr) {
        try {
            while (true) {
                byte c;
                if (footerLineKeyChars[c = raw[ptr]] == 0) {
                    if (c == 58) {
                        return ptr;
                    }
                    return -1;
                }
                ++ptr;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    public static String decode(byte[] buffer) {
        return RawParseUtils.decode(buffer, 0, buffer.length);
    }

    public static String decode(byte[] buffer, int start, int end) {
        return RawParseUtils.decode(StandardCharsets.UTF_8, buffer, start, end);
    }

    public static String decode(Charset cs, byte[] buffer) {
        return RawParseUtils.decode(cs, buffer, 0, buffer.length);
    }

    public static String decode(Charset cs, byte[] buffer, int start, int end) {
        try {
            return RawParseUtils.decodeNoFallback(cs, buffer, start, end);
        }
        catch (CharacterCodingException e) {
            return RawParseUtils.extractBinaryString(buffer, start, end);
        }
    }

    public static String decodeNoFallback(Charset cs, byte[] buffer, int start, int end) throws CharacterCodingException {
        ByteBuffer b = ByteBuffer.wrap(buffer, start, end - start);
        b.mark();
        try {
            return RawParseUtils.decode(b, StandardCharsets.UTF_8);
        }
        catch (CharacterCodingException e) {
            Charset defcs;
            b.reset();
            if (!cs.equals(StandardCharsets.UTF_8)) {
                try {
                    return RawParseUtils.decode(b, cs);
                }
                catch (CharacterCodingException e2) {
                    b.reset();
                }
            }
            if (!(defcs = Charset.defaultCharset()).equals(cs) && !defcs.equals(StandardCharsets.UTF_8)) {
                try {
                    return RawParseUtils.decode(b, defcs);
                }
                catch (CharacterCodingException e3) {
                    b.reset();
                }
            }
            throw new CharacterCodingException();
        }
    }

    public static String extractBinaryString(byte[] buffer, int start, int end) {
        StringBuilder r = new StringBuilder(end - start);
        for (int i = start; i < end; ++i) {
            r.append((char)(buffer[i] & 0xFF));
        }
        return r.toString();
    }

    private static String decode(ByteBuffer b, Charset charset) throws CharacterCodingException {
        CharsetDecoder d = charset.newDecoder();
        d.onMalformedInput(CodingErrorAction.REPORT);
        d.onUnmappableCharacter(CodingErrorAction.REPORT);
        return d.decode(b).toString();
    }

    public static final int commitMessage(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        return RawParseUtils.tagMessage(b, ptr);
    }

    public static final int tagMessage(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 48;
        }
        while (ptr < sz && b[ptr] != 10) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        if (ptr < sz && b[ptr] == 10) {
            return ptr + 1;
        }
        return -1;
    }

    public static final int endOfParagraph(byte[] b, int start) {
        int ptr = start;
        int sz = b.length;
        while (ptr < sz && b[ptr] != 10 && b[ptr] != 13) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        if (ptr > start && b[ptr - 1] == 10) {
            --ptr;
        }
        if (ptr > start && b[ptr - 1] == 13) {
            --ptr;
        }
        return ptr;
    }

    public static int lastIndexOfTrim(byte[] raw, char ch, int pos) {
        while (pos >= 0 && raw[pos] == 32) {
            --pos;
        }
        while (pos >= 0 && raw[pos] != ch) {
            --pos;
        }
        return pos;
    }

    private RawParseUtils() {
    }

    static {
        int i;
        UTF8_CHARSET = StandardCharsets.UTF_8;
        encodingAliases = new HashMap<String, Charset>();
        encodingAliases.put("latin-1", StandardCharsets.ISO_8859_1);
        encodingAliases.put("iso-latin-1", StandardCharsets.ISO_8859_1);
        digits10 = new byte[58];
        Arrays.fill(digits10, (byte)-1);
        for (i = 48; i <= 57; i = (int)((char)(i + 1))) {
            RawParseUtils.digits10[i] = (byte)(i - 48);
        }
        digits16 = new byte[103];
        Arrays.fill(digits16, (byte)-1);
        for (i = 48; i <= 57; i = (int)((char)(i + 1))) {
            RawParseUtils.digits16[i] = (byte)(i - 48);
        }
        for (i = 97; i <= 102; i = (int)((char)(i + 1))) {
            RawParseUtils.digits16[i] = (byte)(i - 97 + 10);
        }
        for (i = 65; i <= 70; i = (int)((char)(i + 1))) {
            RawParseUtils.digits16[i] = (byte)(i - 65 + 10);
        }
        footerLineKeyChars = new byte[123];
        RawParseUtils.footerLineKeyChars[45] = 1;
        for (i = 48; i <= 57; i = (int)((char)(i + 1))) {
            RawParseUtils.footerLineKeyChars[i] = 1;
        }
        for (i = 65; i <= 90; i = (int)((char)(i + 1))) {
            RawParseUtils.footerLineKeyChars[i] = 1;
        }
        for (i = 97; i <= 122; i = (int)((char)(i + 1))) {
            RawParseUtils.footerLineKeyChars[i] = 1;
        }
        base10byte = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        MAP_LINES = new RawTextTokenizer(){

            @Override
            public IntList tokenMap(byte[] buf, int ptr, int end) {
                return RawParseUtils.lineMap(buf, ptr, end);
            }
        };
        MAP_SENTENCES = new RawTextTokenizer(){

            @Override
            public IntList tokenMap(byte[] buf, int ptr, int end) {
                return RawParseUtils.sentenceMap(buf, ptr, end);
            }
        };
    }
}

