/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.eclipse.jgit.diff;

import java.util.List;
import org.outerj.daisy.diff.output.TextDiffOutput;
import org.outerj.eclipse.jgit.diff.Edit;
import org.outerj.eclipse.jgit.diff.EditList;
import org.outerj.eclipse.jgit.diff.RawText;

public class HistogramFormat {
    public static final HistogramFormat INSTANCE = new HistogramFormat();
    private final int context = 1000;

    public void format(EditList edits, RawText a, RawText b, TextDiffOutput output) throws Exception {
        int curIdx = 0;
        while (curIdx < edits.size()) {
            Edit curEdit = (Edit)edits.get(curIdx);
            int endIdx = this.findCombinedEnd(edits, curIdx);
            int aCur = 0;
            int bCur = 0;
            int aEnd = a.size();
            int bEnd = b.size();
            while (aCur < aEnd || bCur < bEnd) {
                if (aCur < curEdit.getBeginA() || endIdx + 1 < curIdx) {
                    if (aCur < aEnd) {
                        output.addClearPart(a.getStringN(aCur));
                    }
                    ++aCur;
                    ++bCur;
                } else if (aCur < curEdit.getEndA()) {
                    if (aCur < aEnd) {
                        output.addRemovedPart(a.getStringN(aCur));
                    }
                    ++aCur;
                } else if (bCur < curEdit.getEndB()) {
                    output.addAddedPart(b.getStringN(bCur));
                    ++bCur;
                }
                if (!HistogramFormat.end(curEdit, aCur, bCur) || ++curIdx >= edits.size()) continue;
                curEdit = (Edit)edits.get(curIdx);
            }
        }
    }

    private int findCombinedEnd(List<Edit> edits, int i) {
        int end;
        for (end = i + 1; end < edits.size() && (this.combineA(edits, end) || this.combineB(edits, end)); ++end) {
        }
        return end - 1;
    }

    private boolean combineA(List<Edit> e, int i) {
        return e.get(i).getBeginA() - e.get(i - 1).getEndA() <= 2000;
    }

    private boolean combineB(List<Edit> e, int i) {
        return e.get(i).getBeginB() - e.get(i - 1).getEndB() <= 2000;
    }

    private static boolean end(Edit edit, int a, int b) {
        return edit.getEndA() <= a && edit.getEndB() <= b;
    }
}

