/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.tag;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import org.outerj.daisy.diff.tag.Atom;
import org.outerj.daisy.diff.tag.DelimiterAtom;
import org.outerj.daisy.diff.tag.TagAtom;
import org.outerj.daisy.diff.tag.TextAtom;

public class AtomBuilder {
    private final List<Atom> atoms;

    public AtomBuilder(String s, List<Atom> atoms) {
        this.atoms = atoms;
        this.generateAtoms(s);
    }

    public AtomBuilder(StringBuilder s, List<Atom> atoms) {
        this.atoms = atoms;
        this.generateAtoms(s.toString());
    }

    public AtomBuilder(BufferedReader in, List<Atom> atoms) throws IOException {
        this.atoms = atoms;
        StringBuilder sb = new StringBuilder();
        boolean allRead = false;
        while (!allRead) {
            int result = in.read();
            if (result >= 0) {
                sb.append((char)result);
                continue;
            }
            this.generateAtoms(sb.toString());
            allRead = true;
        }
    }

    private void generateAtoms(String s) {
        if (this.atoms.size() > 0) {
            throw new IllegalStateException("Atoms can only be generated once");
        }
        StringBuilder currentWord = new StringBuilder(100);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<' && TagAtom.isValidTag(s.substring(i, s.indexOf(62, i) + 1))) {
                if (currentWord.length() > 0) {
                    this.atoms.add(new TextAtom(currentWord.toString()));
                    currentWord.setLength(0);
                }
                int end = s.indexOf(62, i);
                this.atoms.add(new TagAtom(s.substring(i, end + 1)));
                i = end;
                continue;
            }
            if (DelimiterAtom.isValidDelimiter("" + c)) {
                if (currentWord.length() > 0) {
                    this.atoms.add(new TextAtom(currentWord.toString()));
                    currentWord.setLength(0);
                }
                this.atoms.add(new DelimiterAtom(c));
                continue;
            }
            currentWord.append(c);
        }
        if (currentWord.length() > 0) {
            this.atoms.add(new TextAtom(currentWord.toString()));
            currentWord.setLength(0);
        }
    }
}

