/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.output;

import java.util.ArrayList;
import java.util.List;
import org.outerj.daisy.diff.output.TextDiffOutput;

public class ConsolidateOutput
implements TextDiffOutput {
    private final TextDiffOutput parent;
    private final List<TextOperation> results = new ArrayList<TextOperation>();
    private TextOperation currOperation = new TextOperation();

    public ConsolidateOutput(TextDiffOutput parent) {
        this.parent = parent;
    }

    @Override
    public void addAddedPart(String text) throws Exception {
        if (this.currOperation.type == OperationType.ADD_TEXT) {
            this.currOperation.consolidate(text);
            return;
        }
        this.currOperation = new TextOperation();
        this.currOperation.setText(text);
        this.currOperation.setType(OperationType.ADD_TEXT);
        this.results.add(this.currOperation);
    }

    @Override
    public void addClearPart(String text) throws Exception {
        if (this.currOperation.type == OperationType.NO_CHANGE) {
            this.currOperation.consolidate(text);
            return;
        }
        this.currOperation = new TextOperation();
        this.currOperation.setText(text);
        this.currOperation.setType(OperationType.NO_CHANGE);
        this.results.add(this.currOperation);
    }

    @Override
    public void addRemovedPart(String text) throws Exception {
        if (this.currOperation.type == OperationType.REMOVE_TEXT) {
            this.currOperation.consolidate(text);
            return;
        }
        this.currOperation = new TextOperation();
        this.currOperation.setText(text);
        this.currOperation.setType(OperationType.REMOVE_TEXT);
        this.results.add(this.currOperation);
    }

    public void flushToParent() throws Exception {
        for (TextOperation op : this.results) {
            switch (op.getType()) {
                case NO_CHANGE: {
                    this.parent.addClearPart(op.getText());
                    break;
                }
                case ADD_TEXT: {
                    this.parent.addAddedPart(op.getText());
                    break;
                }
                case REMOVE_TEXT: {
                    this.parent.addRemovedPart(op.getText());
                }
            }
        }
    }

    public String getOriginalText() {
        StringBuilder result = new StringBuilder();
        for (TextOperation op : this.results) {
            if (op.getType() == OperationType.ADD_TEXT) continue;
            result.append(op.getText());
        }
        return result.toString();
    }

    @Override
    public void newline() {
        this.currOperation.consolidate("\n");
    }

    private static class TextOperation {
        private String text = null;
        private OperationType type = null;
        private StringBuilder buffer;

        private TextOperation() {
        }

        public String toString() {
            return "[" + (Object)((Object)this.type) + ": '" + this.getText() + "']";
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setType(OperationType type) {
            this.type = type;
        }

        public String getText() {
            if (this.text == null && this.buffer != null) {
                this.text = this.buffer.toString();
                this.buffer = null;
            }
            return this.text;
        }

        public OperationType getType() {
            return this.type;
        }

        public void consolidate(String text) {
            if (this.buffer == null) {
                this.buffer = new StringBuilder(this.text);
                this.text = null;
            }
            this.buffer.append(text);
        }
    }

    private static enum OperationType {
        NO_CHANGE,
        ADD_TEXT,
        REMOVE_TEXT;

    }
}

