/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff;

import java.io.BufferedReader;
import java.io.InputStream;
import org.outerj.daisy.diff.output.ConsolidateOutput;
import org.outerj.daisy.diff.tag.AtomComparator;
import org.outerj.daisy.diff.tag.AtomFormat;
import org.outerj.daisy.diff.tag.AtomList;
import org.outerj.daisy.diff.tag.TagComparator;
import org.outerj.daisy.diff.tag.TagDiffer;
import org.outerj.daisy.diff.tag.TagSaxDiffOutput;
import org.outerj.eclipse.jgit.diff.EditList;
import org.outerj.eclipse.jgit.diff.HistogramDiff;
import org.outerj.eclipse.jgit.diff.HistogramFormat;
import org.outerj.eclipse.jgit.diff.RawText;
import org.outerj.eclipse.jgit.diff.RawTextComparator;
import org.outerj.eclipse.jgit.util.IO;
import org.outerj.eclipse.jgit.util.RawParseUtils;
import org.xml.sax.ContentHandler;

public class DaisyDiff {
    private static final int LAW_SIZE = 10240;

    public static void diffTag(String oldText, String newText, ContentHandler consumer) throws Exception {
        TagComparator oldComp = new TagComparator(oldText);
        TagComparator newComp = new TagComparator(newText);
        DaisyDiff.diffTag(consumer, oldComp, newComp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void diffTag(BufferedReader oldText, BufferedReader newText, ContentHandler consumer) throws Exception {
        try {
            TagComparator oldComp = new TagComparator(oldText);
            TagComparator newComp = new TagComparator(newText);
            DaisyDiff.diffTag(consumer, oldComp, newComp);
        }
        finally {
            oldText.close();
            newText.close();
        }
    }

    private static void diffTag(ContentHandler consumer, TagComparator oldComp, TagComparator newComp) throws Exception {
        TagSaxDiffOutput output = new TagSaxDiffOutput(consumer);
        TagDiffer differ = new TagDiffer(output);
        differ.diff(oldComp, newComp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void diffHistogram(BufferedReader oldText, BufferedReader newText, ContentHandler consumer) throws Exception {
        try {
            AtomList oldComp = new AtomList(oldText);
            AtomList newComp = new AtomList(newText);
            DaisyDiff.diffHistogram(consumer, oldComp, newComp);
        }
        finally {
            oldText.close();
            newText.close();
        }
    }

    private static void diffHistogram(ContentHandler consumer, AtomList oldComp, AtomList newComp) throws Exception {
        ConsolidateOutput output = new ConsolidateOutput(new TagSaxDiffOutput(consumer));
        HistogramDiff differ = new HistogramDiff();
        EditList editList = differ.diff(AtomComparator.DEFAULT, oldComp, newComp);
        if (editList.isEmpty()) {
            output.addClearPart(output.getOriginalText());
        } else {
            AtomFormat.INSTANCE.format(editList, oldComp, newComp, output);
        }
        output.flushToParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void diffHistogramRaw(InputStream oldText, InputStream newText, ContentHandler consumer) throws Exception {
        try {
            RawText oldComp = new RawText(IO.readWholeStream(oldText, 10240).array(), RawParseUtils.MAP_SENTENCES);
            RawText newComp = new RawText(IO.readWholeStream(newText, 10240).array(), RawParseUtils.MAP_SENTENCES);
            DaisyDiff.diffHistogramRaw(consumer, oldComp, newComp);
        }
        finally {
            oldText.close();
            newText.close();
        }
    }

    private static void diffHistogramRaw(ContentHandler consumer, RawText oldComp, RawText newComp) throws Exception {
        TagSaxDiffOutput output = new TagSaxDiffOutput(consumer);
        HistogramDiff differ = new HistogramDiff();
        EditList editList = differ.diff(RawTextComparator.WS_IGNORE_ALL, oldComp, newComp);
        if (editList.isEmpty()) {
            output.addClearPart(oldComp.getString(1));
        } else {
            HistogramFormat.INSTANCE.format(editList, oldComp, newComp, output);
        }
    }
}

