/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldsFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.template.BiFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Strings;
import java.lang.reflect.Field;
import java.util.Map;

public interface GetDeclaredFieldFunction
extends BiFunction<Class<?>, String, Field> {

    public static class ForJava7
    implements GetDeclaredFieldFunction {
        protected GetDeclaredFieldsFunction getDeclaredFields;
        protected ThrowExceptionFunction throwExceptionFunction;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.getDeclaredFields = functionProvider.getOrBuildObject(GetDeclaredFieldsFunction.class, context);
            this.throwExceptionFunction = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, context);
        }

        @Override
        public Field apply(Class<?> cls, String name) {
            try {
                for (Field field : (Field[])this.getDeclaredFields.apply(cls)) {
                    if (!field.getName().equals(name)) continue;
                    return field;
                }
            }
            catch (Throwable exc) {
                return (Field)this.throwExceptionFunction.apply(exc, new Object[0]);
            }
            return (Field)this.throwExceptionFunction.apply(new NoSuchFieldException(Strings.compile("Field named {} not found in the class {}", name, cls.getName())), new Object[0]);
        }
    }
}

