/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import android.os.Build;
import android.util.Rational;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.internal.utils.extensions.ContextExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.extensions.ExtensionsKt;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import io.github.thibaultbee.streampack.utils.ContextExtensionsForCameraKt;
import io.github.thibaultbee.streampack.utils.Exposure;
import io.github.thibaultbee.streampack.utils.Focus;
import io.github.thibaultbee.streampack.utils.WhiteBalance;
import io.github.thibaultbee.streampack.utils.Zoom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 72\u00020\u0001:\u00017B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ2\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u0006\u0010\u001c\u001a\u00020\u0015J\b\u0010\u001d\u001a\u00020\u0015H\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010$\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u001fH\u0002J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001fH\u0002J\u001e\u0010.\u001a\u00020\u00152\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u00020\u001fJF\u0010.\u001a\u00020\u00152\u000e\b\u0002\u00100\u001a\b\u0012\u0004\u0012\u00020)0\u00172\u000e\b\u0002\u00101\u001a\b\u0012\u0004\u0012\u00020)0\u00172\u000e\b\u0002\u00102\u001a\b\u0012\u0004\u0012\u00020)0\u00172\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u00020\u001fJ:\u00103\u001a\u00020\u00152\f\u00100\u001a\b\u0012\u0004\u0012\u00020)0\u00172\f\u00101\u001a\b\u0012\u0004\u0012\u00020)0\u00172\f\u00102\u001a\b\u0012\u0004\u0012\u00020)0\u00172\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020\u0015H\u0002R\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lio/github/thibaultbee/streampack/utils/FocusMetering;", "", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "zoom", "Lio/github/thibaultbee/streampack/utils/Zoom;", "focus", "Lio/github/thibaultbee/streampack/utils/Focus;", "exposure", "Lio/github/thibaultbee/streampack/utils/Exposure;", "whiteBalance", "Lio/github/thibaultbee/streampack/utils/WhiteBalance;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;Lio/github/thibaultbee/streampack/utils/Zoom;Lio/github/thibaultbee/streampack/utils/Focus;Lio/github/thibaultbee/streampack/utils/Exposure;Lio/github/thibaultbee/streampack/utils/WhiteBalance;)V", "autoCancelHandle", "Ljava/util/concurrent/ScheduledFuture;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "addFocusMetering", "", "afRects", "", "Landroid/hardware/camera2/params/MeteringRectangle;", "aeRects", "awbRects", "cancelAfAeTrigger", "cancelFocusAndMetering", "disableAutoCancel", "getRelativeRotationDegrees", "", "sourceRotationDegrees", "destRotationDegrees", "isFacingFront", "", "getSensorRotationDegrees", "cameraId", "", "surfaceRotationDegrees", "normalizePoint", "Landroid/graphics/PointF;", "point", "fovRect", "Landroid/graphics/Rect;", "relativeRotation", "onTap", "fovRotationDegree", "afPoints", "aePoints", "awbPoints", "startFocusAndMetering", "fovAspectRatio", "Landroid/util/Rational;", "triggerAf", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nCameraSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraSettings.kt\nio/github/thibaultbee/streampack/utils/FocusMetering\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1049:1\n37#2,2:1050\n37#2,2:1052\n37#2,2:1054\n1549#3:1056\n1620#3,3:1057\n1549#3:1060\n1620#3,3:1061\n1549#3:1064\n1620#3,3:1065\n*S KotlinDebug\n*F\n+ 1 CameraSettings.kt\nio/github/thibaultbee/streampack/utils/FocusMetering\n*L\n713#1:1050,2\n716#1:1052,2\n719#1:1054,2\n890#1:1056\n890#1:1057,3\n891#1:1060\n891#1:1061,3\n892#1:1064\n892#1:1065,3\n*E\n"})
public final class FocusMetering {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final CameraController cameraController;
    @NotNull
    private final Zoom zoom;
    @NotNull
    private final Focus focus;
    @NotNull
    private final Exposure exposure;
    @NotNull
    private final WhiteBalance whiteBalance;
    private final ScheduledExecutorService scheduler;
    @Nullable
    private ScheduledFuture<?> autoCancelHandle;
    @NotNull
    private static final String TAG = "CameraSettings";
    private static final float DEFAULT_AF_SIZE = 0.16666667f;
    private static final float DEFAULT_AE_SIZE = 0.25f;
    private static final int DEFAULT_METERING_WEIGHT_MAX = 1000;
    private static final long DEFAULT_AUTO_CANCEL_DURATION_MS = 5000L;

    public FocusMetering(@NotNull Context context, @NotNull CameraController cameraController, @NotNull Zoom zoom, @NotNull Focus focus, @NotNull Exposure exposure, @NotNull WhiteBalance whiteBalance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
        Intrinsics.checkNotNullParameter((Object)zoom, (String)"zoom");
        Intrinsics.checkNotNullParameter((Object)focus, (String)"focus");
        Intrinsics.checkNotNullParameter((Object)exposure, (String)"exposure");
        Intrinsics.checkNotNullParameter((Object)whiteBalance, (String)"whiteBalance");
        this.context = context;
        this.cameraController = cameraController;
        this.zoom = zoom;
        this.focus = focus;
        this.exposure = exposure;
        this.whiteBalance = whiteBalance;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    private final void cancelAfAeTrigger() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CaptureRequest.CONTROL_AF_TRIGGER, (Object)2)};
        Map cancelTriggerMap = MapsKt.mutableMapOf((Pair[])pairArray);
        if (Build.VERSION.SDK_INT >= 23) {
            cancelTriggerMap.put(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, 2);
        }
        Intrinsics.checkNotNull((Object)cancelTriggerMap, (String)"null cannot be cast to non-null type kotlin.collections.Map<android.hardware.camera2.CaptureRequest.Key<kotlin.Any>, kotlin.Any>");
        this.cameraController.setBurstSettings(cancelTriggerMap);
    }

    private final void addFocusMetering(List<MeteringRectangle> afRects, List<MeteringRectangle> aeRects, List<MeteringRectangle> awbRects) {
        MeteringRectangle[] thisCollection$iv;
        boolean $i$f$toTypedArray;
        Object $this$toTypedArray$iv;
        CaptureRequest.Key key;
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            throw new IllegalStateException("Camera ID is null");
        }
        String it = string2;
        boolean bl = false;
        int afMode = FocusMetering.Companion.getPreferredAFMode(this.context, it, 1);
        Object object = new Pair[]{TuplesKt.to((Object)CaptureRequest.CONTROL_AF_MODE, (Object)afMode), TuplesKt.to((Object)CaptureRequest.CONTROL_AF_TRIGGER, (Object)1)};
        Map settingsMap = MapsKt.mutableMapOf((Pair[])object);
        if (!((Collection)afRects).isEmpty()) {
            object = settingsMap;
            CaptureRequest.Key key2 = CaptureRequest.CONTROL_AF_REGIONS;
            Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"CONTROL_AF_REGIONS");
            key = key2;
            $this$toTypedArray$iv = (MeteringRectangle[])afRects;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = thisCollection$iv.toArray(new MeteringRectangle[0]);
            object.put(key, $this$toTypedArray$iv);
        }
        if (!((Collection)aeRects).isEmpty()) {
            object = settingsMap;
            CaptureRequest.Key key3 = CaptureRequest.CONTROL_AE_REGIONS;
            Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"CONTROL_AE_REGIONS");
            key = key3;
            $this$toTypedArray$iv = aeRects;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = thisCollection$iv.toArray(new MeteringRectangle[0]);
            object.put(key, $this$toTypedArray$iv);
        }
        if (!((Collection)awbRects).isEmpty()) {
            object = settingsMap;
            CaptureRequest.Key key4 = CaptureRequest.CONTROL_AWB_REGIONS;
            Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"CONTROL_AWB_REGIONS");
            key = key4;
            $this$toTypedArray$iv = awbRects;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            MeteringRectangle[] meteringRectangleArray = thisCollection$iv.toArray(new MeteringRectangle[0]);
            object.put(key, meteringRectangleArray);
        }
        Intrinsics.checkNotNull((Object)settingsMap, (String)"null cannot be cast to non-null type kotlin.collections.Map<android.hardware.camera2.CaptureRequest.Key<kotlin.Any>, kotlin.Any>");
        this.cameraController.setRepeatingSettings(settingsMap);
    }

    private final void triggerAf() {
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            throw new IllegalStateException("Camera ID is null");
        }
        String it = string2;
        boolean bl = false;
        int aeMode = FocusMetering.Companion.getPreferredAEMode(this.context, it, 1);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CaptureRequest.CONTROL_AF_TRIGGER, (Object)1), TuplesKt.to((Object)CaptureRequest.CONTROL_AE_MODE, (Object)aeMode)};
        Map settingsMap = MapsKt.mutableMapOf((Pair[])pairArray);
        Intrinsics.checkNotNull((Object)settingsMap, (String)"null cannot be cast to non-null type kotlin.collections.Map<android.hardware.camera2.CaptureRequest.Key<kotlin.Any>, kotlin.Any>");
        this.cameraController.setBurstSettings(settingsMap);
    }

    private final void startFocusAndMetering(List<? extends PointF> afPoints, List<? extends PointF> aePoints, List<? extends PointF> awbPoints, Rational fovAspectRatio) {
        if (afPoints.isEmpty() && aePoints.isEmpty() && awbPoints.isEmpty()) {
            ILogger.DefaultImpls.e$default(Logger.INSTANCE, TAG, "No focus/metering points provided", null, 4, null);
            return;
        }
        Rect cropRegion = this.zoom.getCropSensorRegion$core_release();
        this.disableAutoCancel();
        int maxAFRegion = this.focus.getMaxNumOfMeteringRegions();
        int maxAERegion = this.exposure.getMaxNumOfMeteringRegions();
        int maxWbRegion = this.whiteBalance.getMaxNumOfMeteringRegions();
        if (maxAFRegion == 0 && maxAERegion == 0 && maxWbRegion == 0) {
            ILogger.DefaultImpls.w$default(Logger.INSTANCE, TAG, "No metering regions available", null, 4, null);
            return;
        }
        List afRectangles = FocusMetering.Companion.getMeteringRectangles(afPoints, 0.16666667f, maxAFRegion, cropRegion, fovAspectRatio);
        List aeRectangles = FocusMetering.Companion.getMeteringRectangles(aePoints, 0.25f, maxAERegion, cropRegion, fovAspectRatio);
        List awbRectangles = FocusMetering.Companion.getMeteringRectangles(awbPoints, 0.16666667f, maxWbRegion, cropRegion, fovAspectRatio);
        this.addFocusMetering(afRectangles, aeRectangles, awbRectangles);
        this.triggerAf();
        this.autoCancelHandle = this.scheduler.schedule(() -> FocusMetering.startFocusAndMetering$lambda$2(this), 5000L, TimeUnit.MILLISECONDS);
    }

    private final void disableAutoCancel() {
        ScheduledFuture<?> scheduledFuture = this.autoCancelHandle;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.autoCancelHandle = null;
    }

    private final int getSensorRotationDegrees(Context context, String cameraId2, int surfaceRotationDegrees) {
        CameraCharacteristics characteristics = ContextExtensionsForCameraKt.getCameraCharacteristics(context, cameraId2);
        Integer sensorOrientationDegrees = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        if (!(sensorOrientationDegrees != null)) {
            boolean bl = false;
            String string2 = "Camera " + cameraId2 + " has no defined sensor orientation.";
            throw new IllegalArgumentException(string2.toString());
        }
        Integer n = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
        boolean isFacingFront = n != null && n == 0;
        return this.getRelativeRotationDegrees(sensorOrientationDegrees, surfaceRotationDegrees, isFacingFront);
    }

    static /* synthetic */ int getSensorRotationDegrees$default(FocusMetering focusMetering, Context context, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return focusMetering.getSensorRotationDegrees(context, string2, n);
    }

    private final int getRelativeRotationDegrees(int sourceRotationDegrees, int destRotationDegrees, boolean isFacingFront) {
        return isFacingFront ? (sourceRotationDegrees + destRotationDegrees + 360) % 360 : (sourceRotationDegrees - destRotationDegrees + 360) % 360;
    }

    private final PointF normalizePoint(PointF point, Rect fovRect, int relativeRotation) {
        PointF normalizedPoint = ExtensionsKt.normalize(point, fovRect);
        return ExtensionsKt.rotate(normalizedPoint, relativeRotation);
    }

    public final void onTap(@NotNull PointF point, @NotNull Rect fovRect, int fovRotationDegree) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)fovRect, (String)"fovRect");
        List points = CollectionsKt.listOf((Object)point);
        this.onTap(points, points, CollectionsKt.emptyList(), fovRect, fovRotationDegree);
    }

    public final void onTap(@NotNull List<? extends PointF> afPoints, @NotNull List<? extends PointF> aePoints, @NotNull List<? extends PointF> awbPoints, @NotNull Rect fovRect, int fovRotationDegree) {
        Collection<PointF> collection;
        Collection<PointF> collection2;
        PointF it;
        Collection collection3;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(afPoints, (String)"afPoints");
        Intrinsics.checkNotNullParameter(aePoints, (String)"aePoints");
        Intrinsics.checkNotNullParameter(awbPoints, (String)"awbPoints");
        Intrinsics.checkNotNullParameter((Object)fovRect, (String)"fovRect");
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            throw new IllegalStateException("Camera ID is null");
        }
        String cameraId2 = string2;
        int relativeRotation = this.getSensorRotationDegrees(this.context, cameraId2, fovRotationDegree);
        Iterable iterable = afPoints;
        FocusMetering focusMetering = this;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PointF pointF = (PointF)item$iv$iv;
            collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(this.normalizePoint(it, fovRect, relativeRotation));
        }
        $this$map$iv = aePoints;
        collection3 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PointF)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.normalizePoint(it, fovRect, relativeRotation));
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = awbPoints;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PointF)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.normalizePoint(it, fovRect, relativeRotation));
        }
        collection = (List)destination$iv$iv;
        focusMetering.startFocusAndMetering((List<? extends PointF>)collection3, (List<? extends PointF>)collection2, (List<? extends PointF>)collection, ContextExtensionsKt.isDevicePortrait(this.context) ? new Rational(fovRect.height(), fovRect.width()) : new Rational(fovRect.width(), fovRect.height()));
    }

    public static /* synthetic */ void onTap$default(FocusMetering focusMetering, List list, List list2, List list3, Rect rect, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        focusMetering.onTap(list, list2, list3, rect, n);
    }

    public final void cancelFocusAndMetering() {
        this.disableAutoCancel();
        this.cancelAfAeTrigger();
        this.cameraController.updateRepeatingSession();
    }

    private static final void startFocusAndMetering$lambda$2(FocusMetering this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cancelFocusAndMetering();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J<\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J \u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\tH\u0002J \u0010\"\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/github/thibaultbee/streampack/utils/FocusMetering$Companion;", "", "()V", "DEFAULT_AE_SIZE", "", "DEFAULT_AF_SIZE", "DEFAULT_AUTO_CANCEL_DURATION_MS", "", "DEFAULT_METERING_WEIGHT_MAX", "", "TAG", "", "getFovAdjustedPoint", "Landroid/graphics/PointF;", "point", "cropRegionAspectRatio", "Landroid/util/Rational;", "previewAspectRatio", "getMeteringRect", "Landroid/hardware/camera2/params/MeteringRectangle;", "size", "adjustedPoint", "cropRegion", "Landroid/graphics/Rect;", "getMeteringRectangles", "", "points", "maxNumOfRegions", "fovAspectRatio", "getPreferredAEMode", "context", "Landroid/content/Context;", "cameraId", "preferredMode", "getPreferredAFMode", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final int getPreferredAFMode(Context context, String cameraId2, int preferredMode) {
            List<Integer> supportedAFModes = ContextExtensionsForCameraKt.getAutoFocusModes(context, cameraId2);
            if (supportedAFModes.contains(preferredMode)) {
                return preferredMode;
            }
            if (supportedAFModes.contains(4)) {
                return 4;
            }
            if (supportedAFModes.contains(1)) {
                return 1;
            }
            return 0;
        }

        private final int getPreferredAEMode(Context context, String cameraId2, int preferredMode) {
            List<Integer> supportedAEModes = ContextExtensionsForCameraKt.getAutoExposureModes(context, cameraId2);
            if (supportedAEModes.isEmpty()) {
                return 0;
            }
            if (supportedAEModes.contains(preferredMode)) {
                return preferredMode;
            }
            if (supportedAEModes.contains(1)) {
                return 1;
            }
            return 0;
        }

        private final List<MeteringRectangle> getMeteringRectangles(List<? extends PointF> points, float size2, int maxNumOfRegions, Rect cropRegion, Rational fovAspectRatio) {
            if (maxNumOfRegions == 0) {
                return CollectionsKt.emptyList();
            }
            List meteringRectangles = new ArrayList();
            Rational cropRegionAspectRatio = new Rational(cropRegion.width(), cropRegion.height());
            for (PointF pointF : points) {
                if (meteringRectangles.size() >= maxNumOfRegions) break;
                if (!ExtensionsKt.isNormalized(pointF)) continue;
                PointF adjustedPoint = this.getFovAdjustedPoint(pointF, cropRegionAspectRatio, fovAspectRatio);
                MeteringRectangle meteringRectangle = this.getMeteringRect(size2, adjustedPoint, cropRegion);
                meteringRectangles.add(meteringRectangle);
            }
            return meteringRectangles;
        }

        private final PointF getFovAdjustedPoint(PointF point, Rational cropRegionAspectRatio, Rational previewAspectRatio) {
            if (!Intrinsics.areEqual((Object)previewAspectRatio, (Object)cropRegionAspectRatio)) {
                if (previewAspectRatio.compareTo(cropRegionAspectRatio) > 0) {
                    float heightOfCropRegion = (float)(previewAspectRatio.doubleValue() / cropRegionAspectRatio.doubleValue());
                    float topPadding = (float)(((double)heightOfCropRegion - 1.0) / (double)2);
                    point.y = (topPadding + point.y) * (1.0f / heightOfCropRegion);
                } else {
                    float widthOfCropRegion = (float)(cropRegionAspectRatio.doubleValue() / previewAspectRatio.doubleValue());
                    float leftPadding = (float)(((double)widthOfCropRegion - 1.0) / (double)2);
                    point.x = (leftPadding + point.x) * (1.0f / widthOfCropRegion);
                }
            }
            return point;
        }

        private final MeteringRectangle getMeteringRect(float size2, PointF adjustedPoint, Rect cropRegion) {
            int centerX = (int)((float)cropRegion.left + adjustedPoint.x * (float)cropRegion.width());
            int centerY = (int)((float)cropRegion.top + adjustedPoint.y * (float)cropRegion.height());
            float width = size2 * (float)cropRegion.width();
            float height = size2 * (float)cropRegion.height();
            Rect focusRect = new Rect((int)((float)centerX - width / (float)2), (int)((float)centerY - height / (float)2), (int)((float)centerX + width / (float)2), (int)((float)centerY + height / (float)2));
            focusRect.left = ((Number)((Object)ExtensionsKt.clamp(focusRect.left, cropRegion.right, cropRegion.left))).intValue();
            focusRect.right = ((Number)((Object)ExtensionsKt.clamp(focusRect.right, cropRegion.right, cropRegion.left))).intValue();
            focusRect.top = ((Number)((Object)ExtensionsKt.clamp(focusRect.top, cropRegion.bottom, cropRegion.top))).intValue();
            focusRect.bottom = ((Number)((Object)ExtensionsKt.clamp(focusRect.bottom, cropRegion.bottom, cropRegion.top))).intValue();
            return new MeteringRectangle(focusRect, 1000);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

