/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import android.util.Range;
import android.util.Rational;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.internal.utils.extensions.ExtensionsKt;
import io.github.thibaultbee.streampack.utils.ContextExtensionsForCameraKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u000b\"\u0004\b\u001c\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000bR0\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u0011\"\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lio/github/thibaultbee/streampack/utils/Exposure;", "", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;)V", "value", "", "autoMode", "getAutoMode", "()I", "setAutoMode", "(I)V", "availableAutoModes", "", "getAvailableAutoModes", "()Ljava/util/List;", "availableCompensationRange", "Landroid/util/Range;", "getAvailableCompensationRange", "()Landroid/util/Range;", "availableCompensationStep", "Landroid/util/Rational;", "getAvailableCompensationStep", "()Landroid/util/Rational;", "compensation", "getCompensation", "setCompensation", "maxNumOfMeteringRegions", "getMaxNumOfMeteringRegions", "Landroid/hardware/camera2/params/MeteringRectangle;", "meteringRegions", "getMeteringRegions", "setMeteringRegions", "(Ljava/util/List;)V", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nCameraSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraSettings.kt\nio/github/thibaultbee/streampack/utils/Exposure\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1049:1\n1#2:1050\n37#3,2:1051\n*S KotlinDebug\n*F\n+ 1 CameraSettings.kt\nio/github/thibaultbee/streampack/utils/Exposure\n*L\n332#1:1051,2\n*E\n"})
public final class Exposure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final CameraController cameraController;
    public static final int DEFAULT_COMPENSATION = 0;
    @NotNull
    private static final Range<Integer> DEFAULT_COMPENSATION_RANGE = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
    @NotNull
    private static final Rational DEFAULT_COMPENSATION_STEP_RATIONAL = new Rational(1, 1);

    public Exposure(@NotNull Context context, @NotNull CameraController cameraController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
        this.context = context;
        this.cameraController = cameraController;
    }

    @NotNull
    public final List<Integer> getAvailableAutoModes() {
        Object object;
        block3: {
            block2: {
                object = this.cameraController.getCameraId();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                List<Integer> list = ContextExtensionsForCameraKt.getAutoExposureModes(this.context, it);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final int getAutoMode() {
        Integer n = (Integer)this.cameraController.getSetting(CaptureRequest.CONTROL_AE_MODE);
        return n != null ? n : 0;
    }

    public final void setAutoMode(int value) {
        CaptureRequest.Key key = CaptureRequest.CONTROL_AE_MODE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AE_MODE");
        this.cameraController.setRepeatingSetting(key, value);
    }

    @NotNull
    public final Range<Integer> getAvailableCompensationRange() {
        Range<Integer> range;
        block3: {
            block2: {
                range = this.cameraController.getCameraId();
                if (range == null) break block2;
                Range<Integer> it = range;
                boolean bl = false;
                Range<Integer> range2 = ContextExtensionsForCameraKt.getExposureRange(this.context, it);
                range = range2;
                if (range2 != null) break block3;
            }
            range = DEFAULT_COMPENSATION_RANGE;
        }
        return range;
    }

    @NotNull
    public final Rational getAvailableCompensationStep() {
        String string2;
        block3: {
            block2: {
                string2 = this.cameraController.getCameraId();
                if (string2 == null) break block2;
                String it = string2;
                boolean bl = false;
                Rational rational = ContextExtensionsForCameraKt.getExposureStep(this.context, it);
                string2 = rational;
                if (rational != null) break block3;
            }
            string2 = DEFAULT_COMPENSATION_STEP_RATIONAL;
        }
        return string2;
    }

    public final int getCompensation() {
        Integer n = (Integer)this.cameraController.getSetting(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION);
        return n != null ? n : 0;
    }

    public final void setCompensation(int value) {
        CaptureRequest.Key key = CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AE_EXPOSURE_COMPENSATION");
        this.cameraController.setRepeatingSetting(key, ExtensionsKt.clamp(value, this.getAvailableCompensationRange()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getMaxNumOfMeteringRegions() {
        String string2 = this.cameraController.getCameraId();
        Object object = string2;
        if (string2 == null) return 0;
        String it = object;
        boolean bl = false;
        Integer n = ContextExtensionsForCameraKt.getExposureMaxMeteringRegionsSupported(this.context, it);
        object = n;
        if (n == null) return 0;
        int n2 = (Integer)object;
        return n2;
    }

    @NotNull
    public final List<MeteringRectangle> getMeteringRegions() {
        Object object = (MeteringRectangle[])this.cameraController.getSetting(CaptureRequest.CONTROL_AE_REGIONS);
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final void setMeteringRegions(@NotNull List<MeteringRectangle> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        CaptureRequest.Key key = CaptureRequest.CONTROL_AE_REGIONS;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AE_REGIONS");
        Collection $this$toTypedArray$iv = value;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.cameraController.setRepeatingSetting(key, thisCollection$iv.toArray(new MeteringRectangle[0]));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/github/thibaultbee/streampack/utils/Exposure$Companion;", "", "()V", "DEFAULT_COMPENSATION", "", "DEFAULT_COMPENSATION_RANGE", "Landroid/util/Range;", "kotlin.jvm.PlatformType", "getDEFAULT_COMPENSATION_RANGE", "()Landroid/util/Range;", "DEFAULT_COMPENSATION_STEP_RATIONAL", "Landroid/util/Rational;", "getDEFAULT_COMPENSATION_STEP_RATIONAL", "()Landroid/util/Rational;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Range<Integer> getDEFAULT_COMPENSATION_RANGE() {
            return DEFAULT_COMPENSATION_RANGE;
        }

        @NotNull
        public final Rational getDEFAULT_COMPENSATION_STEP_RATIONAL() {
            return DEFAULT_COMPENSATION_STEP_RATIONAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

