/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.video.vpx;

import android.media.MediaFormat;
import android.os.Build;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.av.video.DynamicRangeProfile;
import io.github.thibaultbee.streampack.internal.utils.av.video.vpx.ChromaSubsampling;
import io.github.thibaultbee.streampack.internal.utils.av.video.vpx.ColorPrimaries;
import io.github.thibaultbee.streampack.internal.utils.av.video.vpx.Level;
import io.github.thibaultbee.streampack.internal.utils.av.video.vpx.MatrixCoefficients;
import io.github.thibaultbee.streampack.internal.utils.av.video.vpx.Profile;
import io.github.thibaultbee.streampack.internal.utils.av.video.vpx.TransferCharacteristics;
import io.github.thibaultbee.streampack.internal.utils.extensions.BitOperationExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\t\u0010\u0019\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c2\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c2\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c2\u0003J\t\u0010\u001e\u001a\u00020\rH\u00c2\u0003J\t\u0010\u001f\u001a\u00020\u000fH\u00c2\u0003J\t\u0010 \u001a\u00020\u0011H\u00c2\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0013H\u00c2\u0003Je\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00c6\u0001J\u0013\u0010#\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020\u0016H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/VPCodecConfigurationRecord;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "profile", "Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/Profile;", "level", "Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/Level;", "bitDepth", "", "chromaSubsampling", "Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/ChromaSubsampling;", "videoFullRangeFlag", "", "colorPrimaries", "Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/ColorPrimaries;", "transferCharacteristics", "Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/TransferCharacteristics;", "matrixCoefficients", "Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/MatrixCoefficients;", "codecInitializationData", "Ljava/nio/ByteBuffer;", "(Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/Profile;Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/Level;BLio/github/thibaultbee/streampack/internal/utils/av/video/vpx/ChromaSubsampling;ZLio/github/thibaultbee/streampack/internal/utils/av/video/vpx/ColorPrimaries;Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/TransferCharacteristics;Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/MatrixCoefficients;Ljava/nio/ByteBuffer;)V", "size", "", "getSize", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "toString", "", "write", "", "output", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nVPCodecConfigurationRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VPCodecConfigurationRecord.kt\nio/github/thibaultbee/streampack/internal/utils/av/video/vpx/VPCodecConfigurationRecord\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public final class VPCodecConfigurationRecord
extends ByteBufferWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Profile profile;
    @NotNull
    private final Level level;
    private final byte bitDepth;
    @NotNull
    private final ChromaSubsampling chromaSubsampling;
    private final boolean videoFullRangeFlag;
    @NotNull
    private final ColorPrimaries colorPrimaries;
    @NotNull
    private final TransferCharacteristics transferCharacteristics;
    @NotNull
    private final MatrixCoefficients matrixCoefficients;
    @Nullable
    private final ByteBuffer codecInitializationData;
    private final int size;
    @NotNull
    private static final String TAG = "VPCodecConfigurationRecord";
    private static final int VP_DECODER_CONFIGURATION_RECORD_SIZE = 8;

    public VPCodecConfigurationRecord(@NotNull Profile profile, @NotNull Level level, byte bitDepth, @NotNull ChromaSubsampling chromaSubsampling, boolean videoFullRangeFlag, @NotNull ColorPrimaries colorPrimaries, @NotNull TransferCharacteristics transferCharacteristics, @NotNull MatrixCoefficients matrixCoefficients, @Nullable ByteBuffer codecInitializationData) {
        Intrinsics.checkNotNullParameter((Object)((Object)profile), (String)"profile");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)((Object)chromaSubsampling), (String)"chromaSubsampling");
        Intrinsics.checkNotNullParameter((Object)((Object)colorPrimaries), (String)"colorPrimaries");
        Intrinsics.checkNotNullParameter((Object)((Object)transferCharacteristics), (String)"transferCharacteristics");
        Intrinsics.checkNotNullParameter((Object)((Object)matrixCoefficients), (String)"matrixCoefficients");
        this.profile = profile;
        this.level = level;
        this.bitDepth = bitDepth;
        this.chromaSubsampling = chromaSubsampling;
        this.videoFullRangeFlag = videoFullRangeFlag;
        this.colorPrimaries = colorPrimaries;
        this.transferCharacteristics = transferCharacteristics;
        this.matrixCoefficients = matrixCoefficients;
        this.codecInitializationData = codecInitializationData;
        ByteBuffer byteBuffer = this.codecInitializationData;
        this.size = Companion.getSize() + (byteBuffer != null ? byteBuffer.remaining() : 0);
        if (this.matrixCoefficients == MatrixCoefficients.IDENTITY && !(this.chromaSubsampling == ChromaSubsampling.YUV444)) {
            boolean bl = false;
            String string2 = "If matrixCoefficients is 0 (RGB), then chroma subsampling MUST be 3 (4:4:4).";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ VPCodecConfigurationRecord(Profile profile, Level level, byte by, ChromaSubsampling chromaSubsampling, boolean bl, ColorPrimaries colorPrimaries, TransferCharacteristics transferCharacteristics, MatrixCoefficients matrixCoefficients, ByteBuffer byteBuffer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            byteBuffer = null;
        }
        this(profile, level, by, chromaSubsampling, bl, colorPrimaries, transferCharacteristics, matrixCoefficients, byteBuffer);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ByteBufferExtensionsKt.put(output, this.profile.getValue());
        ByteBufferExtensionsKt.put(output, this.level.getValue());
        ByteBufferExtensionsKt.put(output, BitOperationExtensionsKt.shl(this.bitDepth, 3) | BitOperationExtensionsKt.shl(this.chromaSubsampling.getValue(), 1) | BitOperationExtensionsKt.toInt(this.videoFullRangeFlag));
        ByteBufferExtensionsKt.put(output, this.colorPrimaries.getValue());
        ByteBufferExtensionsKt.put(output, this.transferCharacteristics.getValue());
        ByteBufferExtensionsKt.put(output, this.matrixCoefficients.getValue());
        if (this.codecInitializationData == null) {
            output.putShort((short)0);
        } else {
            ByteBufferExtensionsKt.putShort(output, this.codecInitializationData.remaining());
            output.put(this.codecInitializationData);
        }
    }

    private final Profile component1() {
        return this.profile;
    }

    private final Level component2() {
        return this.level;
    }

    private final byte component3() {
        return this.bitDepth;
    }

    private final ChromaSubsampling component4() {
        return this.chromaSubsampling;
    }

    private final boolean component5() {
        return this.videoFullRangeFlag;
    }

    private final ColorPrimaries component6() {
        return this.colorPrimaries;
    }

    private final TransferCharacteristics component7() {
        return this.transferCharacteristics;
    }

    private final MatrixCoefficients component8() {
        return this.matrixCoefficients;
    }

    private final ByteBuffer component9() {
        return this.codecInitializationData;
    }

    @NotNull
    public final VPCodecConfigurationRecord copy(@NotNull Profile profile, @NotNull Level level, byte bitDepth, @NotNull ChromaSubsampling chromaSubsampling, boolean videoFullRangeFlag, @NotNull ColorPrimaries colorPrimaries, @NotNull TransferCharacteristics transferCharacteristics, @NotNull MatrixCoefficients matrixCoefficients, @Nullable ByteBuffer codecInitializationData) {
        Intrinsics.checkNotNullParameter((Object)((Object)profile), (String)"profile");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)((Object)chromaSubsampling), (String)"chromaSubsampling");
        Intrinsics.checkNotNullParameter((Object)((Object)colorPrimaries), (String)"colorPrimaries");
        Intrinsics.checkNotNullParameter((Object)((Object)transferCharacteristics), (String)"transferCharacteristics");
        Intrinsics.checkNotNullParameter((Object)((Object)matrixCoefficients), (String)"matrixCoefficients");
        return new VPCodecConfigurationRecord(profile, level, bitDepth, chromaSubsampling, videoFullRangeFlag, colorPrimaries, transferCharacteristics, matrixCoefficients, codecInitializationData);
    }

    public static /* synthetic */ VPCodecConfigurationRecord copy$default(VPCodecConfigurationRecord vPCodecConfigurationRecord, Profile profile, Level level, byte by, ChromaSubsampling chromaSubsampling, boolean bl, ColorPrimaries colorPrimaries, TransferCharacteristics transferCharacteristics, MatrixCoefficients matrixCoefficients, ByteBuffer byteBuffer, int n, Object object) {
        if ((n & 1) != 0) {
            profile = vPCodecConfigurationRecord.profile;
        }
        if ((n & 2) != 0) {
            level = vPCodecConfigurationRecord.level;
        }
        if ((n & 4) != 0) {
            by = vPCodecConfigurationRecord.bitDepth;
        }
        if ((n & 8) != 0) {
            chromaSubsampling = vPCodecConfigurationRecord.chromaSubsampling;
        }
        if ((n & 0x10) != 0) {
            bl = vPCodecConfigurationRecord.videoFullRangeFlag;
        }
        if ((n & 0x20) != 0) {
            colorPrimaries = vPCodecConfigurationRecord.colorPrimaries;
        }
        if ((n & 0x40) != 0) {
            transferCharacteristics = vPCodecConfigurationRecord.transferCharacteristics;
        }
        if ((n & 0x80) != 0) {
            matrixCoefficients = vPCodecConfigurationRecord.matrixCoefficients;
        }
        if ((n & 0x100) != 0) {
            byteBuffer = vPCodecConfigurationRecord.codecInitializationData;
        }
        return vPCodecConfigurationRecord.copy(profile, level, by, chromaSubsampling, bl, colorPrimaries, transferCharacteristics, matrixCoefficients, byteBuffer);
    }

    @NotNull
    public String toString() {
        return "VPCodecConfigurationRecord(profile=" + (Object)((Object)this.profile) + ", level=" + (Object)((Object)this.level) + ", bitDepth=" + this.bitDepth + ", chromaSubsampling=" + (Object)((Object)this.chromaSubsampling) + ", videoFullRangeFlag=" + this.videoFullRangeFlag + ", colorPrimaries=" + (Object)((Object)this.colorPrimaries) + ", transferCharacteristics=" + (Object)((Object)this.transferCharacteristics) + ", matrixCoefficients=" + (Object)((Object)this.matrixCoefficients) + ", codecInitializationData=" + this.codecInitializationData + ')';
    }

    public int hashCode() {
        int result = this.profile.hashCode();
        result = result * 31 + this.level.hashCode();
        result = result * 31 + Byte.hashCode(this.bitDepth);
        result = result * 31 + this.chromaSubsampling.hashCode();
        result = result * 31 + Boolean.hashCode(this.videoFullRangeFlag);
        result = result * 31 + this.colorPrimaries.hashCode();
        result = result * 31 + this.transferCharacteristics.hashCode();
        result = result * 31 + this.matrixCoefficients.hashCode();
        result = result * 31 + (this.codecInitializationData == null ? 0 : this.codecInitializationData.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VPCodecConfigurationRecord)) {
            return false;
        }
        VPCodecConfigurationRecord vPCodecConfigurationRecord = (VPCodecConfigurationRecord)other;
        if (this.profile != vPCodecConfigurationRecord.profile) {
            return false;
        }
        if (this.level != vPCodecConfigurationRecord.level) {
            return false;
        }
        if (this.bitDepth != vPCodecConfigurationRecord.bitDepth) {
            return false;
        }
        if (this.chromaSubsampling != vPCodecConfigurationRecord.chromaSubsampling) {
            return false;
        }
        if (this.videoFullRangeFlag != vPCodecConfigurationRecord.videoFullRangeFlag) {
            return false;
        }
        if (this.colorPrimaries != vPCodecConfigurationRecord.colorPrimaries) {
            return false;
        }
        if (this.transferCharacteristics != vPCodecConfigurationRecord.transferCharacteristics) {
            return false;
        }
        if (this.matrixCoefficients != vPCodecConfigurationRecord.matrixCoefficients) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.codecInitializationData, (Object)vPCodecConfigurationRecord.codecInitializationData);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/VPCodecConfigurationRecord$Companion;", "", "()V", "TAG", "", "VP_DECODER_CONFIGURATION_RECORD_SIZE", "", "fromMediaFormat", "Lio/github/thibaultbee/streampack/internal/utils/av/video/vpx/VPCodecConfigurationRecord;", "format", "Landroid/media/MediaFormat;", "getSize", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VPCodecConfigurationRecord fromMediaFormat(@NotNull MediaFormat format) {
            int colorRange;
            ChromaSubsampling chromaSubsampling;
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            int rawProfile = format.getInteger("profile");
            Profile profile = Profile.Companion.fromMediaFormat(rawProfile);
            Level level = Build.VERSION.SDK_INT >= 23 ? Level.Companion.fromMediaFormat(format.getInteger("level")) : Level.UNDEFINED;
            String string2 = format.getString("mime");
            Intrinsics.checkNotNull((Object)string2);
            String mimeType = string2;
            int bitDepth = DynamicRangeProfile.Companion.fromProfile(mimeType, rawProfile).isHdr() ? 10 : 8;
            try {
                chromaSubsampling = ChromaSubsampling.Companion.fromValue((byte)format.getInteger("color-format"));
            }
            catch (Exception e) {
                ILogger.DefaultImpls.e$default(Logger.INSTANCE, VPCodecConfigurationRecord.TAG, "Missing KEY_COLOR_FORMAT in MediaFormat", null, 4, null);
                chromaSubsampling = ChromaSubsampling.YUV420_VERTICAL;
            }
            ChromaSubsampling chromaSubsampling2 = chromaSubsampling;
            int n = colorRange = Build.VERSION.SDK_INT >= 24 ? format.getInteger("color-range") : 0;
            boolean videoFullRangeFlag = Build.VERSION.SDK_INT >= 24 ? colorRange == 1 : false;
            Integer colorStandard = Build.VERSION.SDK_INT >= 24 ? Integer.valueOf(format.getInteger("color-standard")) : null;
            ColorPrimaries colorPrimaries = colorStandard != null ? ColorPrimaries.Companion.fromColorStandard(colorStandard) : ColorPrimaries.UNSPECIFIED;
            TransferCharacteristics transferCharacteristics = Build.VERSION.SDK_INT >= 24 ? TransferCharacteristics.Companion.fromColorTransfer(format.getInteger("color-transfer")) : TransferCharacteristics.UNSPECIFIED;
            MatrixCoefficients matrixCoefficients = colorStandard != null ? MatrixCoefficients.Companion.fromColorStandard(colorStandard) : MatrixCoefficients.UNSPECIFIED;
            return new VPCodecConfigurationRecord(profile, level, (byte)bitDepth, chromaSubsampling2, videoFullRangeFlag, colorPrimaries, transferCharacteristics, matrixCoefficients, null);
        }

        public final int getSize() {
            int size2 = 8;
            return size2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

