/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.descriptors;

import io.github.thibaultbee.streampack.internal.utils.av.descriptors.BaseDescriptor;
import io.github.thibaultbee.streampack.internal.utils.av.descriptors.DecoderSpecificInfo;
import io.github.thibaultbee.streampack.internal.utils.av.descriptors.ObjectTypeIndication;
import io.github.thibaultbee.streampack.internal.utils.av.descriptors.StreamType;
import io.github.thibaultbee.streampack.internal.utils.av.descriptors.Tags;
import io.github.thibaultbee.streampack.internal.utils.extensions.BitOperationExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/descriptors/DecoderConfigDescriptor;", "Lio/github/thibaultbee/streampack/internal/utils/av/descriptors/BaseDescriptor;", "objectTypeIndication", "Lio/github/thibaultbee/streampack/internal/utils/av/descriptors/ObjectTypeIndication;", "streamType", "Lio/github/thibaultbee/streampack/internal/utils/av/descriptors/StreamType;", "upStream", "", "bufferSize", "", "maxBitrate", "avgBitrate", "decoderSpecificInfo", "Lio/github/thibaultbee/streampack/internal/utils/av/descriptors/DecoderSpecificInfo;", "(Lio/github/thibaultbee/streampack/internal/utils/av/descriptors/ObjectTypeIndication;Lio/github/thibaultbee/streampack/internal/utils/av/descriptors/StreamType;ZIIILio/github/thibaultbee/streampack/internal/utils/av/descriptors/DecoderSpecificInfo;)V", "write", "", "output", "Ljava/nio/ByteBuffer;", "core_release"})
public class DecoderConfigDescriptor
extends BaseDescriptor {
    @NotNull
    private final ObjectTypeIndication objectTypeIndication;
    @NotNull
    private final StreamType streamType;
    private final boolean upStream;
    private final int bufferSize;
    private final int maxBitrate;
    private final int avgBitrate;
    @NotNull
    private final DecoderSpecificInfo decoderSpecificInfo;

    public DecoderConfigDescriptor(@NotNull ObjectTypeIndication objectTypeIndication, @NotNull StreamType streamType, boolean upStream, int bufferSize, int maxBitrate, int avgBitrate, @NotNull DecoderSpecificInfo decoderSpecificInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)objectTypeIndication), (String)"objectTypeIndication");
        Intrinsics.checkNotNullParameter((Object)((Object)streamType), (String)"streamType");
        Intrinsics.checkNotNullParameter((Object)decoderSpecificInfo, (String)"decoderSpecificInfo");
        super(Tags.DecoderConfigDescr, 13 + decoderSpecificInfo.getSize());
        this.objectTypeIndication = objectTypeIndication;
        this.streamType = streamType;
        this.upStream = upStream;
        this.bufferSize = bufferSize;
        this.maxBitrate = maxBitrate;
        this.avgBitrate = avgBitrate;
        this.decoderSpecificInfo = decoderSpecificInfo;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        output.put(this.objectTypeIndication.getValue());
        ByteBufferExtensionsKt.put(output, BitOperationExtensionsKt.shl(this.streamType.getValue(), 2) | BitOperationExtensionsKt.shl(this.upStream, 1) | 1);
        ByteBufferExtensionsKt.putInt24(output, this.bufferSize);
        output.putInt(this.maxBitrate);
        output.putInt(this.avgBitrate);
        this.decoderSpecificInfo.write(output);
    }
}

