/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.audio.aac;

import io.github.thibaultbee.streampack.internal.utils.av.audio.aac.StreamMuxConfig;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.BitBuffer;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.BitBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0016R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "muxConfigPresent", "", "useSameStreamMuxConfig", "streamMuxConfig", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/StreamMuxConfig;", "payload", "Ljava/nio/ByteBuffer;", "(ZZLio/github/thibaultbee/streampack/internal/utils/av/audio/aac/StreamMuxConfig;Ljava/nio/ByteBuffer;)V", "bitSize", "", "getBitSize", "()I", "getMuxConfigPresent", "()Z", "payloadLengthInfo", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement$PayloadLengthInfo;", "payloadMux", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement$PayloadMux;", "size", "getSize", "getUseSameStreamMuxConfig", "setUseSameStreamMuxConfig", "(Z)V", "write", "", "output", "Companion", "PayloadLengthInfo", "PayloadMux", "core_release"})
@SourceDebugExtension(value={"SMAP\nAudioMuxElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioMuxElement.kt\nio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1#2:274\n*E\n"})
public final class AudioMuxElement
extends ByteBufferWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean muxConfigPresent;
    private boolean useSameStreamMuxConfig;
    @Nullable
    private final StreamMuxConfig streamMuxConfig;
    @Nullable
    private final ByteBuffer payload;
    @NotNull
    private final PayloadLengthInfo payloadLengthInfo;
    @NotNull
    private final PayloadMux payloadMux;
    private final int size;

    public AudioMuxElement(boolean muxConfigPresent, boolean useSameStreamMuxConfig, @Nullable StreamMuxConfig streamMuxConfig, @Nullable ByteBuffer payload) {
        this.muxConfigPresent = muxConfigPresent;
        this.useSameStreamMuxConfig = useSameStreamMuxConfig;
        this.streamMuxConfig = streamMuxConfig;
        this.payload = payload;
        this.payloadLengthInfo = new PayloadLengthInfo();
        this.payloadMux = new PayloadMux();
        this.size = (this.getBitSize() + 8 - 1) / 8;
        if (this.muxConfigPresent && this.useSameStreamMuxConfig && this.streamMuxConfig == null) {
            boolean bl = false;
            String string2 = "streamMuxConfig must not be null";
            throw new IllegalArgumentException(string2.toString());
        }
        StreamMuxConfig streamMuxConfig2 = this.streamMuxConfig;
        boolean bl = streamMuxConfig2 != null ? streamMuxConfig2.getAudioMuxVersionA() == 0 : false;
        if (bl) {
            if (this.payload == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
        }
    }

    public /* synthetic */ AudioMuxElement(boolean bl, boolean bl2, StreamMuxConfig streamMuxConfig, ByteBuffer byteBuffer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            streamMuxConfig = null;
        }
        if ((n & 8) != 0) {
            byteBuffer = null;
        }
        this(bl, bl2, streamMuxConfig, byteBuffer);
    }

    public final boolean getMuxConfigPresent() {
        return this.muxConfigPresent;
    }

    public final boolean getUseSameStreamMuxConfig() {
        return this.useSameStreamMuxConfig;
    }

    public final void setUseSameStreamMuxConfig(boolean bl) {
        this.useSameStreamMuxConfig = bl;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private final int getBitSize() {
        int n;
        if (!this.useSameStreamMuxConfig) {
            StreamMuxConfig streamMuxConfig = this.streamMuxConfig;
            Intrinsics.checkNotNull((Object)streamMuxConfig);
            n = streamMuxConfig.getBitSize();
        } else {
            n = 0;
        }
        return 1 + n + this.payloadLengthInfo.getBitSize() + this.payloadMux.getBitSize();
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        BitBuffer writer = new BitBuffer(output, 0, 0, 6, null);
        if (this.muxConfigPresent) {
            writer.put(this.useSameStreamMuxConfig);
            if (!this.useSameStreamMuxConfig) {
                StreamMuxConfig streamMuxConfig = this.streamMuxConfig;
                Intrinsics.checkNotNull((Object)streamMuxConfig);
                streamMuxConfig.write(writer);
            }
        }
        StreamMuxConfig streamMuxConfig = this.streamMuxConfig;
        boolean bl = streamMuxConfig != null ? streamMuxConfig.getAudioMuxVersionA() == 0 : false;
        if (bl) {
            this.payloadLengthInfo.write(writer);
            this.payloadMux.write(writer);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement$Companion;", "", "()V", "fromDecoderSpecificInfo", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement;", "payload", "Ljava/nio/ByteBuffer;", "decoderSpecificInfo", "parse", "buffer", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AudioMuxElement parse(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            BitBuffer reader = new BitBuffer(buffer, 0, 0, 6, null);
            boolean useSameStreamMuxConfig = reader.getBoolean();
            StreamMuxConfig streamMuxConfig = null;
            if (!useSameStreamMuxConfig) {
                streamMuxConfig = StreamMuxConfig.Companion.parse(reader);
            }
            Object payloadLengthInfo = null;
            ByteBuffer payload = null;
            StreamMuxConfig streamMuxConfig2 = streamMuxConfig;
            boolean bl = streamMuxConfig2 != null ? streamMuxConfig2.getAudioMuxVersionA() == 0 : false;
            if (bl) {
                throw new NotImplementedError("Not implemented yet");
            }
            return new AudioMuxElement(true, useSameStreamMuxConfig, streamMuxConfig, payload);
        }

        @NotNull
        public final AudioMuxElement fromDecoderSpecificInfo(@NotNull ByteBuffer payload, @NotNull ByteBuffer decoderSpecificInfo) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)decoderSpecificInfo, (String)"decoderSpecificInfo");
            return new AudioMuxElement(true, false, StreamMuxConfig.Companion.fromDecoderSpecificInfo(decoderSpecificInfo), payload);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement$PayloadLengthInfo;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBufferWriter;", "(Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement;)V", "bitSize", "", "getBitSize", "()I", "payloadSize", "write", "", "output", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBuffer;", "core_release"})
    private final class PayloadLengthInfo
    extends BitBufferWriter {
        private final int payloadSize;
        private final int bitSize;

        public PayloadLengthInfo() {
            ByteBuffer byteBuffer = AudioMuxElement.this.payload;
            Intrinsics.checkNotNull((Object)byteBuffer);
            this.payloadSize = byteBuffer.remaining();
            this.bitSize = (this.payloadSize / 255 + 1) * 8;
        }

        @Override
        public int getBitSize() {
            return this.bitSize;
        }

        @Override
        public void write(@NotNull BitBuffer output) {
            int remainingPayloadLength;
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            StreamMuxConfig streamMuxConfig = AudioMuxElement.this.streamMuxConfig;
            Intrinsics.checkNotNull((Object)streamMuxConfig);
            if (Intrinsics.areEqual((Object)streamMuxConfig.getAllStreamsSameTimeFraming(), (Object)true)) {
                remainingPayloadLength = this.payloadSize;
                int i = 0;
                int n = this.payloadSize - 255;
                int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)255);
                if (i <= n2) {
                    while (true) {
                        output.put(255, 8);
                        remainingPayloadLength -= 255;
                        if (i == n2) break;
                        i += 255;
                    }
                }
            } else {
                throw new NotImplementedError("Not implemented yet");
            }
            output.put(remainingPayloadLength, 8);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement$PayloadMux;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBufferWriter;", "(Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement;)V", "bitSize", "", "getBitSize", "()I", "write", "", "output", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBuffer;", "core_release"})
    private final class PayloadMux
    extends BitBufferWriter {
        private final int bitSize;

        public PayloadMux() {
            ByteBuffer byteBuffer = AudioMuxElement.this.payload;
            Intrinsics.checkNotNull((Object)byteBuffer);
            this.bitSize = byteBuffer.remaining() * 8;
        }

        @Override
        public int getBitSize() {
            return this.bitSize;
        }

        @Override
        public void write(@NotNull BitBuffer output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            ByteBuffer byteBuffer = AudioMuxElement.this.payload;
            Intrinsics.checkNotNull((Object)byteBuffer);
            output.put(byteBuffer);
        }
    }
}

