/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.ts;

import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.muxers.IMuxer;
import io.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import io.github.thibaultbee.streampack.internal.muxers.ts.TSMuxerHelper;
import io.github.thibaultbee.streampack.internal.muxers.ts.data.Service;
import io.github.thibaultbee.streampack.internal.muxers.ts.data.Stream;
import io.github.thibaultbee.streampack.internal.muxers.ts.data.TsServiceInfo;
import io.github.thibaultbee.streampack.internal.muxers.ts.packets.Pat;
import io.github.thibaultbee.streampack.internal.muxers.ts.packets.Pes;
import io.github.thibaultbee.streampack.internal.muxers.ts.packets.Pmt;
import io.github.thibaultbee.streampack.internal.muxers.ts.packets.Psi;
import io.github.thibaultbee.streampack.internal.muxers.ts.packets.Sdt;
import io.github.thibaultbee.streampack.internal.muxers.ts.utils.TSOutputCallback;
import io.github.thibaultbee.streampack.internal.orientation.ISourceOrientationProvider;
import io.github.thibaultbee.streampack.internal.utils.av.audio.aac.ADTSFrameWriter;
import io.github.thibaultbee.streampack.internal.utils.av.audio.aac.LATMFrameWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B/\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0005J*\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020$2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J(\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010'\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\"\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020*0)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020*H\u0016J\u0018\u00101\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\u0006\u00102\u001a\u00020\"H\u0002J\b\u00103\u001a\u00020\u001fH\u0002J\u0010\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\u001fH\u0002J\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u0010\u00106\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00105\u001a\u00020\u001fH\u0002J\u0014\u00109\u001a\b\u0012\u0004\u0012\u0002080\u00072\u0006\u0010:\u001a\u00020;J\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00072\u0006\u0010:\u001a\u00020;J\b\u0010=\u001a\u00020&H\u0016J\u0010\u0010>\u001a\u00020&2\u0006\u0010+\u001a\u00020$H\u0002J\u000e\u0010>\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0005J\u0010\u0010?\u001a\u00020&2\u0006\u0010+\u001a\u00020$H\u0002J\u001e\u0010?\u001a\u00020&2\u0006\u0010+\u001a\u00020$2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002080\u0007H\u0002J\u001c\u0010?\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0007J\u0010\u0010B\u001a\u00020&2\u0006\u0010C\u001a\u00020DH\u0002J\b\u0010E\u001a\u00020&H\u0002J\u0010\u0010F\u001a\u00020&2\u0006\u0010+\u001a\u00020$H\u0002J\b\u0010G\u001a\u00020&H\u0002J\b\u0010H\u001a\u00020&H\u0002J\b\u0010I\u001a\u00020&H\u0016J\b\u0010J\u001a\u00020&H\u0016J\b\u0010K\u001a\u00020&H\u0002J\b\u0010L\u001a\u00020&H\u0002R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR(\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/TSMuxer;", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxer;", "initialListener", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "initialTsServiceInfo", "Lio/github/thibaultbee/streampack/internal/muxers/ts/data/TsServiceInfo;", "initialStreams", "", "Lio/github/thibaultbee/streampack/data/Config;", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;Lio/github/thibaultbee/streampack/internal/muxers/ts/data/TsServiceInfo;Ljava/util/List;)V", "helper", "Lio/github/thibaultbee/streampack/internal/muxers/ts/TSMuxerHelper;", "getHelper", "()Lio/github/thibaultbee/streampack/internal/muxers/ts/TSMuxerHelper;", "value", "listener", "getListener", "()Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "setListener", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;)V", "pat", "Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Pat;", "sdt", "Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Sdt;", "sourceOrientationProvider", "Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "getSourceOrientationProvider", "()Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "setSourceOrientationProvider", "(Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;)V", "tsId", "", "tsPes", "", "Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Pes;", "tsServices", "Lio/github/thibaultbee/streampack/internal/muxers/ts/data/Service;", "addService", "", "tsServiceInfo", "addStreams", "", "", "service", "streamsConfig", "encode", "frame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "streamPid", "generateStreams", "pes", "getNewPid", "getPes", "pid", "getServices", "getStream", "Lio/github/thibaultbee/streampack/internal/muxers/ts/data/Stream;", "getStreams", "mimeType", "", "getStreamsId", "release", "removeService", "removeStreams", "streams", "streamsPid", "retransmitPsi", "forcePat", "", "sendPat", "sendPmt", "sendPmts", "sendSdt", "startStream", "stopStream", "upgradePat", "upgradeSdt", "core_release"})
@SourceDebugExtension(value={"SMAP\nTSMuxer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TSMuxer.kt\nio/github/thibaultbee/streampack/internal/muxers/ts/TSMuxer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,463:1\n1#2:464\n1855#3,2:465\n1855#3,2:467\n1855#3,2:469\n1855#3,2:471\n766#3:473\n857#3,2:474\n1855#3,2:476\n1549#3:478\n1620#3,3:479\n2624#3,3:482\n1855#3,2:485\n223#3,2:487\n1855#3,2:489\n1855#3,2:491\n1549#3:493\n1620#3,3:494\n1855#3,2:497\n1855#3,2:499\n1855#3,2:501\n1360#3:503\n1446#3,5:504\n1549#3:509\n1620#3,3:510\n766#3:513\n857#3,2:514\n1549#3:516\n1620#3,3:517\n223#3,2:520\n1549#3:522\n1620#3,3:523\n1360#3:526\n1446#3,5:527\n766#3:532\n857#3,2:533\n1360#3:535\n1446#3,5:536\n223#3,2:541\n223#3,2:543\n*S KotlinDebug\n*F\n+ 1 TSMuxer.kt\nio/github/thibaultbee/streampack/internal/muxers/ts/TSMuxer\n*L\n54#1:465,2\n55#1:467,2\n105#1:469,2\n129#1:471,2\n217#1:473\n217#1:474,2\n217#1:476,2\n236#1:478\n236#1:479,3\n244#1:482,3\n303#1:485,2\n310#1:487,2\n322#1:489,2\n338#1:491,2\n349#1:493\n349#1:494,3\n358#1:497,2\n377#1:499,2\n391#1:501,2\n406#1:503\n406#1:504,5\n406#1:509\n406#1:510,3\n406#1:513\n406#1:514,2\n407#1:516\n407#1:517,3\n424#1:520,2\n433#1:522\n433#1:523,3\n442#1:526\n442#1:527,5\n442#1:532\n442#1:533,2\n451#1:535\n451#1:536,5\n451#1:541,2\n460#1:543,2\n*E\n"})
public final class TSMuxer
implements IMuxer {
    @NotNull
    private final TSMuxerHelper helper;
    @NotNull
    private final List<Service> tsServices;
    @NotNull
    private final List<Pes> tsPes;
    @Nullable
    private ISourceOrientationProvider sourceOrientationProvider;
    @Nullable
    private IMuxerListener listener;
    private final short tsId;
    @NotNull
    private Pat pat;
    @NotNull
    private Sdt sdt;

    public TSMuxer(@Nullable IMuxerListener initialListener, @Nullable TsServiceInfo initialTsServiceInfo, @Nullable List<? extends Config> initialStreams) {
        block2: {
            Object it;
            this.helper = new TSMuxerHelper();
            this.tsServices = new ArrayList();
            this.tsPes = new ArrayList();
            this.listener = initialListener;
            this.tsId = (short)Random.Default.nextInt(-128, 127);
            this.pat = new Pat(this.getListener(), this.tsServices, this.tsId, 0, 0, 8, null);
            this.sdt = new Sdt(this.getListener(), this.tsServices, this.tsId, 0, 0, 0, 24, null);
            if (initialStreams != null && !(initialTsServiceInfo != null)) {
                boolean $i$a$-require-TSMuxer$22 = false;
                String $i$a$-require-TSMuxer$22 = "If streams are specified, a service info must be specified too";
                throw new IllegalArgumentException($i$a$-require-TSMuxer$22.toString());
            }
            TsServiceInfo tsServiceInfo = initialTsServiceInfo;
            if (tsServiceInfo != null) {
                it = tsServiceInfo;
                boolean bl = false;
                this.addService((TsServiceInfo)it);
            }
            List<? extends Config> list = initialStreams;
            if (list == null) break block2;
            it = list;
            boolean bl = false;
            this.addStreams(this.tsServices.get(0), (List<? extends Config>)it);
        }
    }

    public /* synthetic */ TSMuxer(IMuxerListener iMuxerListener, TsServiceInfo tsServiceInfo, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iMuxerListener = null;
        }
        if ((n & 2) != 0) {
            tsServiceInfo = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        this(iMuxerListener, tsServiceInfo, list);
    }

    @Override
    @NotNull
    public TSMuxerHelper getHelper() {
        return this.helper;
    }

    @Override
    @Nullable
    public ISourceOrientationProvider getSourceOrientationProvider() {
        return this.sourceOrientationProvider;
    }

    @Override
    public void setSourceOrientationProvider(@Nullable ISourceOrientationProvider iSourceOrientationProvider) {
        this.sourceOrientationProvider = iSourceOrientationProvider;
    }

    @Override
    @Nullable
    public IMuxerListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(@Nullable IMuxerListener value) {
        Object it;
        this.pat.setListener(value);
        this.sdt.setListener(value);
        Iterable $this$forEach$iv = this.tsPes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pes)element$iv;
            boolean bl = false;
            ((TSOutputCallback)it).setListener(value);
        }
        $this$forEach$iv = this.tsServices;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Service)element$iv;
            boolean bl = false;
            Pmt pmt = ((Service)it).getPmt();
            if (pmt == null) continue;
            pmt.setListener(value);
        }
        this.listener = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(@NotNull Frame frame, int streamPid) {
        Frame frame2;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Pes pes = this.getPes((short)streamPid);
        switch (frame.getMimeType()) {
            case "video/avc": {
                int $i$f$forEach;
                Iterable $this$forEach$iv;
                ByteBuffer buffer;
                int n;
                ByteBuffer it;
                int n2;
                int n3;
                if (frame.isKeyFrame()) {
                    if (frame.getExtra() == null) {
                        throw new MissingFormatArgumentException("Missing extra for AVC");
                    }
                    Iterable iterable = frame.getExtra();
                    n3 = 6;
                    int n4 = 0;
                    for (Object t : iterable) {
                        ByteBuffer byteBuffer = (ByteBuffer)t;
                        n2 = n4;
                        boolean bl = false;
                        n = it.limit();
                        n4 = n2 + n;
                    }
                    n2 = n4;
                    buffer = ByteBuffer.allocate(n3 + n2 + frame.getBuffer().limit());
                    buffer.putInt(1);
                    buffer.put((byte)9);
                    buffer.put((byte)-16);
                    $this$forEach$iv = frame.getExtra();
                    $i$f$forEach = 0;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (ByteBuffer)element$iv;
                        boolean bl = false;
                        buffer.put(it);
                    }
                    buffer.put(frame.getBuffer());
                    buffer.rewind();
                    Intrinsics.checkNotNull((Object)buffer);
                    frame2 = Frame.copy$default(frame, buffer, 0L, null, false, null, 30, null);
                    break;
                }
                frame2 = frame;
                break;
            }
            case "video/hevc": {
                int $i$f$forEach;
                Iterable $this$forEach$iv;
                ByteBuffer buffer;
                int n;
                ByteBuffer it;
                int n2;
                int n3;
                if (frame.isKeyFrame()) {
                    if (frame.getExtra() == null) {
                        throw new MissingFormatArgumentException("Missing extra for HEVC");
                    }
                    $this$forEach$iv = frame.getExtra();
                    n3 = 7;
                    $i$f$forEach = 0;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (ByteBuffer)element$iv;
                        n2 = $i$f$forEach;
                        boolean bl = false;
                        n = it.limit();
                        $i$f$forEach = n2 + n;
                    }
                    n2 = $i$f$forEach;
                    buffer = ByteBuffer.allocate(n3 + n2 + frame.getBuffer().limit());
                    buffer.putInt(1);
                    buffer.put((byte)70);
                    buffer.put((byte)1);
                    buffer.put((byte)80);
                    $this$forEach$iv = frame.getExtra();
                    $i$f$forEach = 0;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (ByteBuffer)element$iv;
                        boolean bl = false;
                        buffer.put(it);
                    }
                    buffer.put(frame.getBuffer());
                    buffer.rewind();
                    Intrinsics.checkNotNull((Object)buffer);
                    frame2 = Frame.copy$default(frame, buffer, 0L, null, false, null, 30, null);
                    break;
                }
                frame2 = frame;
                break;
            }
            case "audio/mp4a-latm": {
                ByteBuffer byteBuffer;
                if (pes.getStream().getConfig().getProfile() == 2) {
                    ByteBuffer byteBuffer2 = frame.getBuffer();
                    Config config = pes.getStream().getConfig();
                    Intrinsics.checkNotNull((Object)config, (String)"null cannot be cast to non-null type io.github.thibaultbee.streampack.data.AudioConfig");
                    byteBuffer = ADTSFrameWriter.Companion.fromAudioConfig(byteBuffer2, (AudioConfig)config).toByteBuffer();
                } else {
                    ByteBuffer byteBuffer3 = frame.getBuffer();
                    List<ByteBuffer> list = frame.getExtra();
                    Intrinsics.checkNotNull(list);
                    byteBuffer = LATMFrameWriter.Companion.fromDecoderSpecificInfo(byteBuffer3, (ByteBuffer)CollectionsKt.first(list)).toByteBuffer();
                }
                frame2 = Frame.copy$default(frame, byteBuffer, 0L, null, false, null, 30, null);
                break;
            }
            case "audio/opus": {
                frame2 = frame;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported mimeType " + frame.getMimeType());
            }
        }
        Frame newFrame = frame2;
        Object object = this;
        synchronized (object) {
            boolean bl = false;
            this.generateStreams(newFrame, pes);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void generateStreams(Frame frame, Pes pes) {
        this.retransmitPsi(frame.isVideo() & frame.isKeyFrame());
        pes.write(frame);
    }

    private final void retransmitPsi(boolean forcePat) {
        boolean sendSdt = false;
        boolean sendPat = false;
        Psi psi = this.sdt;
        ((Sdt)psi).setPacketCount(((Sdt)psi).getPacketCount() + 1);
        if (this.sdt.getPacketCount() == 200) {
            this.sdt.setPacketCount(0);
            sendSdt = true;
        }
        psi = this.pat;
        ((Pat)psi).setPacketCount(((Pat)psi).getPacketCount() + 1);
        if (this.pat.getPacketCount() == 40 || forcePat) {
            this.pat.setPacketCount(0);
            sendPat = true;
        }
        if (sendSdt) {
            this.sendSdt();
        }
        if (sendPat) {
            this.sendPat();
            this.sendPmts();
        }
    }

    private final void upgradePat() {
        this.pat.setVersionNumber((byte)(this.pat.getVersionNumber() + 1));
        this.sendPat();
    }

    private final void sendPat() {
        this.pat.write();
    }

    private final void sendPmt(Service service) {
        Unit unit;
        Pmt pmt = service.getPmt();
        if (pmt != null) {
            pmt.write();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new UnsupportedOperationException("PMT must not be null");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendPmts() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.tsServices;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Service it = (Service)element$iv$iv;
            boolean bl = false;
            if (!(it.getPmt() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Unit unit;
            Service it = (Service)element$iv;
            boolean bl = false;
            Pmt pmt = it.getPmt();
            if (pmt != null) {
                pmt.write();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) continue;
            throw new UnsupportedOperationException("PMT must not be null");
        }
    }

    private final void upgradeSdt() {
        this.sdt.setVersionNumber((byte)(this.sdt.getVersionNumber() + 1));
        this.sendSdt();
    }

    private final void sendSdt() {
        this.sdt.write();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TsServiceInfo> getServices() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tsServices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Service service = (Service)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getInfo());
        }
        return (List)destination$iv$iv;
    }

    public final void addService(@NotNull TsServiceInfo tsServiceInfo) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)tsServiceInfo, (String)"tsServiceInfo");
            Iterable $this$none$iv = this.tsServices;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Service it = (Service)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getInfo(), (Object)tsServiceInfo)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string2 = "Service already exists";
            throw new IllegalArgumentException(string2.toString());
        }
        this.tsServices.add(new Service(tsServiceInfo, null, null, null, 14, null));
    }

    public final void removeService(@NotNull TsServiceInfo tsServiceInfo) {
        Intrinsics.checkNotNullParameter((Object)tsServiceInfo, (String)"tsServiceInfo");
        this.removeService(this.getServices(tsServiceInfo));
    }

    private final void removeService(Service service) {
        if (!this.tsServices.contains(service)) {
            boolean bl = false;
            String string2 = "Unknown service";
            throw new IllegalArgumentException(string2.toString());
        }
        this.tsServices.remove(service);
        if (!((Collection)service.getStreams()).isEmpty()) {
            this.removeStreams(service, service.getStreams());
        }
        this.upgradeSdt();
        this.upgradePat();
    }

    @Override
    @NotNull
    public Map<Config, Integer> addStreams(@NotNull List<? extends Config> streamsConfig) {
        Intrinsics.checkNotNullParameter(streamsConfig, (String)"streamsConfig");
        return this.addStreams(this.getServices().get(0), streamsConfig);
    }

    @NotNull
    public final Map<Config, Integer> addStreams(@NotNull TsServiceInfo tsServiceInfo, @NotNull List<? extends Config> streamsConfig) {
        Intrinsics.checkNotNullParameter((Object)tsServiceInfo, (String)"tsServiceInfo");
        Intrinsics.checkNotNullParameter(streamsConfig, (String)"streamsConfig");
        return this.addStreams(this.getServices(tsServiceInfo), streamsConfig);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Config, Integer> addStreams(Service service, List<? extends Config> streamsConfig) {
        Object object;
        Service service2;
        Iterator iterator;
        Short $this$first$iv;
        Object it;
        Object element$iv2;
        if (!this.tsServices.contains(service)) {
            boolean $i$a$-require-TSMuxer$addStreams$22 = false;
            String $i$a$-require-TSMuxer$addStreams$22 = "Unknown service";
            throw new IllegalArgumentException($i$a$-require-TSMuxer$addStreams$22.toString());
        }
        boolean isNewService = service.getPmt() == null;
        List newStreams = new ArrayList();
        Iterable $this$forEach$iv = streamsConfig;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            it = (Config)element$iv2;
            boolean bl = false;
            Stream stream = new Stream((Config)it, this.getNewPid(), false, 4, null);
            newStreams.add(stream);
            service.getStreams().add(stream);
        }
        Service service3 = service;
        try {
            Service service4;
            block10: {
                $this$forEach$iv = service.getStreams();
                service4 = service3;
                boolean $i$f$first = false;
                iterator = $this$first$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv2 = iterator.next();
                    it = (Stream)element$iv2;
                    boolean bl = false;
                    if (!((Stream)it).isVideo()) continue;
                    break block10;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            service2 = service4;
            $this$first$iv = ((Stream)element$iv2).getPid();
        }
        catch (NoSuchElementException $i$f$first) {
            service2 = service3;
            $this$first$iv = service.getStreams().get(0).getPid();
        }
        service2.setPcrPid($this$first$iv);
        Service service5 = service;
        Pmt pmt = service.getPmt();
        if (pmt != null) {
            void $this$addStreams_u24lambda_u2419;
            iterator = pmt;
            element$iv2 = iterator;
            service3 = service5;
            boolean bl = false;
            $this$addStreams_u24lambda_u2419.setVersionNumber((byte)($this$addStreams_u24lambda_u2419.getVersionNumber() + 1));
            $this$addStreams_u24lambda_u2419.setStreams(service.getStreams());
            service5 = service3;
            object = iterator;
        } else {
            object = new Pmt(this.getListener(), service, service.getStreams(), this.getNewPid(), 0, 16, null);
        }
        service5.setPmt((Pmt)object);
        $this$forEach$iv = newStreams;
        $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Stream it2 = (Stream)element$iv2;
            boolean bl = false;
            Short s = service.getPcrPid();
            Pes $this$addStreams_u24lambda_u2421_u24lambda_u2420 = new Pes(this.getListener(), it2, s != null ? s.shortValue() == it2.getPid() : false);
            boolean bl2 = false;
            this.tsPes.add($this$addStreams_u24lambda_u2421_u24lambda_u2420);
        }
        this.sendPmt(service);
        if (isNewService) {
            this.upgradeSdt();
            this.upgradePat();
        }
        Map streamMap = new LinkedHashMap();
        Iterable $this$forEach$iv2 = newStreams;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            Stream it3 = (Stream)element$iv3;
            boolean bl = false;
            streamMap.put(it3.getConfig(), Integer.valueOf(it3.getPid()));
        }
        return streamMap;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeStreams(@NotNull TsServiceInfo tsServiceInfo, @NotNull List<Short> streamsPid) {
        Collection<Stream> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)tsServiceInfo, (String)"tsServiceInfo");
        Intrinsics.checkNotNullParameter(streamsPid, (String)"streamsPid");
        Iterable iterable = streamsPid;
        Service service = this.getServices(tsServiceInfo);
        TSMuxer tSMuxer = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            short s = ((Number)item$iv$iv).shortValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getStream((short)it));
        }
        collection = (List)destination$iv$iv;
        tSMuxer.removeStreams(service, (List<Stream>)collection);
    }

    private final void removeStreams(Service service, List<Stream> streams) {
        Iterable $this$forEach$iv = streams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stream it = (Stream)element$iv;
            boolean bl = false;
            this.tsPes.remove(this.getPes(it.getPid()));
        }
        service.getStreams().removeAll((Collection)streams);
        Pmt pmt = service.getPmt();
        if (pmt != null) {
            Pmt it = pmt;
            boolean bl = false;
            it.setVersionNumber((byte)(it.getVersionNumber() + 1));
            it.setStreams(service.getStreams());
        }
        this.sendPmt(service);
    }

    private final void removeStreams(Service service) {
        Iterable $this$forEach$iv = service.getStreams();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stream it = (Stream)element$iv;
            boolean bl = false;
            this.tsPes.remove(this.getPes(it.getPid()));
        }
        service.getStreams().clear();
    }

    @Override
    public void startStream() {
    }

    @Override
    public void stopStream() {
        Iterable $this$forEach$iv = this.tsServices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Service it = (Service)element$iv;
            boolean bl = false;
            this.removeStreams(it);
        }
    }

    @Override
    public void release() {
        this.tsServices.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final short getNewPid() {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Service it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.tsServices;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Service)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getStreams();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Stream)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Stream)((Object)it)).getPid());
        }
        $this$map$iv = this.tsServices;
        collection = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Service)element$iv$iv;
            boolean bl = false;
            if (!(it.getPmt() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Service)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Pmt pmt = it.getPmt();
            collection2.add(pmt != null ? Short.valueOf(pmt.getPid()) : null);
        }
        List currentPids = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        for (int i = 32; i < 8186; ++i) {
            if (currentPids.contains((short)i)) continue;
            return (short)i;
        }
        throw new IndexOutOfBoundsException("No empty PID left");
    }

    private final Pes getPes(short pid) {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.tsPes;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Pes it = (Pes)element$iv2;
                boolean bl = false;
                if (!(it.getStream().getPid() == pid)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Pes)element$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Short> getStreamsId(@NotNull String mimeType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Iterable $this$map$iv = this.getStreams(mimeType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Stream stream = (Stream)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPid());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Stream> getStreams(@NotNull String mimeType) {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Iterable $this$flatMap$iv = this.tsServices;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Service)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ((Service)it).getStreams();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Stream)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((Stream)it).getConfig().getMimeType(), (Object)mimeType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Stream getStream(short pid) {
        Object element$iv2;
        block2: {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.tsServices;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Service it = (Service)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getStreams();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$first$iv = (List)destination$iv$iv;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Stream it = (Stream)element$iv2;
                boolean bl = false;
                if (!(it.getPid() == pid)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Stream)element$iv2;
    }

    private final Service getServices(TsServiceInfo tsServiceInfo) {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.tsServices;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Service it = (Service)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getInfo(), (Object)tsServiceInfo)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Service)element$iv2;
    }

    public TSMuxer() {
        this(null, null, null, 7, null);
    }
}

