/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.mp4.models;

import android.media.MediaFormat;
import android.util.Size;
import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.AV1CodecConfigurationBox2;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.AV1SampleEntry;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.AVCConfigurationBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.AVCSampleEntry;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.ChunkLargeOffsetBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.DataEntryUrlBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.DataInformationBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.DataReferenceBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.ESDSBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.HEVCConfigurationBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.HEVCSampleEntry;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.HandlerBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.MP4AudioSampleEntry;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.MediaBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.MediaHeaderBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.MediaInformationBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.OpusSampleEntry;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.OpusSpecificBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.SampleDescriptionBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.SampleEntry;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.SampleSizeBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.SampleTableBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.SampleToChunkBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.SyncSampleBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.TimeToSampleBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.TrackBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.TrackExtendsBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.TrackFragmentBaseMediaDecodeTimeBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.TrackFragmentBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.TrackFragmentHeaderBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.TrackHeaderBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.TrackRunBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.TypeMediaHeaderBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.VP9SampleEntry;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.VPCodecConfigurationBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.Chunk;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.SampleDependsOn;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.SampleFlags;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.Track;
import io.github.thibaultbee.streampack.internal.muxers.mp4.utils.ConfigExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.av.audio.opus.IdentificationHeader;
import io.github.thibaultbee.streampack.internal.utils.av.audio.opus.OpusCsdParser;
import io.github.thibaultbee.streampack.internal.utils.av.descriptors.AudioSpecificConfigDescriptor;
import io.github.thibaultbee.streampack.internal.utils.av.descriptors.ESDescriptor;
import io.github.thibaultbee.streampack.internal.utils.av.descriptors.SLConfigDescriptor;
import io.github.thibaultbee.streampack.internal.utils.av.video.avc.AVCDecoderConfigurationRecord;
import io.github.thibaultbee.streampack.internal.utils.av.video.hevc.HEVCDecoderConfigurationRecord;
import io.github.thibaultbee.streampack.internal.utils.av.video.vpx.VPCodecConfigurationRecord;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.extensions.MediaFormatExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u000204J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0012H\u0002J\b\u00108\u001a\u00020\u0007H\u0002J\b\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020<H\u0002J\n\u0010=\u001a\u0004\u0018\u00010>H\u0002J\b\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0012H\u0002J\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\nH\u0002J\u0016\u0010K\u001a\u00020L2\u0006\u0010C\u001a\u00020\u00122\u0006\u0010J\u001a\u00020\nJ\u000e\u0010M\u001a\u00020N2\u0006\u00107\u001a\u00020\u0012J\u0006\u0010O\u001a\u00020PJ\u0006\u0010Q\u001a\u00020\u0007R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00160\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0018R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\"R\u0014\u0010$\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0010R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\"R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0018R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0018R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u00a8\u0006R"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/models/TrackChunks;", "", "track", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/models/Track;", "onNewSample", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "", "(Lio/github/thibaultbee/streampack/internal/muxers/mp4/models/Track;Lkotlin/jvm/functions/Function1;)V", "bufferSizeCalculator", "", "chunks", "", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/models/Chunk;", "dataSize", "getDataSize", "()I", "duration", "", "getDuration", "()J", "extra", "", "getExtra", "()Ljava/util/List;", "firstTimestamp", "getFirstTimestamp", "format", "Landroid/media/MediaFormat;", "getFormat", "frameId", "hasData", "", "getHasData", "()Z", "isValid", "numOfSamples", "getNumOfSamples", "getOnNewSample", "()Lkotlin/jvm/functions/Function1;", "onlySyncFrame", "getOnlySyncFrame", "sampleDts", "getSampleDts", "sampleSizes", "getSampleSizes", "syncFrameList", "getSyncFrameList", "getTrack", "()Lio/github/thibaultbee/streampack/internal/muxers/mp4/models/Track;", "add", "frame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "createChunkOffsetBox", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/ChunkLargeOffsetBox;", "firstChunkOffset", "createNewChunk", "createSampleDescriptionBox", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/SampleDescriptionBox;", "createSampleToChunkBox", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/SampleToChunkBox;", "createSyncSampleBox", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/SyncSampleBox;", "createTimeToSampleBox", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TimeToSampleBox;", "createTrackFragmentHeaderBox", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackFragmentHeaderBox;", "baseDataOffset", "createTrackHeaderBox", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackHeaderBox;", "config", "Lio/github/thibaultbee/streampack/data/Config;", "createTrackRunBox", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackRunBox;", "moofSize", "createTraf", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackFragmentBox;", "createTrak", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackBox;", "createTref", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackExtendsBox;", "write", "core_release"})
@SourceDebugExtension(value={"SMAP\nTrackChunks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackChunks.kt\nio/github/thibaultbee/streampack/internal/muxers/mp4/models/TrackChunks\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,471:1\n1#2:472\n1726#3,3:473\n1360#3:476\n1446#3,5:477\n1360#3:482\n1446#3,5:483\n1360#3:488\n1446#3,5:489\n1360#3:494\n1446#3,5:495\n1360#3:500\n1446#3,2:501\n1549#3:503\n1620#3,3:504\n1448#3,3:507\n1855#3,2:510\n1855#3,2:512\n1549#3:514\n1620#3,3:515\n1855#3,2:518\n1559#3:520\n1590#3,4:521\n*S KotlinDebug\n*F\n+ 1 TrackChunks.kt\nio/github/thibaultbee/streampack/internal/muxers/mp4/models/TrackChunks\n*L\n150#1:473,3\n153#1:476\n153#1:477,5\n156#1:482\n156#1:483,5\n159#1:488\n159#1:489,5\n162#1:494\n162#1:495,5\n165#1:500\n165#1:501,2\n165#1:503\n165#1:504,3\n165#1:507,3\n184#1:510,2\n265#1:512,2\n294#1:514\n294#1:515,3\n294#1:518,2\n451#1:520\n451#1:521,4\n*E\n"})
public final class TrackChunks {
    @NotNull
    private final Track track;
    @NotNull
    private final Function1<ByteBuffer, Unit> onNewSample;
    @NotNull
    private final List<Chunk> chunks;
    private int frameId;
    @NotNull
    private final Function1<ByteBuffer, Integer> bufferSizeCalculator;

    public TrackChunks(@NotNull Track track, @NotNull Function1<? super ByteBuffer, Unit> onNewSample) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        Intrinsics.checkNotNullParameter(onNewSample, (String)"onNewSample");
        this.track = track;
        this.onNewSample = onNewSample;
        this.chunks = new ArrayList();
        this.frameId = 1;
        this.bufferSizeCalculator = (Function1)new Function1<ByteBuffer, Integer>(this){
            final /* synthetic */ TrackChunks this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                String string2 = this.this$0.getTrack().getConfig().getMimeType();
                return (Intrinsics.areEqual((Object)string2, (Object)"video/hevc") ? true : Intrinsics.areEqual((Object)string2, (Object)"video/avc")) ? 4 + buffer.remaining() - ByteBufferExtensionsKt.getStartCodeSize(buffer) : buffer.remaining();
            }
        };
    }

    @NotNull
    public final Track getTrack() {
        return this.track;
    }

    @NotNull
    public final Function1<ByteBuffer, Unit> getOnNewSample() {
        return this.onNewSample;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValid() {
        if (this.getNumOfSamples() <= 0) return false;
        switch (this.track.getConfig().getMimeType()) {
            case "video/avc": {
                if (this.getExtra().size() != 2) return false;
                return true;
            }
            case "video/hevc": {
                if (this.getExtra().size() != 3) return false;
                return true;
            }
            case "video/x-vnd.on2.vp9": {
                if (((Collection)this.getFormat()).isEmpty()) return false;
                return true;
            }
            case "video/av01": {
                if (this.getExtra().size() != 1) return false;
                return true;
            }
            case "audio/mp4a-latm": {
                if (this.getExtra().size() != 1) return false;
                return true;
            }
            case "audio/opus": {
                if (this.getExtra().size() == 3) return true;
                if (this.getExtra().size() != 1) return false;
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unsupported mimeType " + this.track.getConfig().getMimeType());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final long getDuration() {
        Iterable iterable = this.chunks;
        long l = 0L;
        for (Object t : iterable) {
            void it;
            Chunk chunk = (Chunk)t;
            long l2 = l;
            boolean bl = false;
            long l3 = it.getDuration();
            l = l2 + l3;
        }
        return l * (long)this.track.getTimescale() / (long)1000000;
    }

    public final long getFirstTimestamp() {
        Iterator iterator = ((Iterable)this.chunks).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Chunk it = (Chunk)iterator.next();
        boolean bl = false;
        long l = it.getFirstTimestamp();
        while (iterator.hasNext()) {
            Chunk it2 = (Chunk)iterator.next();
            $i$a$-minOf-TrackChunks$firstTimestamp$1 = false;
            long l2 = it2.getFirstTimestamp();
            if (l <= l2) continue;
            l = l2;
        }
        return l * (long)this.track.getTimescale() / (long)1000000;
    }

    /*
     * WARNING - void declaration
     */
    public final int getDataSize() {
        Iterable iterable = this.chunks;
        int n = 0;
        for (Object t : iterable) {
            void it;
            Chunk chunk = (Chunk)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getDataSize(this.bufferSizeCalculator);
            n = n2 + n3;
        }
        return n;
    }

    public final boolean getHasData() {
        return this.getDataSize() > 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int getNumOfSamples() {
        Iterable iterable = this.chunks;
        int n = 0;
        for (Object t : iterable) {
            void it;
            Chunk chunk = (Chunk)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getNumOfSamples();
            n = n2 + n3;
        }
        return n;
    }

    private final boolean getOnlySyncFrame() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.chunks;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Chunk it = (Chunk)element$iv;
                    boolean bl2 = false;
                    if (it.getOnlySyncFrame()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getSyncFrameList() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.chunks;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Chunk it = (Chunk)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSyncFrameList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getSampleSizes() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.chunks;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Chunk it = (Chunk)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSampleSizes(this.bufferSizeCalculator);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<ByteBuffer>> getExtra() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.chunks;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Chunk it = (Chunk)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getExtra();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MediaFormat> getFormat() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.chunks;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Chunk it = (Chunk)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFormat();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Long> getSampleDts() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.chunks;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Chunk chunk = (Chunk)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = chunk.getSampleDts();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add((long)(it * (long)this.track.getTimescale() / (long)1000000));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void createNewChunk() {
        Chunk newChunk = new Chunk(this.chunks.size() + 1);
        this.chunks.add(newChunk);
    }

    public final void add(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (this.chunks.isEmpty()) {
            this.createNewChunk();
        }
        Frame frameCopy = Frame.copy$default(frame, ByteBufferExtensionsKt.clone(frame.getBuffer()), 0L, null, false, null, 30, null);
        ((Chunk)CollectionsKt.last(this.chunks)).add(this.frameId, frameCopy);
        int n = this.frameId;
        this.frameId = n + 1;
    }

    public final void write() {
        Iterable $this$forEach$iv = this.chunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Chunk chunk = (Chunk)element$iv;
            boolean bl = false;
            chunk.writeTo((Function1<? super Frame, Unit>)((Function1)new Function1<Frame, Unit>(this){
                final /* synthetic */ TrackChunks this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final void invoke(@NotNull Frame frame) {
                    Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                    String string2 = this.this$0.getTrack().getConfig().getMimeType();
                    if (!(Intrinsics.areEqual((Object)string2, (Object)"video/hevc") ? true : Intrinsics.areEqual((Object)string2, (Object)"video/avc"))) {
                        this.this$0.getOnNewSample().invoke((Object)frame.getBuffer());
                        return;
                    }
                    if (ByteBufferExtensionsKt.isAnnexB(frame.getBuffer())) {
                        ByteBuffer noStartCodeBuffer = ByteBufferExtensionsKt.removeStartCode(frame.getBuffer());
                        ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
                        sizeBuffer.putInt(0, noStartCodeBuffer.remaining());
                        Function1<ByteBuffer, Unit> function1 = this.this$0.getOnNewSample();
                        Intrinsics.checkNotNull((Object)sizeBuffer);
                        function1.invoke((Object)sizeBuffer);
                        this.this$0.getOnNewSample().invoke((Object)noStartCodeBuffer);
                        return;
                    }
                    if (ByteBufferExtensionsKt.isAvcc(frame.getBuffer())) {
                        this.this$0.getOnNewSample().invoke((Object)frame.getBuffer());
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append("Unsupported buffer format: buffer start with 0x");
                    String string3 = Integer.toString(frame.getBuffer().get(0), CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                    StringBuilder stringBuilder2 = stringBuilder.append(string3).append(", 0x");
                    String string4 = Integer.toString(frame.getBuffer().get(1), CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                    StringBuilder stringBuilder3 = stringBuilder2.append(string4).append(", 0x");
                    String string5 = Integer.toString(frame.getBuffer().get(2), CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                    StringBuilder stringBuilder4 = stringBuilder3.append(string5).append(", 0x");
                    String string6 = Integer.toString(frame.getBuffer().get(3), CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
                    throw new IllegalArgumentException(stringBuilder4.append(string6).toString());
                }
            }));
        }
    }

    @NotNull
    public final TrackBox createTrak(long firstChunkOffset) {
        TrackHeaderBox tkhd = this.createTrackHeaderBox(this.track.getConfig(), (MediaFormat)CollectionsKt.first(this.getFormat()));
        MediaHeaderBox mdhd = new MediaHeaderBox(0, 0L, 0L, this.track.getTimescale(), this.getDuration(), 0, 38, null);
        HandlerBox hdlr = ConfigExtensionsKt.createHandlerBox(this.track.getConfig());
        TypeMediaHeaderBox mhd = ConfigExtensionsKt.createTypeMediaHeaderBox(this.track.getConfig());
        DataInformationBox dinf = new DataInformationBox(new DataReferenceBox(new DataEntryUrlBox(null, 1, null)));
        SampleDescriptionBox stsd = this.createSampleDescriptionBox();
        TimeToSampleBox stts = this.createTimeToSampleBox();
        SyncSampleBox stss = this.createSyncSampleBox();
        SampleToChunkBox stsc = this.createSampleToChunkBox();
        SampleSizeBox stsz = new SampleSizeBox(0, this.getSampleSizes(), 1, null);
        ChunkLargeOffsetBox co = this.createChunkOffsetBox(firstChunkOffset);
        SampleTableBox stbl = new SampleTableBox(stsd, stts, stss, stsc, stsz, co);
        MediaInformationBox minf = new MediaInformationBox(mhd, dinf, stbl);
        MediaBox mdia = new MediaBox(mdhd, hdlr, minf);
        return new TrackBox(tkhd, mdia);
    }

    private final TrackHeaderBox createTrackHeaderBox(Config config, MediaFormat format) {
        Size size2;
        Config config2 = config;
        if (config2 instanceof AudioConfig) {
            size2 = new Size(0, 0);
        } else if (config2 instanceof VideoConfig) {
            size2 = MediaFormatExtensionsKt.getResolution(format);
        } else {
            throw new IllegalArgumentException("Unsupported config");
        }
        Size resolution = size2;
        float volume = config instanceof AudioConfig ? 1.0f : 0.0f;
        int n = this.track.getId();
        TrackHeaderBox.TrackFlag[] trackFlagArray = new TrackHeaderBox.TrackFlag[]{TrackHeaderBox.TrackFlag.ENABLED, TrackHeaderBox.TrackFlag.IN_MOVIE, TrackHeaderBox.TrackFlag.IN_PREVIEW};
        List list = CollectionsKt.listOf((Object[])trackFlagArray);
        long l = this.getDuration();
        return new TrackHeaderBox(0, list, n, 0L, 0L, l, 0, 0, volume, null, resolution, 728, null);
    }

    private final SampleToChunkBox createSampleToChunkBox() {
        List filteredSampleToChunkEntries = new ArrayList();
        Iterable $this$forEach$iv = this.chunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Chunk it = (Chunk)element$iv;
            boolean bl = false;
            try {
                SampleToChunkBox.Entry last = (SampleToChunkBox.Entry)CollectionsKt.last((List)filteredSampleToChunkEntries);
                if (last.getSamplesPerChunk() == it.getNumOfSamples()) continue;
                filteredSampleToChunkEntries.add(new SampleToChunkBox.Entry(it.getId(), it.getNumOfSamples(), 1));
            }
            catch (NoSuchElementException e) {
                filteredSampleToChunkEntries.add(new SampleToChunkBox.Entry(it.getId(), it.getNumOfSamples(), 1));
            }
        }
        return new SampleToChunkBox(filteredSampleToChunkEntries);
    }

    /*
     * WARNING - void declaration
     */
    private final ChunkLargeOffsetBox createChunkOffsetBox(long firstChunkOffset) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        List chunkOffsets = new ArrayList();
        Iterable $this$map$iv = this.chunks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Chunk chunk = (Chunk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDataSize(this.bufferSizeCalculator));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            try {
                chunkOffsets.add(((Number)CollectionsKt.last((List)chunkOffsets)).longValue() + (long)it);
            }
            catch (NoSuchElementException e) {
                chunkOffsets.add(firstChunkOffset);
            }
        }
        return new ChunkLargeOffsetBox(chunkOffsets);
    }

    private final TimeToSampleBox createTimeToSampleBox() {
        return TimeToSampleBox.Companion.fromDts(this.getSampleDts(), true);
    }

    private final SampleDescriptionBox createSampleDescriptionBox() {
        SampleEntry sampleEntry;
        switch (this.track.getConfig().getMimeType()) {
            case "video/avc": {
                MediaFormat format = (MediaFormat)CollectionsKt.first(this.getFormat());
                List<List<ByteBuffer>> extra = this.getExtra();
                if (!(extra.size() == 2)) {
                    boolean $i$a$-require-TrackChunks$createSampleDescriptionBox$sampleEntry$52 = false;
                    String $i$a$-require-TrackChunks$createSampleDescriptionBox$sampleEntry$52 = "For AVC, extra must contain 2 parameter sets";
                    throw new IllegalArgumentException($i$a$-require-TrackChunks$createSampleDescriptionBox$sampleEntry$52.toString());
                }
                Config config = this.track.getConfig();
                Intrinsics.checkNotNull((Object)config, (String)"null cannot be cast to non-null type io.github.thibaultbee.streampack.data.VideoConfig");
                VideoConfig cfr_ignored_0 = (VideoConfig)config;
                sampleEntry = new AVCSampleEntry(MediaFormatExtensionsKt.getResolution(format), 0, 0, 0, null, 0, new AVCConfigurationBox(AVCDecoderConfigurationRecord.Companion.fromParameterSets(extra.get(0), extra.get(1))), null, null, null, null, 1982, null);
                break;
            }
            case "video/hevc": {
                MediaFormat format = (MediaFormat)CollectionsKt.first(this.getFormat());
                List<List<ByteBuffer>> extra = this.getExtra();
                if (!(extra.size() == 3)) {
                    boolean $i$a$-require-TrackChunks$createSampleDescriptionBox$sampleEntry$62 = false;
                    String $i$a$-require-TrackChunks$createSampleDescriptionBox$sampleEntry$62 = "For HEVC, extra must contain 3 parameter sets";
                    throw new IllegalArgumentException($i$a$-require-TrackChunks$createSampleDescriptionBox$sampleEntry$62.toString());
                }
                Config config = this.track.getConfig();
                Intrinsics.checkNotNull((Object)config, (String)"null cannot be cast to non-null type io.github.thibaultbee.streampack.data.VideoConfig");
                VideoConfig cfr_ignored_1 = (VideoConfig)config;
                sampleEntry = new HEVCSampleEntry(MediaFormatExtensionsKt.getResolution(format), 0, 0, 0, null, 0, new HEVCConfigurationBox(HEVCDecoderConfigurationRecord.Companion.fromParameterSets(CollectionsKt.flatten((Iterable)extra))), null, null, null, null, 1982, null);
                break;
            }
            case "video/x-vnd.on2.vp9": {
                MediaFormat format = (MediaFormat)CollectionsKt.first(this.getFormat());
                Config config = this.track.getConfig();
                Intrinsics.checkNotNull((Object)config, (String)"null cannot be cast to non-null type io.github.thibaultbee.streampack.data.VideoConfig");
                VideoConfig cfr_ignored_2 = (VideoConfig)config;
                sampleEntry = new VP9SampleEntry(MediaFormatExtensionsKt.getResolution(format), 0, 0, 0, null, 0, new VPCodecConfigurationBox(VPCodecConfigurationRecord.Companion.fromMediaFormat(format)), null, null, null, null, 1982, null);
                break;
            }
            case "video/av01": {
                MediaFormat format = (MediaFormat)CollectionsKt.first(this.getFormat());
                List<List<ByteBuffer>> extra = this.getExtra();
                if (!(extra.size() == 1)) {
                    boolean bl = false;
                    String string2 = "For AV1, extra must contain 1 extra";
                    throw new IllegalArgumentException(string2.toString());
                }
                Config config = this.track.getConfig();
                Intrinsics.checkNotNull((Object)config, (String)"null cannot be cast to non-null type io.github.thibaultbee.streampack.data.VideoConfig");
                VideoConfig cfr_ignored_3 = (VideoConfig)config;
                sampleEntry = new AV1SampleEntry(MediaFormatExtensionsKt.getResolution(format), 0, 0, 0, null, 0, new AV1CodecConfigurationBox2(extra.get(0).get(0)), null, null, null, null, 1982, null);
                break;
            }
            case "audio/mp4a-latm": {
                Config config = this.track.getConfig();
                Intrinsics.checkNotNull((Object)config, (String)"null cannot be cast to non-null type io.github.thibaultbee.streampack.data.AudioConfig");
                AudioConfig cfr_ignored_4 = (AudioConfig)config;
                sampleEntry = new MP4AudioSampleEntry((short)AudioConfig.Companion.getNumberOfChannels(((AudioConfig)this.track.getConfig()).getChannelConfig()), (short)AudioConfig.Companion.getNumOfBytesPerSample(((AudioConfig)this.track.getConfig()).getByteFormat()), ((AudioConfig)this.track.getConfig()).getSampleRate(), new ESDSBox(new ESDescriptor(0, 0, null, null, null, new AudioSpecificConfigDescriptor(false, 1536, this.track.getConfig().getStartBitrate(), this.track.getConfig().getStartBitrate(), this.getExtra().get(0).get(0)), new SLConfigDescriptor(2), 28, null)), null, 16, null);
                break;
            }
            case "audio/opus": {
                List<List<ByteBuffer>> extra = this.getExtra();
                if (!(this.getExtra().size() == 3 || this.getExtra().size() == 1)) {
                    boolean $i$a$-require-TrackChunks$createSampleDescriptionBox$sampleEntry$72 = false;
                    String $i$a$-require-TrackChunks$createSampleDescriptionBox$sampleEntry$72 = "For Opus, extra must contain 1 or 3 parameter sets";
                    throw new IllegalArgumentException($i$a$-require-TrackChunks$createSampleDescriptionBox$sampleEntry$72.toString());
                }
                Config config = this.track.getConfig();
                Intrinsics.checkNotNull((Object)config, (String)"null cannot be cast to non-null type io.github.thibaultbee.streampack.data.AudioConfig");
                AudioConfig cfr_ignored_5 = (AudioConfig)config;
                Triple<IdentificationHeader, ByteBuffer, ByteBuffer> triple = OpusCsdParser.Companion.parse(extra.get(0).get(0));
                IdentificationHeader identificationHeader = (IdentificationHeader)triple.getFirst();
                sampleEntry = new OpusSampleEntry((short)AudioConfig.Companion.getNumberOfChannels(((AudioConfig)this.track.getConfig()).getChannelConfig()), new OpusSpecificBox(0, identificationHeader.getChannelCount(), identificationHeader.getPreSkip(), identificationHeader.getInputSampleRate(), identificationHeader.getOutputGain(), identificationHeader.getChannelMappingFamily(), identificationHeader.getChannelMapping(), 1, null), null, 4, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported mimeType " + this.track.getConfig().getMimeType());
            }
        }
        SampleEntry sampleEntry2 = sampleEntry;
        return new SampleDescriptionBox(sampleEntry2);
    }

    private final SyncSampleBox createSyncSampleBox() {
        return !this.getOnlySyncFrame() ? new SyncSampleBox(this.getSyncFrameList()) : null;
    }

    @NotNull
    public final TrackExtendsBox createTref() {
        return new TrackExtendsBox(this.track.getId(), 0, 0, 0, null, 30, null);
    }

    @NotNull
    public final TrackFragmentBox createTraf(long baseDataOffset, int moofSize) {
        TrackFragmentHeaderBox tfhd = this.createTrackFragmentHeaderBox(baseDataOffset);
        TrackFragmentBaseMediaDecodeTimeBox tfdt = new TrackFragmentBaseMediaDecodeTimeBox((this.getFirstTimestamp() - this.track.getFirstTimestamp()) * (long)1000000 / (long)this.track.getTimescale());
        TrackRunBox trun = this.createTrackRunBox(moofSize);
        return new TrackFragmentBox(tfhd, tfdt, trun);
    }

    private final TrackFragmentHeaderBox createTrackFragmentHeaderBox(long baseDataOffset) {
        return new TrackFragmentHeaderBox(this.track.getId(), baseDataOffset, null, null, null, new SampleFlags(null, SampleDependsOn.OTHERS, null, null, 0, true, 0, 93, null), false, 92, null);
    }

    /*
     * WARNING - void declaration
     */
    private final TrackRunBox createTrackRunBox(int moofSize) {
        void $this$mapIndexedTo$iv$iv;
        List<Long> sampleDts = this.getSampleDts();
        List<Integer> sampleSizes = this.getSampleSizes();
        if (!(sampleDts.size() == sampleSizes.size())) {
            boolean $i$a$-require-TrackChunks$createTrackRunBox$22 = false;
            String $i$a$-require-TrackChunks$createTrackRunBox$22 = "Samples dts and sizes must have the same size";
            throw new IllegalArgumentException($i$a$-require-TrackChunks$createTrackRunBox$22.toString());
        }
        int lastEntryIndex = sampleSizes.size() - 1;
        Iterable $this$mapIndexed$iv = sampleSizes;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void size2;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv$iv).intValue();
            int n3 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TrackRunBox.Entry((int)(index == lastEntryIndex ? 0L : ((Number)sampleDts.get((int)(index + true))).longValue() - ((Number)sampleDts.get((int)index)).longValue()), (int)size2, null, null, 12, null));
        }
        List entries = (List)destination$iv$iv;
        return new TrackRunBox(0, moofSize, new SampleFlags(null, SampleDependsOn.NO_OTHER, null, null, 0, false, 0, 93, null), entries);
    }
}

