/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.mp4.boxes;

import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.FullBox;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackFragmentBaseMediaDecodeTimeBox;", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/FullBox;", "baseMediaDecodeTime", "", "(Ljava/lang/Number;)V", "size", "", "getSize", "()I", "write", "", "output", "Ljava/nio/ByteBuffer;", "core_release"})
public final class TrackFragmentBaseMediaDecodeTimeBox
extends FullBox {
    @NotNull
    private final Number baseMediaDecodeTime;
    private final int size;

    public TrackFragmentBaseMediaDecodeTimeBox(@NotNull Number baseMediaDecodeTime) {
        byte by;
        Intrinsics.checkNotNullParameter((Object)baseMediaDecodeTime, (String)"baseMediaDecodeTime");
        Number number = baseMediaDecodeTime;
        if (number instanceof Integer) {
            by = 0;
        } else if (number instanceof Long) {
            by = 1;
        } else {
            throw new IllegalArgumentException("baseMediaDecodeTime must be Int or Long");
        }
        super("tfdt", by, 0, false, 8, null);
        this.baseMediaDecodeTime = baseMediaDecodeTime;
        this.size = super.getSize() + (this.getVersion() == 1 ? 8 : 4);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        byte by = this.getVersion();
        if (by == 1) {
            Number number = this.baseMediaDecodeTime;
            Intrinsics.checkNotNull((Object)number, (String)"null cannot be cast to non-null type kotlin.Long");
            output.putLong((Long)number);
        } else if (by == 0) {
            Number number = this.baseMediaDecodeTime;
            Intrinsics.checkNotNull((Object)number, (String)"null cannot be cast to non-null type kotlin.Int");
            output.putInt((Integer)number);
        } else {
            throw new IllegalArgumentException("version must be 0 or 1");
        }
    }
}

