/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.extensions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\t\u001a\u00020\u0002*\u00020\u0002\u001a\u0012\u0010\n\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0006\u001a\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015\u001a\"\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0006\u001a\u001a\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0012\u0010\u001f\u001a\u00020\u0017*\u00020\u00022\u0006\u0010 \u001a\u00020!\u001a\u0012\u0010\"\u001a\u00020\u0017*\u00020\u00022\u0006\u0010#\u001a\u00020$\u001a\u0012\u0010\"\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0006\u001a\u0012\u0010%\u001a\u00020\u0017*\u00020\u00022\u0006\u0010#\u001a\u00020$\u001a\u0012\u0010&\u001a\u00020\u0017*\u00020\u00022\u0006\u0010'\u001a\u00020(\u001a\u0012\u0010&\u001a\u00020\u0017*\u00020\u00022\u0006\u0010)\u001a\u00020\r\u001a\u0012\u0010*\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0006\u001a\u0012\u0010+\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\r\u001a\u0012\u0010,\u001a\u00020\u0017*\u00020\u00022\u0006\u0010'\u001a\u00020(\u001a\u0012\u0010,\u001a\u00020\u0017*\u00020\u00022\u0006\u0010#\u001a\u00020$\u001a\u0012\u0010,\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0006\u001a\u0012\u0010,\u001a\u00020\u0017*\u00020\u00022\u0006\u0010)\u001a\u00020\r\u001a\u0012\u0010-\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0010\u001a\u0018\u0010.\u001a\u00020\u0002*\u00020\u00022\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013\u001a\n\u00100\u001a\u00020\u0002*\u00020\u0002\u001a\u0018\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0012\u00102\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002\u001a\u0012\u00102\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0010\u001a\u0012\u00103\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015\u001a$\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000604*\u00020\u00022\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013\u001a\n\u00105\u001a\u00020\u0015*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u00066"}, d2={"isAnnexB", "", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)Z", "isAvcc", "startCodeSize", "", "getStartCodeSize", "(Ljava/nio/ByteBuffer;)I", "clone", "extractRbsp", "headerLength", "getLong", "", "isLittleEndian", "getString", "", "size", "indicesOf", "", "prefix", "", "put", "", "buffer", "offset", "length", "i", "i1", "s", "", "put3x3Matrix", "matrix", "", "putFixed1616", "f", "", "putFixed88", "putInt", "d", "", "l", "putInt24", "putLong48", "putShort", "putString", "removePrefixes", "prefixes", "removeStartCode", "slices", "startWith", "startsWith", "Lkotlin/Pair;", "toByteArray", "core_release"})
@SourceDebugExtension(value={"SMAP\nByteBufferExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBufferExtensions.kt\nio/github/thibaultbee/streampack/internal/utils/extensions/ByteBufferExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n1#2:327\n13330#3,2:328\n1864#4,3:330\n1549#4:333\n1620#4,3:334\n1864#4,3:337\n1855#4,2:340\n*S KotlinDebug\n*F\n+ 1 ByteBufferExtensions.kt\nio/github/thibaultbee/streampack/internal/utils/extensions/ByteBufferExtensionsKt\n*L\n86#1:328,2\n141#1:330,3\n150#1:333\n150#1:334,3\n190#1:337,3\n275#1:340,2\n*E\n"})
public final class ByteBufferExtensionsKt {
    public static final void put(@NotNull ByteBuffer $this$put, int i, int i1) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        $this$put.put(i, (byte)i1);
    }

    public static final void put(@NotNull ByteBuffer $this$put, short s) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        $this$put.put((byte)s);
    }

    public static final void put(@NotNull ByteBuffer $this$put, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        $this$put.put((byte)i);
    }

    public static final void putInt24(@NotNull ByteBuffer $this$putInt24, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$putInt24, (String)"<this>");
        ByteBufferExtensionsKt.putShort($this$putInt24, i >> 8);
        $this$putInt24.put((byte)i);
    }

    public static final void putLong48(@NotNull ByteBuffer $this$putLong48, long i) {
        Intrinsics.checkNotNullParameter((Object)$this$putLong48, (String)"<this>");
        ByteBufferExtensionsKt.putShort($this$putLong48, i >> 32);
        $this$putLong48.putInt((int)i);
    }

    public static final void putInt(@NotNull ByteBuffer $this$putInt, long l) {
        Intrinsics.checkNotNullParameter((Object)$this$putInt, (String)"<this>");
        $this$putInt.putInt((int)l);
    }

    public static final void putInt(@NotNull ByteBuffer $this$putInt, double d) {
        Intrinsics.checkNotNullParameter((Object)$this$putInt, (String)"<this>");
        $this$putInt.putInt((int)d);
    }

    public static final void putShort(@NotNull ByteBuffer $this$putShort, long l) {
        Intrinsics.checkNotNullParameter((Object)$this$putShort, (String)"<this>");
        $this$putShort.putShort((short)l);
    }

    public static final void putShort(@NotNull ByteBuffer $this$putShort, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$putShort, (String)"<this>");
        $this$putShort.putShort((short)i);
    }

    public static final void putShort(@NotNull ByteBuffer $this$putShort, float f) {
        Intrinsics.checkNotNullParameter((Object)$this$putShort, (String)"<this>");
        $this$putShort.putShort((short)f);
    }

    public static final void putShort(@NotNull ByteBuffer $this$putShort, double d) {
        Intrinsics.checkNotNullParameter((Object)$this$putShort, (String)"<this>");
        $this$putShort.putShort((short)d);
    }

    public static final void putString(@NotNull ByteBuffer $this$putString, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)$this$putString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string2 = s;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        $this$putString.put(byArray);
    }

    public static final void putFixed88(@NotNull ByteBuffer $this$putFixed88, float f) {
        Intrinsics.checkNotNullParameter((Object)$this$putFixed88, (String)"<this>");
        ByteBufferExtensionsKt.putShort($this$putFixed88, (double)f * 256.0);
    }

    public static final void putFixed1616(@NotNull ByteBuffer $this$putFixed1616, float f) {
        Intrinsics.checkNotNullParameter((Object)$this$putFixed1616, (String)"<this>");
        ByteBufferExtensionsKt.putInt($this$putFixed1616, (double)f * 65536.0);
    }

    public static final void putFixed1616(@NotNull ByteBuffer $this$putFixed1616, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$putFixed1616, (String)"<this>");
        ByteBufferExtensionsKt.putInt($this$putFixed1616, (double)i * 65536.0);
    }

    public static final void put3x3Matrix(@NotNull ByteBuffer $this$put3x3Matrix, @NotNull int[] matrix) {
        Intrinsics.checkNotNullParameter((Object)$this$put3x3Matrix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        if (!(matrix.length == 9)) {
            boolean $i$a$-require-ByteBufferExtensionsKt$put3x3Matrix$22 = false;
            String $i$a$-require-ByteBufferExtensionsKt$put3x3Matrix$22 = "transformationMatrix must be a 9-element array";
            throw new IllegalArgumentException($i$a$-require-ByteBufferExtensionsKt$put3x3Matrix$22.toString());
        }
        int[] $this$forEach$iv = matrix;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            $this$put3x3Matrix.putInt(it);
        }
    }

    public static final void put(@NotNull ByteBuffer $this$put, @NotNull ByteBuffer buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int limit = buffer.limit();
        buffer.position(offset);
        buffer.limit(offset + length);
        $this$put.put(buffer);
        buffer.limit(limit);
    }

    @NotNull
    public static final String getString(@NotNull ByteBuffer $this$getString, int size2) {
        Intrinsics.checkNotNullParameter((Object)$this$getString, (String)"<this>");
        byte[] bytes = new byte[size2];
        $this$getString.get(bytes);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(bytes, charset2);
    }

    public static /* synthetic */ String getString$default(ByteBuffer byteBuffer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = byteBuffer.remaining();
        }
        return ByteBufferExtensionsKt.getString(byteBuffer, n);
    }

    public static final long getLong(@NotNull ByteBuffer $this$getLong, boolean isLittleEndian) {
        Intrinsics.checkNotNullParameter((Object)$this$getLong, (String)"<this>");
        if (isLittleEndian) {
            $this$getLong.order(ByteOrder.LITTLE_ENDIAN);
        }
        long value = $this$getLong.getLong();
        if (isLittleEndian) {
            $this$getLong.order(ByteOrder.BIG_ENDIAN);
        }
        return value;
    }

    @NotNull
    public static final List<Integer> indicesOf(@NotNull ByteBuffer $this$indicesOf, @NotNull byte[] prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$indicesOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (prefix.length == 0) {
            return CollectionsKt.emptyList();
        }
        List indices = new ArrayList();
        int n = $this$indicesOf.limit() - prefix.length + 1;
        block0: for (int i = 0; i < n; ++i) {
            int n2 = prefix.length;
            for (int j = 0; j < n2; ++j) {
                if ($this$indicesOf.get(i + j) != prefix[j]) continue block0;
            }
            indices.add(i);
        }
        return indices;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ByteBuffer> slices(@NotNull ByteBuffer $this$slices, @NotNull byte[] prefix) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$slices, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        List slices = new ArrayList();
        List<Integer> indexes = ByteBufferExtensionsKt.indicesOf($this$slices, prefix);
        Iterable $this$forEachIndexed$iv = indexes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void i;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv).intValue();
            int index = n;
            boolean bl = false;
            int nextPosition = CollectionsKt.getIndices((Collection)indexes).contains(index + 1) ? ((Number)indexes.get(index + 1)).intValue() - 1 : $this$slices.limit() - 1;
            slices.add(new Pair((Object)((int)i), (Object)nextPosition));
        }
        byte[] array = $this$slices.array();
        Iterable $this$map$iv = slices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)array);
            collection.add(ByteBuffer.wrap(ArraysKt.sliceArray((byte[])array, (IntRange)new IntRange(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue()))));
        }
        return (List)destination$iv$iv;
    }

    public static final boolean startsWith(@NotNull ByteBuffer $this$startsWith, @NotNull byte[] prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$startsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if ($this$startsWith.remaining() < prefix.length) {
            return false;
        }
        int position = $this$startsWith.position();
        int n = prefix.length;
        for (int i = 0; i < n; ++i) {
            if ($this$startsWith.get(position + i) == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean startWith(@NotNull ByteBuffer $this$startWith, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$startWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string2 = prefix;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return ByteBufferExtensionsKt.startsWith($this$startWith, byArray);
    }

    public static final boolean startWith(@NotNull ByteBuffer $this$startWith, @NotNull ByteBuffer prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$startWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return ByteBufferExtensionsKt.startsWith($this$startWith, ByteBufferExtensionsKt.toByteArray(prefix));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<Boolean, Integer> startsWith(@NotNull ByteBuffer $this$startsWith, @NotNull List<? extends ByteBuffer> prefixes) {
        Intrinsics.checkNotNullParameter((Object)$this$startsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        Iterable $this$forEachIndexed$iv = prefixes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void byteBuffer;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ByteBuffer byteBuffer2 = (ByteBuffer)item$iv;
            int index = n;
            boolean bl = false;
            if (!ByteBufferExtensionsKt.startWith($this$startsWith, (ByteBuffer)byteBuffer)) continue;
            return new Pair((Object)true, (Object)index);
        }
        return new Pair((Object)false, (Object)-1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] toByteArray(@NotNull ByteBuffer $this$toByteArray) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        if ($this$toByteArray.hasArray() && !$this$toByteArray.isDirect()) {
            byte[] byArray2;
            int offset = $this$toByteArray.position() + $this$toByteArray.arrayOffset();
            byte[] array = $this$toByteArray.array();
            if (offset == 0 && array.length == $this$toByteArray.remaining()) {
                byArray2 = array;
            } else {
                Intrinsics.checkNotNull((Object)array);
                byte[] byArray3 = array;
                int n = offset + $this$toByteArray.remaining();
                byArray2 = ArraysKt.copyOfRange((byte[])byArray3, (int)offset, (int)n);
            }
            byte[] byArray4 = byArray2;
            Intrinsics.checkNotNull((Object)byArray4);
            byArray = byArray4;
        } else {
            void var1_6;
            byte[] byteArray = new byte[$this$toByteArray.remaining()];
            $this$toByteArray.get(byteArray);
            byArray = var1_6;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ByteBuffer clone(@NotNull ByteBuffer $this$clone) {
        Intrinsics.checkNotNullParameter((Object)$this$clone, (String)"<this>");
        int originalPosition = $this$clone.position();
        try {
            ByteBuffer byteBuffer;
            ByteBuffer clone = $this$clone.isDirect() ? ByteBuffer.allocateDirect($this$clone.remaining()) : ByteBuffer.allocate($this$clone.remaining());
            ByteBuffer $this$clone_u24lambda_u245 = byteBuffer = clone.put($this$clone);
            boolean bl = false;
            $this$clone_u24lambda_u245.rewind();
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"apply(...)");
            ByteBuffer byteBuffer3 = byteBuffer2;
            return byteBuffer3;
        }
        finally {
            $this$clone.position(originalPosition);
        }
    }

    public static final int getStartCodeSize(@NotNull ByteBuffer $this$startCodeSize) {
        Intrinsics.checkNotNullParameter((Object)$this$startCodeSize, (String)"<this>");
        return $this$startCodeSize.get(0) == 0 && $this$startCodeSize.get(1) == 0 && $this$startCodeSize.get(2) == 0 && $this$startCodeSize.get(3) == 1 ? 4 : ($this$startCodeSize.get(0) == 0 && $this$startCodeSize.get(1) == 0 && $this$startCodeSize.get(2) == 1 ? 3 : 0);
    }

    @NotNull
    public static final ByteBuffer removeStartCode(@NotNull ByteBuffer $this$removeStartCode) {
        Intrinsics.checkNotNullParameter((Object)$this$removeStartCode, (String)"<this>");
        int startCodeSize = ByteBufferExtensionsKt.getStartCodeSize($this$removeStartCode);
        $this$removeStartCode.position(startCodeSize);
        ByteBuffer byteBuffer = $this$removeStartCode.slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slice(...)");
        return byteBuffer;
    }

    @NotNull
    public static final ByteBuffer extractRbsp(@NotNull ByteBuffer $this$extractRbsp, int headerLength) {
        Intrinsics.checkNotNullParameter((Object)$this$extractRbsp, (String)"<this>");
        ByteBuffer rbsp = ByteBuffer.allocateDirect($this$extractRbsp.remaining());
        byte[] byArray = new byte[]{0, 0, 3};
        List<Integer> indices = ByteBufferExtensionsKt.indicesOf($this$extractRbsp, byArray);
        Intrinsics.checkNotNull((Object)rbsp);
        ByteBufferExtensionsKt.put(rbsp, $this$extractRbsp, ByteBufferExtensionsKt.getStartCodeSize($this$extractRbsp), headerLength);
        int previous = 0;
        previous = $this$extractRbsp.position();
        Iterable $this$forEach$iv = indices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            ByteBufferExtensionsKt.put(rbsp, $this$extractRbsp, previous, it + 2 - previous);
            previous = it + 3;
        }
        ByteBufferExtensionsKt.put(rbsp, $this$extractRbsp, previous, $this$extractRbsp.limit() - previous);
        rbsp.limit(rbsp.position());
        rbsp.rewind();
        return rbsp;
    }

    @NotNull
    public static final ByteBuffer removePrefixes(@NotNull ByteBuffer $this$removePrefixes, @NotNull List<? extends ByteBuffer> prefixes) {
        Intrinsics.checkNotNullParameter((Object)$this$removePrefixes, (String)"<this>");
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        List mutablePrefixes = CollectionsKt.toMutableList((Collection)prefixes);
        boolean hasPrefix = true;
        while (hasPrefix) {
            Pair<Boolean, Integer> result = ByteBufferExtensionsKt.startsWith($this$removePrefixes, mutablePrefixes);
            hasPrefix = (Boolean)result.getFirst();
            if (!hasPrefix) continue;
            $this$removePrefixes.position($this$removePrefixes.position() + ((ByteBuffer)mutablePrefixes.get(((Number)result.getSecond()).intValue())).limit());
            mutablePrefixes.remove(((Number)result.getSecond()).intValue());
        }
        ByteBuffer byteBuffer = $this$removePrefixes.slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slice(...)");
        return byteBuffer;
    }

    public static final boolean isAnnexB(@NotNull ByteBuffer $this$isAnnexB) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnnexB, (String)"<this>");
        return ByteBufferExtensionsKt.getStartCodeSize($this$isAnnexB) != 0;
    }

    public static final boolean isAvcc(@NotNull ByteBuffer $this$isAvcc) {
        Intrinsics.checkNotNullParameter((Object)$this$isAvcc, (String)"<this>");
        int size2 = $this$isAvcc.getInt(0);
        return size2 == $this$isAvcc.remaining() - 4;
    }
}

