/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.buffer;

import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/buffer/AVCCBufferWriter;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "isAnnexB", "", "isAvcc", "size", "", "getSize", "()I", "computeSize", "write", "", "output", "core_release"})
public final class AVCCBufferWriter
extends ByteBufferWriter {
    @NotNull
    private final ByteBuffer buffer;
    private final boolean isAvcc;
    private final boolean isAnnexB;
    private final int size;

    public AVCCBufferWriter(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.isAvcc = ByteBufferExtensionsKt.isAvcc(this.buffer);
        this.isAnnexB = ByteBufferExtensionsKt.isAnnexB(this.buffer);
        this.size = this.computeSize();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private final int computeSize() {
        int n;
        if (this.isAvcc) {
            n = this.buffer.remaining();
        } else if (this.isAnnexB) {
            n = this.buffer.remaining() - ByteBufferExtensionsKt.getStartCodeSize(this.buffer) + 4;
        } else {
            throw new IllegalArgumentException("Buffer must be in AVCC or AnnexB format");
        }
        return n;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this.isAvcc) {
            output.put(this.buffer);
        } else if (this.isAnnexB) {
            ByteBuffer noStartCodeBuffer = ByteBufferExtensionsKt.removeStartCode(this.buffer);
            output.putInt(noStartCodeBuffer.remaining());
            output.put(noStartCodeBuffer);
        } else {
            throw new IllegalArgumentException("Buffer must be in AVCC or AnnexB format");
        }
    }
}

