/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.sources.camera;

import android.content.Context;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.orientation.AbstractSourceOrientationProvider;
import io.github.thibaultbee.streampack.internal.orientation.ISourceOrientationListener;
import io.github.thibaultbee.streampack.internal.sources.IVideoSource;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraHelper;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraSource;
import io.github.thibaultbee.streampack.internal.utils.av.video.DynamicRangeProfile;
import io.github.thibaultbee.streampack.internal.utils.extensions.ContextExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.extensions.SizeExtensionsKt;
import io.github.thibaultbee.streampack.utils.CameraSettings;
import io.github.thibaultbee.streampack.utils.ContextExtensionsForCameraKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001?B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u0002002\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000200H\u0016J\"\u00109\u001a\u0002002\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010:\u001a\u00020\u0019H\u0087@\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u000200H\u0016J\u0006\u0010=\u001a\u000200J\b\u0010>\u001a\u000200H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0013\"\u0004\b&\u0010\u0015R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006@"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/camera/CameraSource;", "Lio/github/thibaultbee/streampack/internal/sources/IVideoSource;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "value", "", "cameraId", "getCameraId", "()Ljava/lang/String;", "setCameraId", "(Ljava/lang/String;)V", "dynamicRangeProfile", "Lio/github/thibaultbee/streampack/internal/utils/av/video/DynamicRangeProfile;", "encoderSurface", "Landroid/view/Surface;", "getEncoderSurface", "()Landroid/view/Surface;", "setEncoderSurface", "(Landroid/view/Surface;)V", "fps", "", "hasFrames", "", "getHasFrames", "()Z", "hasSurface", "getHasSurface", "isPreviewing", "isStreaming", "orientationProvider", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraSource$CameraOrientationProvider;", "getOrientationProvider", "()Lio/github/thibaultbee/streampack/internal/sources/camera/CameraSource$CameraOrientationProvider;", "previewSurface", "getPreviewSurface", "setPreviewSurface", "settings", "Lio/github/thibaultbee/streampack/utils/CameraSettings;", "getSettings", "()Lio/github/thibaultbee/streampack/utils/CameraSettings;", "timestampOffset", "", "getTimestampOffset", "()J", "checkStream", "", "configure", "config", "Lio/github/thibaultbee/streampack/data/VideoConfig;", "getFrame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "buffer", "Ljava/nio/ByteBuffer;", "release", "startPreview", "restartStream", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startStream", "stopPreview", "stopStream", "CameraOrientationProvider", "core_release"})
@SourceDebugExtension(value={"SMAP\nCameraSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraSource.kt\nio/github/thibaultbee/streampack/internal/sources/camera/CameraSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class CameraSource
implements IVideoSource {
    @NotNull
    private final Context context;
    @Nullable
    private Surface previewSurface;
    @Nullable
    private Surface encoderSurface;
    @NotNull
    private String cameraId;
    @NotNull
    private CameraController cameraController;
    @NotNull
    private final CameraSettings settings;
    private final long timestampOffset;
    private final boolean hasSurface;
    private final boolean hasFrames;
    @NotNull
    private final CameraOrientationProvider orientationProvider;
    private int fps;
    @NotNull
    private DynamicRangeProfile dynamicRangeProfile;
    private boolean isStreaming;
    private boolean isPreviewing;

    public CameraSource(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.cameraId = ContextExtensionsForCameraKt.getDefaultCameraId(this.context);
        this.cameraController = new CameraController(this.context, null, 2, null);
        this.settings = new CameraSettings(this.context, this.cameraController);
        this.timestampOffset = CameraHelper.INSTANCE.getTimeOffsetToMonoClock(this.context, this.getCameraId());
        this.hasSurface = true;
        this.orientationProvider = new CameraOrientationProvider(this.context, this.getCameraId());
        this.fps = 30;
        this.dynamicRangeProfile = DynamicRangeProfile.Companion.getSdr();
    }

    @Nullable
    public final Surface getPreviewSurface() {
        return this.previewSurface;
    }

    public final void setPreviewSurface(@Nullable Surface surface) {
        this.previewSurface = surface;
    }

    @Override
    @Nullable
    public Surface getEncoderSurface() {
        return this.encoderSurface;
    }

    @Override
    public void setEncoderSurface(@Nullable Surface surface) {
        this.encoderSurface = surface;
    }

    @NotNull
    public final String getCameraId() {
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            string2 = this.cameraId;
        }
        return string2;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public final void setCameraId(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!ContextExtensionsForCameraKt.isFrameRateSupported(this.context, value, this.fps)) {
            throw new UnsupportedOperationException("Camera " + value + " does not support " + this.fps + " fps");
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value, null){
            int label;
            final /* synthetic */ CameraSource this$0;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean restartStream = CameraSource.access$isStreaming$p(this.this$0);
                        boolean restartPreview = CameraSource.access$isPreviewing$p(this.this$0);
                        this.this$0.stopPreview();
                        CameraSource.access$setCameraId$p(this.this$0, this.$value);
                        if (!restartPreview) return Unit.INSTANCE;
                        this.label = 1;
                        Object object3 = this.this$0.startPreview(this.$value, restartStream, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public final CameraSettings getSettings() {
        return this.settings;
    }

    @Override
    public long getTimestampOffset() {
        return this.timestampOffset;
    }

    @Override
    public boolean getHasSurface() {
        return this.hasSurface;
    }

    @Override
    public boolean getHasFrames() {
        return this.hasFrames;
    }

    @Override
    @NotNull
    public CameraOrientationProvider getOrientationProvider() {
        return this.orientationProvider;
    }

    @Override
    @NotNull
    public Frame getFrame(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        throw new UnsupportedOperationException("Camera expects to run in Surface mode");
    }

    @Override
    public void configure(@NotNull VideoConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.fps = config.getFps();
        this.dynamicRangeProfile = config.getDynamicRangeProfile();
    }

    /*
     * Unable to fully structure code
     */
    @RequiresPermission(value="android.permission.CAMERA")
    @Nullable
    public final Object startPreview(@NotNull String var1_1, boolean var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof startPreview.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ CameraSource this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startPreview(null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                targets = new Ref.ObjectRef();
                targets.element = new ArrayList<E>();
                v0 = this.previewSurface;
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-CameraSource$startPreview$2 = false;
                    Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                }
                v1 = this.getEncoderSurface();
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-CameraSource$startPreview$3 = false;
                    Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = cameraId;
                $continuation.L$2 = targets;
                $continuation.Z$0 = restartStream;
                $continuation.label = 1;
                v2 = this.cameraController.startCamera(cameraId, (List)targets.element, this.dynamicRangeProfile.getDynamicRange(), (Continuation<? super Unit>)$continuation);
                if (v2 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl44
            }
            case 1: {
                restartStream = $continuation.Z$0;
                targets = (Ref.ObjectRef)$continuation.L$2;
                cameraId = (String)$continuation.L$1;
                this = (CameraSource)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl44:
                // 2 sources

                targets.element = new ArrayList<E>();
                v3 = this.previewSurface;
                if (v3 != null) {
                    it = v3;
                    $i$a$-let-CameraSource$startPreview$4 = false;
                    Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                }
                if (restartStream) {
                    v4 = this.getEncoderSurface();
                    if (v4 != null) {
                        it = v4;
                        $i$a$-let-CameraSource$startPreview$5 = false;
                        Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                    }
                }
                this.cameraController.startRequestSession(this.fps, (List)targets.element);
                this.isPreviewing = true;
                this.getOrientationProvider().setCameraId(cameraId);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object startPreview$default(CameraSource cameraSource, String string2, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = cameraSource.getCameraId();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return cameraSource.startPreview(string2, bl, (Continuation<? super Unit>)continuation);
    }

    public final void stopPreview() {
        this.isPreviewing = false;
        this.cameraController.stopCamera();
    }

    private final void checkStream() {
        if (!(this.getEncoderSurface() != null)) {
            boolean bl = false;
            String string2 = "encoder surface must not be null";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @Override
    public void startStream() {
        this.checkStream();
        this.cameraController.muteVibrationAndSound();
        Surface surface = this.getEncoderSurface();
        Intrinsics.checkNotNull((Object)surface);
        this.cameraController.addTarget(surface);
        this.isStreaming = true;
    }

    @Override
    public void stopStream() {
        if (this.isStreaming) {
            this.checkStream();
            this.cameraController.unmuteVibrationAndSound();
            this.isStreaming = false;
            Surface surface = this.getEncoderSurface();
            Intrinsics.checkNotNull((Object)surface);
            this.cameraController.removeTarget(surface);
        }
    }

    @Override
    public void release() {
        this.cameraController.release();
    }

    public static final /* synthetic */ boolean access$isStreaming$p(CameraSource $this) {
        return $this.isStreaming;
    }

    public static final /* synthetic */ boolean access$isPreviewing$p(CameraSource $this) {
        return $this.isPreviewing;
    }

    public static final /* synthetic */ void access$setCameraId$p(CameraSource $this, String string2) {
        $this.cameraId = string2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0005H\u0002R$\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/camera/CameraSource$CameraOrientationProvider;", "Lio/github/thibaultbee/streampack/internal/orientation/AbstractSourceOrientationProvider;", "context", "Landroid/content/Context;", "initialCameraId", "", "(Landroid/content/Context;Ljava/lang/String;)V", "value", "cameraId", "getCameraId", "()Ljava/lang/String;", "setCameraId", "(Ljava/lang/String;)V", "isFrontFacingMap", "", "", "mirroredVertically", "getMirroredVertically", "()Z", "orientation", "", "getOrientation", "()I", "getDefaultBufferSize", "Landroid/util/Size;", "size", "getOrientedSize", "isFrontFacing", "core_release"})
    @SourceDebugExtension(value={"SMAP\nCameraSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraSource.kt\nio/github/thibaultbee/streampack/internal/sources/camera/CameraSource$CameraOrientationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1271#2,2:183\n1285#2,4:185\n1855#2,2:189\n*S KotlinDebug\n*F\n+ 1 CameraSource.kt\nio/github/thibaultbee/streampack/internal/sources/camera/CameraSource$CameraOrientationProvider\n*L\n140#1:183,2\n140#1:185,4\n150#1:189,2\n*E\n"})
    public static final class CameraOrientationProvider
    extends AbstractSourceOrientationProvider {
        @NotNull
        private final Context context;
        @NotNull
        private final Map<String, Boolean> isFrontFacingMap;
        @NotNull
        private String cameraId;

        /*
         * WARNING - void declaration
         */
        public CameraOrientationProvider(@NotNull Context context, @NotNull String initialCameraId) {
            void $this$associateWith$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)initialCameraId, (String)"initialCameraId");
            this.context = context;
            Iterable iterable = ContextExtensionsForCameraKt.getCameraList(this.context);
            CameraOrientationProvider cameraOrientationProvider = this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                String string2 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                Integer n = ContextExtensionsForCameraKt.getFacingDirection(this.context, (String)it);
                Boolean bl2 = n != null && n == 0;
                map.put(t, bl2);
            }
            cameraOrientationProvider.isFrontFacingMap = result$iv;
            this.cameraId = initialCameraId;
        }

        @NotNull
        public final String getCameraId() {
            return this.cameraId;
        }

        public final void setCameraId(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (Intrinsics.areEqual((Object)this.cameraId, (Object)value)) {
                return;
            }
            boolean orientationChanged = this.getMirroredVertically() != this.isFrontFacing(value);
            this.cameraId = value;
            if (orientationChanged) {
                Iterable $this$forEach$iv = this.getListeners();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ISourceOrientationListener it = (ISourceOrientationListener)element$iv;
                    boolean bl = false;
                    it.onOrientationChanged();
                }
            }
        }

        @Override
        public int getOrientation() {
            int n;
            switch (ContextExtensionsKt.getDeviceOrientation(this.context)) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 270;
                    break;
                }
                case 2: {
                    n = 180;
                    break;
                }
                case 3: {
                    n = 90;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }

        private final boolean isFrontFacing(String cameraId2) {
            Boolean bl = this.isFrontFacingMap.get(cameraId2);
            return bl != null ? bl : false;
        }

        @Override
        public boolean getMirroredVertically() {
            return this.isFrontFacing(this.cameraId);
        }

        @Override
        @NotNull
        public Size getOrientedSize(@NotNull Size size2) {
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            return ContextExtensionsKt.isDevicePortrait(this.context) ? SizeExtensionsKt.portraitize(size2) : SizeExtensionsKt.landscapize(size2);
        }

        @Override
        @NotNull
        public Size getDefaultBufferSize(@NotNull Size size2) {
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            return new Size(Math.max(size2.getWidth(), size2.getHeight()), Math.min(size2.getWidth(), size2.getHeight()));
        }
    }
}

