/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.ts.packets;

import io.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import io.github.thibaultbee.streampack.internal.muxers.ts.data.ITSElement;
import io.github.thibaultbee.streampack.internal.muxers.ts.data.Service;
import io.github.thibaultbee.streampack.internal.muxers.ts.data.TsServiceInfo;
import io.github.thibaultbee.streampack.internal.muxers.ts.packets.Psi;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dBE\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0018\u001a\u00020\u000eH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cR\u0014\u0010\u0010\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0012\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Sdt;", "Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Psi;", "Lio/github/thibaultbee/streampack/internal/muxers/ts/data/ITSElement;", "listener", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "services", "", "Lio/github/thibaultbee/streampack/internal/muxers/ts/data/Service;", "tsId", "", "originalNetworkId", "versionNumber", "", "packetCount", "", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;Ljava/util/List;SSBI)V", "bitSize", "getBitSize", "()I", "getPacketCount", "setPacketCount", "(I)V", "size", "getSize", "computeBitSize", "toByteBuffer", "Ljava/nio/ByteBuffer;", "write", "", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nSdt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sdt.kt\nio/github/thibaultbee/streampack/internal/muxers/ts/packets/Sdt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1549#2:107\n1620#2,3:108\n1549#2:111\n1620#2,3:112\n1855#2,2:115\n*S KotlinDebug\n*F\n+ 1 Sdt.kt\nio/github/thibaultbee/streampack/internal/muxers/ts/packets/Sdt\n*L\n59#1:107\n59#1:108,3\n77#1:111\n77#1:112,3\n77#1:115,2\n*E\n"})
public final class Sdt
extends Psi
implements ITSElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Service> services;
    private final short originalNetworkId;
    private int packetCount;
    public static final byte TID = 66;
    public static final short PID = 17;

    public Sdt(@Nullable IMuxerListener listener, @NotNull List<Service> services, short tsId, short originalNetworkId, byte versionNumber, int packetCount) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        super(listener, (short)17, (byte)66, true, true, tsId, versionNumber, (byte)0, (byte)0, 384, null);
        this.services = services;
        this.originalNetworkId = originalNetworkId;
        this.packetCount = packetCount;
    }

    public /* synthetic */ Sdt(IMuxerListener iMuxerListener, List list, short s, short s2, byte by, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            iMuxerListener = null;
        }
        if ((n2 & 8) != 0) {
            s2 = (short)-255;
        }
        if ((n2 & 0x10) != 0) {
            by = 0;
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        this(iMuxerListener, list, s, s2, by, n);
    }

    public final int getPacketCount() {
        return this.packetCount;
    }

    public final void setPacketCount(int n) {
        this.packetCount = n;
    }

    @Override
    public int getBitSize() {
        return this.computeBitSize();
    }

    @Override
    public int getSize() {
        return this.getBitSize() / 8;
    }

    /*
     * WARNING - void declaration
     */
    private final int computeBitSize() {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int nBits = 24;
        Iterable iterable = this.services;
        int n = nBits;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Service service = (Service)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(80 + (it.getInfo().getProviderName().length() + it.getInfo().getName().length()) * 8);
        }
        collection = (List)destination$iv$iv;
        nBits = n + CollectionsKt.sumOfInt((Iterable)collection);
        return nBits;
    }

    public final void write() {
        if (!((Collection)this.services).isEmpty()) {
            this.write(this.toByteBuffer());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ByteBuffer toByteBuffer() {
        void $this$mapTo$iv$iv;
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize());
        buffer.putShort(this.originalNetworkId);
        Intrinsics.checkNotNull((Object)buffer);
        ByteBufferExtensionsKt.put(buffer, 255);
        Iterable $this$map$iv = this.services;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Service service = (Service)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getInfo());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TsServiceInfo it = (TsServiceInfo)element$iv;
            boolean bl = false;
            buffer.putShort(it.getId());
            ByteBufferExtensionsKt.put(buffer, 252);
            int serviceDescriptorLength = 3 + it.getProviderName().length() + it.getName().length();
            int descriptorsLoopLength = 2 + serviceDescriptorLength;
            ByteBufferExtensionsKt.putShort(buffer, 0x8000 | descriptorsLoopLength);
            buffer.put((byte)72);
            ByteBufferExtensionsKt.put(buffer, serviceDescriptorLength);
            buffer.put(it.getType().getValue());
            ByteBufferExtensionsKt.put(buffer, it.getProviderName().length());
            ByteBufferExtensionsKt.putString(buffer, it.getProviderName());
            ByteBufferExtensionsKt.put(buffer, it.getName().length());
            ByteBufferExtensionsKt.putString(buffer, it.getName());
        }
        buffer.rewind();
        return buffer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Sdt$Companion;", "", "()V", "PID", "", "TID", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

