/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.ts.packets;

import io.github.thibaultbee.streampack.internal.muxers.ts.data.ITSElement;
import io.github.thibaultbee.streampack.internal.utils.extensions.BitOperationExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u009b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0015J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u0006H\u0002J\b\u0010*\u001a\u00020'H\u0016R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0012\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0019R\u0014\u0010\u001f\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019R\u000e\u0010!\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0014\u0010\"\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/PesHeader;", "Lio/github/thibaultbee/streampack/internal/muxers/ts/data/ITSElement;", "streamId", "", "payloadLength", "esScramblingControl", "", "esPriority", "", "dataAlignmentIndicator", "copyright", "originalOrCopy", "pts", "", "dts", "esClockReference", "esRate", "", "dsmTrickMode", "additionalCopyInfo", "crc", "(SSBZZZZLjava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Integer;Ljava/lang/Byte;Ljava/lang/Byte;Ljava/lang/Short;)V", "Ljava/lang/Byte;", "bitSize", "getBitSize", "()I", "Ljava/lang/Short;", "Ljava/lang/Long;", "Ljava/lang/Integer;", "pesHeaderDataBitLength", "getPesHeaderDataBitLength", "pesHeaderDataLength", "getPesHeaderDataLength", "pesPacketLength", "size", "getSize", "addTimestamp", "", "buffer", "Ljava/nio/ByteBuffer;", "timestamp", "fourBits", "toByteBuffer", "core_release"})
@SourceDebugExtension(value={"SMAP\nPesHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PesHeader.kt\nio/github/thibaultbee/streampack/internal/muxers/ts/packets/PesHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class PesHeader
implements ITSElement {
    private final short streamId;
    private final byte esScramblingControl;
    private final boolean esPriority;
    private final boolean dataAlignmentIndicator;
    private final boolean copyright;
    private final boolean originalOrCopy;
    @Nullable
    private final Long pts;
    @Nullable
    private final Long dts;
    @Nullable
    private final Long esClockReference;
    @Nullable
    private final Integer esRate;
    @Nullable
    private final Byte dsmTrickMode;
    @Nullable
    private final Byte additionalCopyInfo;
    @Nullable
    private final Short crc;
    private final int size;
    private int pesPacketLength;

    public PesHeader(short streamId, short payloadLength, byte esScramblingControl, boolean esPriority, boolean dataAlignmentIndicator, boolean copyright, boolean originalOrCopy, @Nullable Long pts, @Nullable Long dts, @Nullable Long esClockReference, @Nullable Integer esRate, @Nullable Byte dsmTrickMode, @Nullable Byte additionalCopyInfo, @Nullable Short crc) {
        this.streamId = streamId;
        this.esScramblingControl = esScramblingControl;
        this.esPriority = esPriority;
        this.dataAlignmentIndicator = dataAlignmentIndicator;
        this.copyright = copyright;
        this.originalOrCopy = originalOrCopy;
        this.pts = pts;
        this.dts = dts;
        this.esClockReference = esClockReference;
        this.esRate = esRate;
        this.dsmTrickMode = dsmTrickMode;
        this.additionalCopyInfo = additionalCopyInfo;
        this.crc = crc;
        Long l = this.dts;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            Long l2 = this.pts;
            if (l2 == null) {
                boolean bl2 = false;
                String string2 = "If dts is not null, pts must be not null ";
                throw new IllegalArgumentException(string2.toString());
            }
            ((Number)l2).longValue();
        }
        this.size = this.getBitSize() / 8;
        this.pesPacketLength = payloadLength + this.getPesHeaderDataLength() + 3;
    }

    public /* synthetic */ PesHeader(short s, short s2, byte by, boolean bl, boolean bl2, boolean bl3, boolean bl4, Long l, Long l2, Long l3, Integer n, Byte by2, Byte by3, Short s3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            by = 0;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl4 = true;
        }
        if ((n2 & 0x80) != 0) {
            l = null;
        }
        if ((n2 & 0x100) != 0) {
            l2 = null;
        }
        if ((n2 & 0x200) != 0) {
            l3 = null;
        }
        if ((n2 & 0x400) != 0) {
            n = null;
        }
        if ((n2 & 0x800) != 0) {
            by2 = null;
        }
        if ((n2 & 0x1000) != 0) {
            by3 = null;
        }
        if ((n2 & 0x2000) != 0) {
            s3 = null;
        }
        this(s, s2, by, bl, bl2, bl3, bl4, l, l2, l3, n, by2, by3, s3);
    }

    @Override
    public int getBitSize() {
        return 72 + this.getPesHeaderDataBitLength();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private final int getPesHeaderDataBitLength() {
        int nBits;
        block6: {
            long it;
            nBits = 0;
            Long l = this.pts;
            if (l != null) {
                it = ((Number)l).longValue();
                boolean bl = false;
                nBits += 40;
            }
            Long l2 = this.dts;
            if (l2 != null) {
                it = ((Number)l2).longValue();
                boolean bl = false;
                nBits += 40;
            }
            Long l3 = this.esClockReference;
            if (l3 != null) {
                it = ((Number)l3).longValue();
                boolean bl = false;
                nBits += 42;
            }
            Integer n = this.esRate;
            if (n != null) {
                int it2 = ((Number)n).intValue();
                boolean bl = false;
                nBits += 22;
            }
            Byte by = this.dsmTrickMode;
            if (by != null) {
                byte it3 = ((Number)by).byteValue();
                boolean bl = false;
                nBits += 8;
            }
            Byte by2 = this.additionalCopyInfo;
            if (by2 != null) {
                byte it4 = ((Number)by2).byteValue();
                boolean bl = false;
                nBits += 7;
            }
            Short s = this.crc;
            if (s == null) break block6;
            short it5 = ((Number)s).shortValue();
            boolean bl = false;
            nBits += 16;
        }
        return nBits;
    }

    private final int getPesHeaderDataLength() {
        return this.getPesHeaderDataBitLength() / 8;
    }

    @Override
    @NotNull
    public ByteBuffer toByteBuffer() {
        NotImplementedError notImplementedError;
        NotImplementedError notImplementedError2;
        NotImplementedError notImplementedError3;
        NotImplementedError notImplementedError4;
        NotImplementedError notImplementedError5;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        long it;
        int n8;
        int n9;
        ByteBuffer byteBuffer;
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize());
        buffer.putShort((short)0);
        buffer.put((byte)1);
        Intrinsics.checkNotNull((Object)buffer);
        ByteBufferExtensionsKt.put(buffer, this.streamId);
        if (this.pesPacketLength > 65535) {
            this.pesPacketLength = 0;
        }
        ByteBufferExtensionsKt.putShort(buffer, this.pesPacketLength);
        ByteBufferExtensionsKt.put(buffer, 0x80 | BitOperationExtensionsKt.shl((byte)(this.esScramblingControl & 3), 4) | BitOperationExtensionsKt.shl(this.esPriority, 3) | BitOperationExtensionsKt.shl(this.dataAlignmentIndicator, 2) | BitOperationExtensionsKt.shl(this.copyright, 1) | BitOperationExtensionsKt.toInt(this.originalOrCopy));
        ByteBuffer byteBuffer2 = buffer;
        Long l = this.pts;
        if (l != null) {
            long l2 = ((Number)l).longValue();
            byteBuffer = byteBuffer2;
            boolean bl = false;
            n9 = 1;
            byteBuffer2 = byteBuffer;
            n8 = n9;
        } else {
            n8 = 0;
        }
        int n10 = n8 << 7;
        Long l3 = this.dts;
        if (l3 != null) {
            it = ((Number)l3).longValue();
            n9 = n10;
            byteBuffer = byteBuffer2;
            boolean bl = false;
            n7 = 1;
            byteBuffer2 = byteBuffer;
            n10 = n9;
            n6 = n7;
        } else {
            n6 = 0;
        }
        int n11 = n10 | n6 << 6;
        Long l4 = this.esClockReference;
        if (l4 != null) {
            it = ((Number)l4).longValue();
            n9 = n11;
            byteBuffer = byteBuffer2;
            boolean bl2 = false;
            n7 = 1;
            byteBuffer2 = byteBuffer;
            n11 = n9;
            n5 = n7;
        } else {
            n5 = 0;
        }
        int n12 = n11 | n5 << 5;
        Integer n13 = this.esRate;
        if (n13 != null) {
            int it2 = ((Number)n13).intValue();
            n9 = n12;
            byteBuffer = byteBuffer2;
            boolean bl = false;
            n7 = 1;
            byteBuffer2 = byteBuffer;
            n12 = n9;
            n4 = n7;
        } else {
            n4 = 0;
        }
        int n14 = n12 | n4 << 4;
        Byte by = this.dsmTrickMode;
        if (by != null) {
            byte it3 = ((Number)by).byteValue();
            n9 = n14;
            byteBuffer = byteBuffer2;
            boolean bl = false;
            n7 = 1;
            byteBuffer2 = byteBuffer;
            n14 = n9;
            n3 = n7;
        } else {
            n3 = 0;
        }
        int n15 = n14 | n3 << 3;
        Byte by2 = this.additionalCopyInfo;
        if (by2 != null) {
            byte it4 = ((Number)by2).byteValue();
            n9 = n15;
            byteBuffer = byteBuffer2;
            boolean bl = false;
            n7 = 1;
            byteBuffer2 = byteBuffer;
            n15 = n9;
            n2 = n7;
        } else {
            n2 = 0;
        }
        int n16 = n15 | n2 << 2;
        Short s = this.crc;
        if (s != null) {
            short it5 = ((Number)s).shortValue();
            n9 = n16;
            byteBuffer = byteBuffer2;
            boolean bl = false;
            n7 = 1;
            byteBuffer2 = byteBuffer;
            n16 = n9;
            n = n7;
        } else {
            n = 0;
        }
        ByteBufferExtensionsKt.put(byteBuffer2, n16 | n << 1 | 0);
        Long l5 = this.esClockReference;
        if (l5 != null) {
            long it6 = ((Number)l5).longValue();
            boolean bl = false;
            notImplementedError5 = new NotImplementedError("esClockReference not implemented yet");
        } else {
            notImplementedError5 = null;
        }
        Integer n17 = this.esRate;
        if (n17 != null) {
            int it7 = ((Number)n17).intValue();
            boolean bl = false;
            notImplementedError4 = new NotImplementedError("esRate not implemented yet");
        } else {
            notImplementedError4 = null;
        }
        Byte by3 = this.dsmTrickMode;
        if (by3 != null) {
            byte it8 = ((Number)by3).byteValue();
            boolean bl = false;
            notImplementedError3 = new NotImplementedError("dsmTrickMode not implemented yet");
        } else {
            notImplementedError3 = null;
        }
        Byte by4 = this.additionalCopyInfo;
        if (by4 != null) {
            byte it9 = ((Number)by4).byteValue();
            boolean bl = false;
            notImplementedError2 = new NotImplementedError("additionalCopyInfo not implemented yet");
        } else {
            notImplementedError2 = null;
        }
        Short s2 = this.crc;
        if (s2 != null) {
            short it10 = ((Number)s2).shortValue();
            boolean bl = false;
            notImplementedError = new NotImplementedError("crc not implemented yet");
        } else {
            notImplementedError = null;
        }
        buffer.put((byte)this.getPesHeaderDataLength());
        Long l6 = this.pts;
        if (l6 != null) {
            int n18;
            long it11 = ((Number)l6).longValue();
            boolean bl = false;
            PesHeader pesHeader = this;
            ByteBuffer byteBuffer3 = buffer;
            long l7 = it11;
            Long l8 = this.dts;
            if (l8 != null) {
                long bl2 = ((Number)l8).longValue();
                long l9 = l7;
                ByteBuffer byteBuffer4 = byteBuffer3;
                PesHeader pesHeader2 = pesHeader;
                boolean bl3 = false;
                int n19 = 3;
                pesHeader = pesHeader2;
                byteBuffer3 = byteBuffer4;
                l7 = l9;
                n18 = n19;
            } else {
                n18 = 2;
            }
            pesHeader.addTimestamp(byteBuffer3, l7, (byte)n18);
        }
        Long l10 = this.dts;
        if (l10 != null) {
            long it12 = ((Number)l10).longValue();
            boolean bl = false;
            this.addTimestamp(buffer, it12, (byte)1);
        }
        buffer.rewind();
        return buffer;
    }

    private final void addTimestamp(ByteBuffer buffer, long timestamp, byte fourBits) {
        long pts = (long)27000000 * timestamp / (long)1000000 / (long)300 % (long)Math.pow(2.0, 33);
        ByteBufferExtensionsKt.put(buffer, (byte)(fourBits & 0xF) << 4 | (int)(pts >> 29 & 0xEL) | 1);
        ByteBufferExtensionsKt.putShort(buffer, pts >> 14 & 0xFFFEL | 1L);
        ByteBufferExtensionsKt.putShort(buffer, pts << 1 & 0xFFFEL | 1L);
    }
}

