/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.mp4.boxes;

import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.FullBox;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TimeToSampleBox;", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/FullBox;", "decodingTimes", "", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TimeToSampleBox$Entry;", "(Ljava/util/List;)V", "size", "", "getSize", "()I", "write", "", "output", "Ljava/nio/ByteBuffer;", "Companion", "Entry", "core_release"})
@SourceDebugExtension(value={"SMAP\nTimeToSampleBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeToSampleBox.kt\nio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TimeToSampleBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1855#2,2:83\n*S KotlinDebug\n*F\n+ 1 TimeToSampleBox.kt\nio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TimeToSampleBox\n*L\n29#1:83,2\n*E\n"})
public final class TimeToSampleBox
extends FullBox {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Entry> decodingTimes;
    private final int size;

    public TimeToSampleBox(@NotNull List<Entry> decodingTimes) {
        Intrinsics.checkNotNullParameter(decodingTimes, (String)"decodingTimes");
        super("stts", (byte)0, 0, false, 8, null);
        this.decodingTimes = decodingTimes;
        this.size = super.getSize() + 4 + 8 * this.decodingTimes.size();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        output.putInt(this.decodingTimes.size());
        Iterable $this$forEach$iv = this.decodingTimes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entry it = (Entry)element$iv;
            boolean bl = false;
            it.write(output);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TimeToSampleBox$Companion;", "", "()V", "fromDts", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TimeToSampleBox;", "dtsList", "", "", "hasUnknownLastDelta", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeToSampleBox fromDts(@NotNull List<Long> dtsList, boolean hasUnknownLastDelta) {
            Intrinsics.checkNotNullParameter(dtsList, (String)"dtsList");
            if (dtsList.isEmpty()) {
                throw new IllegalArgumentException("dtsList must not be empty");
            }
            if (dtsList.size() == 1) {
                return new TimeToSampleBox(CollectionsKt.listOf((Object)new Entry(1, 0)));
            }
            List compactedEntries = new ArrayList();
            int count = 1;
            int duration = 0;
            int n = dtsList.size();
            for (int i = 1; i < n; ++i) {
                int delta = (int)(((Number)dtsList.get(i)).longValue() - ((Number)dtsList.get(i - 1)).longValue());
                if (duration == delta) {
                    ++count;
                    continue;
                }
                if (i != 1) {
                    compactedEntries.add(new Entry(count, duration));
                }
                count = 1;
                duration = delta;
            }
            compactedEntries.add(new Entry(count, duration));
            if (hasUnknownLastDelta) {
                compactedEntries.add(new Entry(1, 0));
            }
            return new TimeToSampleBox(compactedEntries);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\n\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TimeToSampleBox$Entry;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "count", "", "delta", "(II)V", "getDelta", "()I", "size", "getSize", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write", "", "output", "Ljava/nio/ByteBuffer;", "core_release"})
    public static final class Entry
    extends ByteBufferWriter {
        private final int count;
        private final int delta;
        private final int size;

        public Entry(int count, int delta) {
            this.count = count;
            this.delta = delta;
            this.size = 8;
        }

        public final int getDelta() {
            return this.delta;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void write(@NotNull ByteBuffer output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            output.putInt(this.count);
            output.putInt(this.delta);
        }

        private final int component1() {
            return this.count;
        }

        public final int component2() {
            return this.delta;
        }

        @NotNull
        public final Entry copy(int count, int delta) {
            return new Entry(count, delta);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = entry.count;
            }
            if ((n3 & 2) != 0) {
                n2 = entry.delta;
            }
            return entry.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Entry(count=" + this.count + ", delta=" + this.delta + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.count);
            result = result * 31 + Integer.hashCode(this.delta);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (this.count != entry.count) {
                return false;
            }
            return this.delta == entry.delta;
        }
    }
}

