/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.tags;

import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.internal.muxers.flv.amf.containers.AmfContainer;
import io.github.thibaultbee.streampack.internal.muxers.flv.amf.containers.AmfEcmaArray;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.AudioMetadata;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.FlvTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.Metadata;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.TagType;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.VideoMetadata;
import io.github.thibaultbee.streampack.internal.orientation.ISourceOrientationProvider;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0016"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/OnMetadata;", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/FlvTag;", "streams", "", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/Metadata;", "duration", "", "(Ljava/util/List;D)V", "amfContainer", "Lio/github/thibaultbee/streampack/internal/muxers/flv/amf/containers/AmfContainer;", "bodySize", "", "getBodySize", "()I", "tagHeaderSize", "getTagHeaderSize", "writeBody", "", "output", "Ljava/nio/ByteBuffer;", "writeTagHeader", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nOnMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnMetadata.kt\nio/github/thibaultbee/streampack/internal/muxers/flv/tags/OnMetadata\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1855#2,2:175\n*S KotlinDebug\n*F\n+ 1 OnMetadata.kt\nio/github/thibaultbee/streampack/internal/muxers/flv/tags/OnMetadata\n*L\n43#1:175,2\n*E\n"})
public final class OnMetadata
extends FlvTag {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AmfContainer amfContainer;

    public OnMetadata(@NotNull List<? extends Metadata> streams, double duration) {
        Intrinsics.checkNotNullParameter(streams, (String)"streams");
        super(0L, TagType.SCRIPT, false, 4, null);
        this.amfContainer = new AmfContainer();
        this.amfContainer.add("onMetaData");
        AmfEcmaArray ecmaArray = new AmfEcmaArray();
        ecmaArray.add("duration", duration);
        Iterable $this$forEach$iv = streams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Metadata it = (Metadata)element$iv;
            boolean bl = false;
            Metadata metadata = it;
            if (metadata instanceof AudioMetadata) {
                ecmaArray.add("audiocodecid", ((AudioMetadata)it).getCodecID().getValue());
                ecmaArray.add("audiodatarate", (double)it.getDataRate() / (double)1000);
                ecmaArray.add("audiosamplerate", ((AudioMetadata)it).getSampleRate());
                ecmaArray.add("audiosamplesize", ((AudioMetadata)it).getSampleSize());
                ecmaArray.add("stereo", ((AudioMetadata)it).isStereo());
                continue;
            }
            if (!(metadata instanceof VideoMetadata)) continue;
            Integer n = ((VideoMetadata)it).getCodecID();
            if (n != null) {
                int codecId = ((Number)n).intValue();
                boolean bl2 = false;
                ecmaArray.add("videocodecid", codecId);
            }
            ecmaArray.add("videodatarate", (double)it.getDataRate() / (double)1000);
            ecmaArray.add("width", ((VideoMetadata)it).getWidth());
            ecmaArray.add("height", ((VideoMetadata)it).getHeight());
            ecmaArray.add("framerate", ((VideoMetadata)it).getFrameRate());
        }
        this.amfContainer.add(ecmaArray);
    }

    public /* synthetic */ OnMetadata(List list, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        this(list, d);
    }

    @Override
    protected void writeTagHeader(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
    }

    @Override
    protected int getTagHeaderSize() {
        return 0;
    }

    @Override
    protected void writeBody(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.amfContainer.encode(output);
    }

    @Override
    protected int getBodySize() {
        return this.amfContainer.getSize();
    }

    @kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/OnMetadata$Companion;", "", "()V", "fromConfigs", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/OnMetadata;", "configs", "", "Lio/github/thibaultbee/streampack/data/Config;", "sourceOrientationProvider", "Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "core_release"})
    @SourceDebugExtension(value={"SMAP\nOnMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnMetadata.kt\nio/github/thibaultbee/streampack/internal/muxers/flv/tags/OnMetadata$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1549#2:175\n1620#2,3:176\n*S KotlinDebug\n*F\n+ 1 OnMetadata.kt\nio/github/thibaultbee/streampack/internal/muxers/flv/tags/OnMetadata$Companion\n*L\n99#1:175\n99#1:176,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final OnMetadata fromConfigs(@NotNull List<? extends Config> configs, @Nullable ISourceOrientationProvider sourceOrientationProvider) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(configs, (String)"configs");
            Iterable $this$map$iv = configs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Config config = (Config)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Metadata.Companion.fromConfig((Config)it, sourceOrientationProvider));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            double d = 0.0;
            List list = (List)destination$iv$iv;
            return new OnMetadata(list, d, n, defaultConstructorMarker);
        }

        public static /* synthetic */ OnMetadata fromConfigs$default(Companion companion, List list, ISourceOrientationProvider iSourceOrientationProvider, int n, Object object) {
            if ((n & 2) != 0) {
                iSourceOrientationProvider = null;
            }
            return companion.fromConfigs(list, iSourceOrientationProvider);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

