/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.encoders;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Range;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecHelper;
import io.github.thibaultbee.streampack.internal.utils.extensions.StringExtensionsKt;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002%&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0006J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0016J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\t\u001a\u00020\u0006J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00102\u0006\u0010\t\u001a\u00020\u0006J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00102\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\t\u001a\u00020\u0006J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\f\u001a\u00020\u0006J\u0016\u0010\u001d\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006J\u001e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u000eJ\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u000eJ(\u0010#\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper;", "", "()V", "codecList", "Landroid/media/MediaCodecList;", "findEncoder", "", "format", "Landroid/media/MediaFormat;", "mimeType", "getCodecCapabilities", "Landroid/media/MediaCodecInfo$CodecCapabilities;", "name", "getCodecInfo", "Landroid/media/MediaCodecInfo;", "getEncodersName", "", "filter", "Lkotlin/Function1;", "", "getEncodersType", "getMaxLevel", "", "profile", "getNamesForType", "getProfileLevel", "Landroid/media/MediaCodecInfo$CodecProfileLevel;", "getProfiles", "getTypesForName", "isFeatureSupported", "feature", "isFormatSupported", "isHardwareAccelerated", "codecInfo", "isSoftwareOnly", "secureMediaFormatAction", "action", "Audio", "Video", "core_release"})
@SourceDebugExtension(value={"SMAP\nMediaCodecHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaCodecHelper.kt\nio/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,567:1\n1#2:568\n3792#3:569\n4307#3,2:570\n3792#3:583\n4307#3,2:584\n12474#3,2:588\n3792#3:593\n4307#3,2:594\n12474#3,2:598\n1109#3,2:603\n1360#4:572\n1446#4,5:573\n766#4:578\n857#4,2:579\n1855#4,2:581\n766#4:586\n857#4:587\n858#4:590\n1855#4,2:591\n766#4:596\n857#4:597\n858#4:600\n1855#4,2:601\n1549#4:605\n1620#4,3:606\n1549#4:609\n1620#4,3:610\n766#4:613\n857#4,2:614\n766#4:616\n857#4,2:617\n*S KotlinDebug\n*F\n+ 1 MediaCodecHelper.kt\nio/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper\n*L\n88#1:569\n88#1:570,2\n106#1:583\n106#1:584,2\n107#1:588,2\n124#1:593\n124#1:594,2\n125#1:598,2\n149#1:603,2\n89#1:572\n89#1:573,5\n90#1:578\n90#1:579,2\n92#1:581,2\n107#1:586\n107#1:587\n107#1:590\n109#1:591,2\n125#1:596\n125#1:597\n125#1:600\n127#1:601,2\n244#1:605\n244#1:606,3\n257#1:609\n257#1:610,3\n271#1:613\n271#1:614,2\n289#1:616\n289#1:617,2\n*E\n"})
public final class MediaCodecHelper {
    @NotNull
    public static final MediaCodecHelper INSTANCE = new MediaCodecHelper();
    @NotNull
    private static final MediaCodecList codecList = new MediaCodecList(0);

    private MediaCodecHelper() {
    }

    private final Object secureMediaFormatAction(MediaFormat format, Function1<? super MediaFormat, ? extends Object> action) {
        Object result;
        block4: {
            Integer n;
            try {
                n = format.getInteger("frame-rate");
            }
            catch (Exception e) {
                n = null;
            }
            Integer frameRate = n;
            if (Build.VERSION.SDK_INT == 21) {
                format.setString("frame-rate", null);
            }
            result = action.invoke((Object)format);
            if (Build.VERSION.SDK_INT != 21) break block4;
            Integer n2 = frameRate;
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl = false;
                format.setInteger("frame-rate", it);
            }
        }
        return result;
    }

    @NotNull
    public final String findEncoder(@NotNull MediaFormat format) {
        String encoderName2;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string2 = encoderName2 = (String)this.secureMediaFormatAction(format, (Function1<? super MediaFormat, ? extends Object>)((Function1)new Function1<MediaFormat, Object>(format){
            final /* synthetic */ MediaFormat $format;
            {
                this.$format = $format;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull MediaFormat it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MediaCodecHelper.access$getCodecList$p().findEncoderForFormat(this.$format);
            }
        }));
        if (string2 == null) {
            throw new InvalidParameterException("Failed to create codec for: " + format);
        }
        return string2;
    }

    @NotNull
    public final String findEncoder(@NotNull String mimeType) {
        MediaFormat mediaFormat;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        MediaFormat $this$findEncoder_u24lambda_u241 = mediaFormat = new MediaFormat();
        boolean bl = false;
        $this$findEncoder_u24lambda_u241.setString("mime", mimeType);
        MediaFormat format = mediaFormat;
        return this.findEncoder(format);
    }

    private final List<String> getEncodersType(Function1<? super String, Boolean> filter) {
        Object it;
        Object $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        List encoders = new ArrayList();
        MediaCodecInfo[] mediaCodecInfoArray = codecList.getCodecInfos();
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"getCodecInfos(...)");
        Object $this$filter$iv = mediaCodecInfoArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            MediaCodecInfo it2 = (MediaCodecInfo)element$iv$iv;
            boolean bl = false;
            if (!it2.isEncoder()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object t : $this$flatMapTo$iv$iv) {
            it = (MediaCodecInfo)t;
            boolean bl = false;
            String[] stringArray = it.getSupportedTypes();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getSupportedTypes(...)");
            Iterable list$iv$iv = ArraysKt.toList((Object[])stringArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (String)t;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!((Boolean)filter.invoke(it)).booleanValue()) continue;
            destination$iv$iv.add(t);
        }
        Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it3 = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it3);
            encoders.add(it3);
        }
        return encoders;
    }

    private final List<String> getEncodersName(Function1<? super String, Boolean> filter) {
        Object $this$filterTo$iv$iv;
        List encoders = new ArrayList();
        MediaCodecInfo[] mediaCodecInfoArray = codecList.getCodecInfos();
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"getCodecInfos(...)");
        Object $this$filter$iv = mediaCodecInfoArray;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            MediaCodecInfo it = (MediaCodecInfo)element$iv$iv;
            boolean bl = false;
            if (!it.isEncoder()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            block4: {
                element$iv$iv = iterator.next();
                MediaCodecInfo it = (MediaCodecInfo)element$iv$iv;
                boolean bl2 = false;
                String[] stringArray = it.getSupportedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getSupportedTypes(...)");
                Object[] $this$any$iv = stringArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String type = (String)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)type);
                    if (!((Boolean)filter.invoke((Object)type)).booleanValue()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaCodecInfo it = (MediaCodecInfo)element$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            encoders.add(string2);
        }
        return encoders;
    }

    @NotNull
    public final List<String> getNamesForType(@NotNull String mimeType) {
        Object $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        List encoders = new ArrayList();
        MediaCodecInfo[] mediaCodecInfoArray = codecList.getCodecInfos();
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"getCodecInfos(...)");
        Object $this$filter$iv = mediaCodecInfoArray;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            MediaCodecInfo it = (MediaCodecInfo)element$iv$iv;
            boolean bl = false;
            if (!it.isEncoder()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            block4: {
                element$iv$iv = iterator.next();
                MediaCodecInfo it = (MediaCodecInfo)element$iv$iv;
                boolean bl2 = false;
                String[] stringArray = it.getSupportedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getSupportedTypes(...)");
                Object[] $this$any$iv = stringArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String type = (String)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)type, (Object)mimeType)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaCodecInfo it = (MediaCodecInfo)element$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            encoders.add(string2);
        }
        return encoders;
    }

    @NotNull
    public final List<String> getTypesForName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = this.getCodecInfo(name).getSupportedTypes();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getSupportedTypes(...)");
        return ArraysKt.toList((Object[])stringArray);
    }

    @NotNull
    public final MediaCodecInfo getCodecInfo(@NotNull String name) {
        Object element$iv2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            MediaCodecInfo[] mediaCodecInfoArray = codecList.getCodecInfos();
            Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"getCodecInfos(...)");
            Object[] $this$first$iv = mediaCodecInfoArray;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MediaCodecInfo it = (MediaCodecInfo)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) {
                    continue;
                }
                break block2;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Object object = element$iv2;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        return (MediaCodecInfo)object;
    }

    public final boolean isHardwareAccelerated(@NotNull MediaCodecInfo codecInfo) {
        Intrinsics.checkNotNullParameter((Object)codecInfo, (String)"codecInfo");
        if (Build.VERSION.SDK_INT >= 29) {
            return codecInfo.isHardwareAccelerated();
        }
        return !this.isSoftwareOnly(codecInfo);
    }

    public final boolean isSoftwareOnly(@NotNull MediaCodecInfo codecInfo) {
        Intrinsics.checkNotNullParameter((Object)codecInfo, (String)"codecInfo");
        if (Build.VERSION.SDK_INT >= 29) {
            return codecInfo.isSoftwareOnly();
        }
        String string2 = codecInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String codecName = string3;
        return StringsKt.startsWith$default((String)codecName, (String)"arc.", (boolean)false, (int)2, null) ? false : StringsKt.startsWith$default((String)codecName, (String)"omx.google.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)codecName, (String)"omx.ffmpeg.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)codecName, (String)"omx.sec.", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)codecName, (CharSequence)".sw.", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)codecName, (Object)"omx.qcom.video.decoder.hevcswvdec") || StringsKt.startsWith$default((String)codecName, (String)"c2.android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)codecName, (String)"c2.google.", (boolean)false, (int)2, null) || !StringsKt.startsWith$default((String)codecName, (String)"omx.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)codecName, (String)"c2.", (boolean)false, (int)2, null);
    }

    private final MediaCodecInfo.CodecCapabilities getCodecCapabilities(String mimeType) {
        String encoderName2 = this.findEncoder(mimeType);
        return this.getCodecCapabilities(mimeType, encoderName2);
    }

    private final MediaCodecInfo.CodecCapabilities getCodecCapabilities(String mimeType, String name) {
        MediaCodecInfo codecInfo = this.getCodecInfo(name);
        MediaCodecInfo.CodecCapabilities codecCapabilities = codecInfo.getCapabilitiesForType(mimeType);
        Intrinsics.checkNotNullExpressionValue((Object)codecCapabilities, (String)"getCapabilitiesForType(...)");
        return codecCapabilities;
    }

    @NotNull
    public final List<MediaCodecInfo.CodecProfileLevel> getProfileLevel(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullExpressionValue((Object)this.getCodecCapabilities((String)mimeType).profileLevels, (String)"profileLevels");
        return CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)ArraysKt.toList((Object[])this.getCodecCapabilities((String)mimeType).profileLevels)));
    }

    @NotNull
    public final List<MediaCodecInfo.CodecProfileLevel> getProfileLevel(@NotNull String mimeType, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)this.getCodecCapabilities((String)mimeType, (String)name).profileLevels, (String)"profileLevels");
        return CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)ArraysKt.toList((Object[])this.getCodecCapabilities((String)mimeType, (String)name).profileLevels)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getProfiles(@NotNull String mimeType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Iterable $this$map$iv = this.getProfileLevel(mimeType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaCodecInfo.CodecProfileLevel codecProfileLevel = (MediaCodecInfo.CodecProfileLevel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.profile);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getProfiles(@NotNull String mimeType, @NotNull String name) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$map$iv = this.getProfileLevel(mimeType, name);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaCodecInfo.CodecProfileLevel codecProfileLevel = (MediaCodecInfo.CodecProfileLevel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.profile);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    public final int getMaxLevel(@NotNull String mimeType, int profile) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Iterable $this$filter$iv = this.getProfileLevel(mimeType);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MediaCodecInfo.CodecProfileLevel it = (MediaCodecInfo.CodecProfileLevel)element$iv$iv;
            boolean bl = false;
            if (!(it.profile == profile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        MediaCodecInfo.CodecProfileLevel it = (MediaCodecInfo.CodecProfileLevel)iterator.next();
        boolean bl = false;
        int n = it.level;
        while (iterator.hasNext()) {
            MediaCodecInfo.CodecProfileLevel it2 = (MediaCodecInfo.CodecProfileLevel)iterator.next();
            $i$a$-maxOf-MediaCodecHelper$getMaxLevel$2 = false;
            int n2 = it2.level;
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMaxLevel(@NotNull String mimeType, @NotNull String name, int profile) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable iterable = this.getProfileLevel(mimeType, name);
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MediaCodecInfo.CodecProfileLevel it = (MediaCodecInfo.CodecProfileLevel)element$iv$iv;
            boolean bl = false;
            if (!(it.profile == profile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        MediaCodecInfo.CodecProfileLevel it = (MediaCodecInfo.CodecProfileLevel)iterator.next();
        boolean bl = false;
        int n = it.level;
        while (iterator.hasNext()) {
            MediaCodecInfo.CodecProfileLevel it2 = (MediaCodecInfo.CodecProfileLevel)iterator.next();
            $i$a$-maxOf-MediaCodecHelper$getMaxLevel$4 = false;
            int n2 = it2.level;
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public final boolean isFormatSupported(@NotNull MediaFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string2 = format.getString("mime");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String mimeType = string2;
        Object object = this.secureMediaFormatAction(format, (Function1<? super MediaFormat, ? extends Object>)((Function1)new Function1<MediaFormat, Object>(mimeType, format){
            final /* synthetic */ String $mimeType;
            final /* synthetic */ MediaFormat $format;
            {
                this.$mimeType = $mimeType;
                this.$format = $format;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull MediaFormat it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MediaCodecHelper.access$getCodecCapabilities(MediaCodecHelper.INSTANCE, this.$mimeType).isFormatSupported(this.$format);
            }
        }));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    public final boolean isFormatSupported(@NotNull MediaFormat format, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = format.getString("mime");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String mimeType = string2;
        Object object = this.secureMediaFormatAction(format, (Function1<? super MediaFormat, ? extends Object>)((Function1)new Function1<MediaFormat, Object>(mimeType, name, format){
            final /* synthetic */ String $mimeType;
            final /* synthetic */ String $name;
            final /* synthetic */ MediaFormat $format;
            {
                this.$mimeType = $mimeType;
                this.$name = $name;
                this.$format = $format;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull MediaFormat it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MediaCodecHelper.access$getCodecCapabilities(MediaCodecHelper.INSTANCE, this.$mimeType, this.$name).isFormatSupported(this.$format);
            }
        }));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    public final boolean isFeatureSupported(@NotNull String mimeType, @NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return this.getCodecCapabilities(mimeType).isFeatureSupported(feature);
    }

    public final boolean isFeatureSupported(@NotNull String mimeType, @NotNull String name, @NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return this.getCodecCapabilities(mimeType, name).isFeatureSupported(feature);
    }

    public static final /* synthetic */ MediaCodecList access$getCodecList$p() {
        return codecList;
    }

    public static final /* synthetic */ MediaCodecInfo.CodecCapabilities access$getCodecCapabilities(MediaCodecHelper $this, String mimeType) {
        return $this.getCodecCapabilities(mimeType);
    }

    public static final /* synthetic */ List access$getEncodersType(MediaCodecHelper $this, Function1 filter) {
        return $this.getEncodersType((Function1<? super String, Boolean>)filter);
    }

    public static final /* synthetic */ List access$getEncodersName(MediaCodecHelper $this, Function1 filter) {
        return $this.getEncodersName((Function1<? super String, Boolean>)filter);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\u0005J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00100\u00100\u000f2\u0006\u0010\f\u001a\u00020\u0005J$\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00100\u00100\u000f2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper$Audio;", "", "()V", "encodersName", "", "", "getEncodersName", "()Ljava/util/List;", "supportedEncoders", "getSupportedEncoders", "getAudioCapabilities", "Landroid/media/MediaCodecInfo$AudioCapabilities;", "mimeType", "name", "getBitrateRange", "Landroid/util/Range;", "", "getInputChannelRange", "kotlin.jvm.PlatformType", "getSupportedSampleRates", "", "core_release"})
    @SourceDebugExtension(value={"SMAP\nMediaCodecHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaCodecHelper.kt\nio/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper$Audio\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,567:1\n1#2:568\n*E\n"})
    public static final class Audio {
        @NotNull
        public static final Audio INSTANCE = new Audio();
        @NotNull
        private static final List<String> supportedEncoders = MediaCodecHelper.access$getEncodersType(INSTANCE, supportedEncoders.1.INSTANCE);
        @NotNull
        private static final List<String> encodersName = MediaCodecHelper.access$getEncodersName(INSTANCE, encodersName.1.INSTANCE);

        private Audio() {
        }

        @NotNull
        public final List<String> getSupportedEncoders() {
            return supportedEncoders;
        }

        @NotNull
        public final List<String> getEncodersName() {
            return encodersName;
        }

        private final MediaCodecInfo.AudioCapabilities getAudioCapabilities(String mimeType) {
            if (!StringExtensionsKt.isAudio(mimeType)) {
                boolean bl = false;
                String string2 = "MimeType must be audio";
                throw new IllegalArgumentException(string2.toString());
            }
            String encoderName2 = INSTANCE.findEncoder(mimeType);
            return this.getAudioCapabilities(mimeType, encoderName2);
        }

        private final MediaCodecInfo.AudioCapabilities getAudioCapabilities(String mimeType, String name) {
            if (!StringExtensionsKt.isAudio(mimeType)) {
                boolean bl = false;
                String string2 = "MimeType must be audio";
                throw new IllegalArgumentException(string2.toString());
            }
            MediaCodecInfo.AudioCapabilities audioCapabilities = INSTANCE.getCodecCapabilities(mimeType, name).getAudioCapabilities();
            Intrinsics.checkNotNullExpressionValue((Object)audioCapabilities, (String)"getAudioCapabilities(...)");
            return audioCapabilities;
        }

        @NotNull
        public final Range<Integer> getInputChannelRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return new Range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(this.getAudioCapabilities(mimeType).getMaxInputChannelCount()));
        }

        @NotNull
        public final Range<Integer> getInputChannelRange(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(this.getAudioCapabilities(mimeType, name).getMaxInputChannelCount()));
        }

        @NotNull
        public final Range<Integer> getBitrateRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getAudioCapabilities(mimeType).getBitrateRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getBitrateRange(...)");
            return range;
        }

        @NotNull
        public final Range<Integer> getBitrateRange(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Range range = this.getAudioCapabilities(mimeType, name).getBitrateRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getBitrateRange(...)");
            return range;
        }

        @NotNull
        public final int[] getSupportedSampleRates(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            int[] nArray = this.getAudioCapabilities(mimeType).getSupportedSampleRates();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSupportedSampleRates(...)");
            return nArray;
        }

        @NotNull
        public final int[] getSupportedSampleRates(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            int[] nArray = this.getAudioCapabilities(mimeType, name).getSupportedSampleRates();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSupportedSampleRates(...)");
            return nArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper$Video;", "", "()V", "encodersName", "", "", "getEncodersName", "()Ljava/util/List;", "supportedEncoders", "getSupportedEncoders", "getBitrateRange", "Landroid/util/Range;", "", "mimeType", "name", "getFramerateRange", "getSupportedHeights", "getSupportedWidths", "getVideoCapabilities", "Landroid/media/MediaCodecInfo$VideoCapabilities;", "core_release"})
    @SourceDebugExtension(value={"SMAP\nMediaCodecHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaCodecHelper.kt\nio/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper$Video\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,567:1\n1#2:568\n*E\n"})
    public static final class Video {
        @NotNull
        public static final Video INSTANCE = new Video();
        @NotNull
        private static final List<String> supportedEncoders = MediaCodecHelper.access$getEncodersType(INSTANCE, supportedEncoders.1.INSTANCE);
        @NotNull
        private static final List<String> encodersName = MediaCodecHelper.access$getEncodersName(INSTANCE, encodersName.1.INSTANCE);

        private Video() {
        }

        @NotNull
        public final List<String> getSupportedEncoders() {
            return supportedEncoders;
        }

        @NotNull
        public final List<String> getEncodersName() {
            return encodersName;
        }

        private final MediaCodecInfo.VideoCapabilities getVideoCapabilities(String mimeType) {
            if (!StringExtensionsKt.isVideo(mimeType)) {
                boolean bl = false;
                String string2 = "MimeType must be video";
                throw new IllegalArgumentException(string2.toString());
            }
            String encoderName2 = INSTANCE.findEncoder(mimeType);
            return this.getVideoCapabilities(mimeType, encoderName2);
        }

        private final MediaCodecInfo.VideoCapabilities getVideoCapabilities(String mimeType, String name) {
            if (!StringExtensionsKt.isVideo(mimeType)) {
                boolean bl = false;
                String string2 = "MimeType must be video";
                throw new IllegalArgumentException(string2.toString());
            }
            MediaCodecInfo.VideoCapabilities videoCapabilities = INSTANCE.getCodecCapabilities(mimeType, name).getVideoCapabilities();
            Intrinsics.checkNotNullExpressionValue((Object)videoCapabilities, (String)"getVideoCapabilities(...)");
            return videoCapabilities;
        }

        @NotNull
        public final Range<Integer> getSupportedHeights(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getVideoCapabilities(mimeType).getSupportedHeights();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSupportedHeights(...)");
            return range;
        }

        @NotNull
        public final Range<Integer> getSupportedHeights(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Range range = this.getVideoCapabilities(mimeType, name).getSupportedHeights();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSupportedHeights(...)");
            return range;
        }

        @NotNull
        public final Range<Integer> getSupportedWidths(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getVideoCapabilities(mimeType).getSupportedHeights();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSupportedHeights(...)");
            return range;
        }

        @NotNull
        public final Range<Integer> getSupportedWidths(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Range range = this.getVideoCapabilities(mimeType, name).getSupportedHeights();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSupportedHeights(...)");
            return range;
        }

        @NotNull
        public final Range<Integer> getFramerateRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getVideoCapabilities(mimeType).getSupportedFrameRates();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSupportedFrameRates(...)");
            return range;
        }

        @NotNull
        public final Range<Integer> getFramerateRange(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Range range = this.getVideoCapabilities(mimeType, name).getSupportedFrameRates();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSupportedFrameRates(...)");
            return range;
        }

        @NotNull
        public final Range<Integer> getBitrateRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getVideoCapabilities(mimeType).getBitrateRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getBitrateRange(...)");
            return range;
        }

        @NotNull
        public final Range<Integer> getBitrateRange(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Range range = this.getVideoCapabilities(mimeType, name).getBitrateRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getBitrateRange(...)");
            return range;
        }
    }
}

