/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.os.Build;
import android.util.Range;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.internal.utils.ExtensionsKt;
import io.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tJ\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lio/github/thibaultbee/streampack/utils/Zoom;", "", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;)V", "availableRatioRange", "Landroid/util/Range;", "", "getAvailableRatioRange", "()Landroid/util/Range;", "persistentZoomRatio", "value", "zoomRatio", "getZoomRatio", "()F", "setZoomRatio", "(F)V", "onPinch", "", "scale", "speedUpZoomByX", "scaleFactor", "ratio", "", "Companion", "core_release"})
public final class Zoom {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final CameraController cameraController;
    private float persistentZoomRatio;

    public Zoom(@NotNull Context context, @NotNull CameraController cameraController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
        this.context = context;
        this.cameraController = cameraController;
        this.persistentZoomRatio = 1.0f;
    }

    @NotNull
    public final Range<Float> getAvailableRatioRange() {
        Range range;
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            range = null;
        } else {
            String it = string2;
            boolean bl = false;
            range = CameraExtensionsKt.getZoomRatioRange(this.context, it);
        }
        Range range2 = range;
        if (range == null) {
            range2 = new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(1.0f));
        }
        return range2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getZoomRatio() {
        float f;
        if (Build.VERSION.SDK_INT >= 30) {
            Float f2 = (Float)this.cameraController.getSetting(CaptureRequest.CONTROL_ZOOM_RATIO);
            f = f2 == null ? 1.0f : f2.floatValue();
        } else {
            Zoom zoom = this;
            synchronized (zoom) {
                boolean bl = false;
                float f3 = this.persistentZoomRatio;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                f = f3;
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setZoomRatio(float value) {
        if (Build.VERSION.SDK_INT >= 30) {
            CaptureRequest.Key key = CaptureRequest.CONTROL_ZOOM_RATIO;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_ZOOM_RATIO");
            this.cameraController.setRepeatingSetting(key, ExtensionsKt.clamp((Comparable)Float.valueOf(value), this.getAvailableRatioRange()));
        } else {
            Zoom zoom = this;
            synchronized (zoom) {
                boolean bl = false;
                float clampedValue = ((Number)ExtensionsKt.clamp((Comparable)Float.valueOf(value), this.getAvailableRatioRange())).floatValue();
                String string2 = this.cameraController.getCameraId();
                if (string2 != null) {
                    String cameraId2 = string2;
                    boolean bl2 = false;
                    CaptureRequest.Key key = CaptureRequest.SCALER_CROP_REGION;
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"SCALER_CROP_REGION");
                    this.cameraController.setRepeatingSetting(key, Companion.getCropRegion$core_release(CameraExtensionsKt.getCameraCharacteristics(this.context, cameraId2), clampedValue));
                }
                this.persistentZoomRatio = clampedValue;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void onPinch(float scale) {
        float scaledRatio = this.getZoomRatio() * this.speedUpZoomByX(scale, 2);
        Comparable comparable = Float.valueOf(scaledRatio);
        Comparable comparable2 = this.getAvailableRatioRange().getLower();
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"availableRatioRange.lower");
        Comparable comparable3 = comparable2;
        comparable2 = this.getAvailableRatioRange().getUpper();
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"availableRatioRange.upper");
        this.setZoomRatio(((Number)((Object)ExtensionsKt.clamp(comparable, comparable3, comparable2))).floatValue());
    }

    private final float speedUpZoomByX(float scaleFactor, int ratio) {
        return scaleFactor > 1.0f ? 1.0f + (scaleFactor - 1.0f) * (float)ratio : 1.0f - (1.0f - scaleFactor) * (float)ratio;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/utils/Zoom$Companion;", "", "()V", "getCropRegion", "Landroid/graphics/Rect;", "characteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "zoomRatio", "", "getCropRegion$core_release", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rect getCropRegion$core_release(@NotNull CameraCharacteristics characteristics, float zoomRatio) {
            Intrinsics.checkNotNullParameter((Object)characteristics, (String)"characteristics");
            Object object = characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"characteristics.get(Came\u2026INFO_ACTIVE_ARRAY_SIZE)!!");
            Rect sensorRect = (Rect)object2;
            int xCenter = sensorRect.width() / 2;
            int yCenter = sensorRect.height() / 2;
            int xDelta = (int)(0.5f * (float)sensorRect.width() / zoomRatio);
            int yDelta = (int)(0.5f * (float)sensorRect.height() / zoomRatio);
            return new Rect(xCenter - xDelta, yCenter - yDelta, xCenter + xDelta, yCenter + yDelta);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

