/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.video.avc;

import io.github.thibaultbee.streampack.internal.utils.BitOperationExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.ByteBufferExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.av.video.ChromaFormat;
import io.github.thibaultbee.streampack.internal.utils.av.video.H26XKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%BM\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c2\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c2\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c2\u0003J[\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/video/avc/AVCDecoderConfigurationRecord;", "", "configurationVersion", "", "profileIdc", "", "profileCompatibility", "levelIdc", "chromaFormat", "Lio/github/thibaultbee/streampack/internal/utils/av/video/ChromaFormat;", "sps", "", "Ljava/nio/ByteBuffer;", "pps", "(IBBBLio/github/thibaultbee/streampack/internal/utils/av/video/ChromaFormat;Ljava/util/List;Ljava/util/List;)V", "ppsNoStartCode", "size", "getSize", "()I", "spsNoStartCode", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "write", "", "buffer", "Companion", "core_release"})
public final class AVCDecoderConfigurationRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int configurationVersion;
    private final byte profileIdc;
    private final byte profileCompatibility;
    private final byte levelIdc;
    @NotNull
    private final ChromaFormat chromaFormat;
    @NotNull
    private final List<ByteBuffer> sps;
    @NotNull
    private final List<ByteBuffer> pps;
    @NotNull
    private final List<ByteBuffer> spsNoStartCode;
    @NotNull
    private final List<ByteBuffer> ppsNoStartCode;
    private final int size;
    private static final int AVC_DECODER_CONFIGURATION_RECORD_SIZE = 11;

    public AVCDecoderConfigurationRecord(int configurationVersion, byte profileIdc, byte profileCompatibility, byte levelIdc, @NotNull ChromaFormat chromaFormat, @NotNull List<? extends ByteBuffer> sps, @NotNull List<? extends ByteBuffer> pps) {
        ByteBuffer it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)chromaFormat), (String)"chromaFormat");
        Intrinsics.checkNotNullParameter(sps, (String)"sps");
        Intrinsics.checkNotNullParameter(pps, (String)"pps");
        this.configurationVersion = configurationVersion;
        this.profileIdc = profileIdc;
        this.profileCompatibility = profileCompatibility;
        this.levelIdc = levelIdc;
        this.chromaFormat = chromaFormat;
        this.sps = sps;
        this.pps = pps;
        Iterable iterable = this.sps;
        AVCDecoderConfigurationRecord aVCDecoderConfigurationRecord = this;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ByteBuffer byteBuffer = (ByteBuffer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(H26XKt.removeStartCode(it));
        }
        aVCDecoderConfigurationRecord.spsNoStartCode = (List)destination$iv$iv;
        $this$map$iv = this.pps;
        aVCDecoderConfigurationRecord = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ByteBuffer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(H26XKt.removeStartCode(it));
        }
        aVCDecoderConfigurationRecord.ppsNoStartCode = (List)destination$iv$iv;
        this.size = Companion.getSize(this.spsNoStartCode, this.ppsNoStartCode);
    }

    public /* synthetic */ AVCDecoderConfigurationRecord(int n, byte by, byte by2, byte by3, ChromaFormat chromaFormat, List list, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 0x10) != 0) {
            chromaFormat = ChromaFormat.YUV420;
        }
        this(n, by, by2, by3, chromaFormat, list, list2);
    }

    public final int getSize() {
        return this.size;
    }

    public final void write(@NotNull ByteBuffer buffer) {
        ByteBuffer it;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBufferExtensionsKt.put(buffer, this.configurationVersion);
        buffer.put(this.profileIdc);
        buffer.put(this.profileCompatibility);
        buffer.put(this.levelIdc);
        buffer.put((byte)-1);
        ByteBufferExtensionsKt.put(buffer, BitOperationExtensionsKt.shl((byte)7, 5) | this.spsNoStartCode.size());
        Iterable $this$forEach$iv = this.spsNoStartCode;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ByteBuffer)element$iv;
            boolean bl = false;
            ByteBufferExtensionsKt.putShort(buffer, it.remaining());
            buffer.put(it);
        }
        ByteBufferExtensionsKt.put(buffer, this.ppsNoStartCode.size());
        $this$forEach$iv = this.ppsNoStartCode;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ByteBuffer)element$iv;
            boolean bl = false;
            ByteBufferExtensionsKt.putShort(buffer, it.remaining());
            buffer.put(it);
        }
        if (this.profileIdc == 100 || this.profileIdc == 110 || this.profileIdc == 122 || this.profileIdc == -112) {
            ByteBufferExtensionsKt.put(buffer, 0xFC | this.chromaFormat.getValue());
            ByteBufferExtensionsKt.put(buffer, 248);
            ByteBufferExtensionsKt.put(buffer, 248);
            buffer.put((byte)0);
        }
    }

    private final int component1() {
        return this.configurationVersion;
    }

    private final byte component2() {
        return this.profileIdc;
    }

    private final byte component3() {
        return this.profileCompatibility;
    }

    private final byte component4() {
        return this.levelIdc;
    }

    private final ChromaFormat component5() {
        return this.chromaFormat;
    }

    private final List<ByteBuffer> component6() {
        return this.sps;
    }

    private final List<ByteBuffer> component7() {
        return this.pps;
    }

    @NotNull
    public final AVCDecoderConfigurationRecord copy(int configurationVersion, byte profileIdc, byte profileCompatibility, byte levelIdc, @NotNull ChromaFormat chromaFormat, @NotNull List<? extends ByteBuffer> sps, @NotNull List<? extends ByteBuffer> pps) {
        Intrinsics.checkNotNullParameter((Object)((Object)chromaFormat), (String)"chromaFormat");
        Intrinsics.checkNotNullParameter(sps, (String)"sps");
        Intrinsics.checkNotNullParameter(pps, (String)"pps");
        return new AVCDecoderConfigurationRecord(configurationVersion, profileIdc, profileCompatibility, levelIdc, chromaFormat, sps, pps);
    }

    public static /* synthetic */ AVCDecoderConfigurationRecord copy$default(AVCDecoderConfigurationRecord aVCDecoderConfigurationRecord, int n, byte by, byte by2, byte by3, ChromaFormat chromaFormat, List list, List list2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = aVCDecoderConfigurationRecord.configurationVersion;
        }
        if ((n2 & 2) != 0) {
            by = aVCDecoderConfigurationRecord.profileIdc;
        }
        if ((n2 & 4) != 0) {
            by2 = aVCDecoderConfigurationRecord.profileCompatibility;
        }
        if ((n2 & 8) != 0) {
            by3 = aVCDecoderConfigurationRecord.levelIdc;
        }
        if ((n2 & 0x10) != 0) {
            chromaFormat = aVCDecoderConfigurationRecord.chromaFormat;
        }
        if ((n2 & 0x20) != 0) {
            list = aVCDecoderConfigurationRecord.sps;
        }
        if ((n2 & 0x40) != 0) {
            list2 = aVCDecoderConfigurationRecord.pps;
        }
        return aVCDecoderConfigurationRecord.copy(n, by, by2, by3, chromaFormat, list, list2);
    }

    @NotNull
    public String toString() {
        return "AVCDecoderConfigurationRecord(configurationVersion=" + this.configurationVersion + ", profileIdc=" + this.profileIdc + ", profileCompatibility=" + this.profileCompatibility + ", levelIdc=" + this.levelIdc + ", chromaFormat=" + (Object)((Object)this.chromaFormat) + ", sps=" + this.sps + ", pps=" + this.pps + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.configurationVersion);
        result = result * 31 + Byte.hashCode(this.profileIdc);
        result = result * 31 + Byte.hashCode(this.profileCompatibility);
        result = result * 31 + Byte.hashCode(this.levelIdc);
        result = result * 31 + this.chromaFormat.hashCode();
        result = result * 31 + ((Object)this.sps).hashCode();
        result = result * 31 + ((Object)this.pps).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AVCDecoderConfigurationRecord)) {
            return false;
        }
        AVCDecoderConfigurationRecord aVCDecoderConfigurationRecord = (AVCDecoderConfigurationRecord)other;
        if (this.configurationVersion != aVCDecoderConfigurationRecord.configurationVersion) {
            return false;
        }
        if (this.profileIdc != aVCDecoderConfigurationRecord.profileIdc) {
            return false;
        }
        if (this.profileCompatibility != aVCDecoderConfigurationRecord.profileCompatibility) {
            return false;
        }
        if (this.levelIdc != aVCDecoderConfigurationRecord.levelIdc) {
            return false;
        }
        if (this.chromaFormat != aVCDecoderConfigurationRecord.chromaFormat) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sps, aVCDecoderConfigurationRecord.sps)) {
            return false;
        }
        return Intrinsics.areEqual(this.pps, aVCDecoderConfigurationRecord.pps);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\"\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\"\u0010\u000b\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/video/avc/AVCDecoderConfigurationRecord$Companion;", "", "()V", "AVC_DECODER_CONFIGURATION_RECORD_SIZE", "", "fromParameterSets", "Lio/github/thibaultbee/streampack/internal/utils/av/video/avc/AVCDecoderConfigurationRecord;", "sps", "Ljava/nio/ByteBuffer;", "pps", "", "getSize", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AVCDecoderConfigurationRecord fromParameterSets(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps) {
            Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
            Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
            return this.fromParameterSets(CollectionsKt.listOf((Object)sps), CollectionsKt.listOf((Object)pps));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AVCDecoderConfigurationRecord fromParameterSets(@NotNull List<? extends ByteBuffer> sps, @NotNull List<? extends ByteBuffer> pps) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(sps, (String)"sps");
            Intrinsics.checkNotNullParameter(pps, (String)"pps");
            Iterable $this$map$iv = sps;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                ByteBuffer byteBuffer = (ByteBuffer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(H26XKt.removeStartCode((ByteBuffer)it));
            }
            List spsNoStartCode = (List)destination$iv$iv;
            Iterable $this$map$iv2 = pps;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ByteBuffer bl = (ByteBuffer)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(H26XKt.removeStartCode((ByteBuffer)it));
            }
            List ppsNoStartCode = (List)destination$iv$iv2;
            byte profileIdc = ((ByteBuffer)spsNoStartCode.get(0)).get(1);
            byte profileCompatibility = ((ByteBuffer)spsNoStartCode.get(0)).get(2);
            byte levelIdc = ((ByteBuffer)spsNoStartCode.get(0)).get(3);
            return new AVCDecoderConfigurationRecord(0, profileIdc, profileCompatibility, levelIdc, null, spsNoStartCode, ppsNoStartCode, 17, null);
        }

        public final int getSize(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps) {
            Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
            Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
            return this.getSize(CollectionsKt.listOf((Object)sps), CollectionsKt.listOf((Object)pps));
        }

        public final int getSize(@NotNull List<? extends ByteBuffer> sps, @NotNull List<? extends ByteBuffer> pps) {
            ByteBuffer it;
            Intrinsics.checkNotNullParameter(sps, (String)"sps");
            Intrinsics.checkNotNullParameter(pps, (String)"pps");
            int size = 0;
            size = 11;
            Iterable $this$forEach$iv = sps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ByteBuffer)element$iv;
                boolean bl = false;
                size += it.remaining() - H26XKt.getStartCodeSize(it);
            }
            $this$forEach$iv = pps;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ByteBuffer)element$iv;
                boolean bl = false;
                size += it.remaining() - H26XKt.getStartCodeSize(it);
            }
            int spsStartCodeSize = H26XKt.getStartCodeSize(sps.get(0));
            byte profileIdc = sps.get(0).get(spsStartCodeSize + 1);
            switch (profileIdc) {
                case 100: 
                case 110: 
                case 122: 
                case 144: {
                    size += 4;
                }
            }
            return size;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

