/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils;

import io.github.thibaultbee.streampack.internal.utils.av.video.H26XKt;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0001\u001a\"\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0012\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u0012\u0010\u0013\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0014\u001a\u0012\u0010\u0015\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u0012\u0010\u0015\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0014\u001a\u0012\u0010\u0017\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0018\u001a\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0001\u001a\u0012\u0010\u001a\u001a\u00020\u001b*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0001\u00a8\u0006\u001c"}, d2={"extractArray", "", "Ljava/nio/ByteBuffer;", "extractRbsp", "headerLength", "", "indicesOf", "", "prefix", "put", "", "buffer", "offset", "length", "i", "i1", "s", "", "putInt24", "putLong48", "", "putShort", "l", "putString", "", "slices", "startsWith", "", "core_release"})
public final class ByteBufferExtensionsKt {
    public static final void put(@NotNull ByteBuffer $this$put, int i, int i1) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        $this$put.put(i, (byte)i1);
    }

    public static final void put(@NotNull ByteBuffer $this$put, short s) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        $this$put.put((byte)s);
    }

    public static final void put(@NotNull ByteBuffer $this$put, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        $this$put.put((byte)i);
    }

    public static final void putInt24(@NotNull ByteBuffer $this$putInt24, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$putInt24, (String)"<this>");
        ByteBufferExtensionsKt.putShort($this$putInt24, i >> 8);
        $this$putInt24.put((byte)i);
    }

    public static final void putLong48(@NotNull ByteBuffer $this$putLong48, long i) {
        Intrinsics.checkNotNullParameter((Object)$this$putLong48, (String)"<this>");
        ByteBufferExtensionsKt.putShort($this$putLong48, i >> 32);
        $this$putLong48.putInt((int)i);
    }

    public static final void putShort(@NotNull ByteBuffer $this$putShort, long l) {
        Intrinsics.checkNotNullParameter((Object)$this$putShort, (String)"<this>");
        $this$putShort.putShort((short)l);
    }

    public static final void putShort(@NotNull ByteBuffer $this$putShort, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$putShort, (String)"<this>");
        $this$putShort.putShort((short)i);
    }

    public static final void putString(@NotNull ByteBuffer $this$putString, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)$this$putString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = s.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        for (byte c : byArray) {
            $this$putString.put(c);
        }
    }

    public static final void put(@NotNull ByteBuffer $this$put, @NotNull ByteBuffer buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int limit = buffer.limit();
        buffer.position(offset);
        buffer.limit(offset + length);
        $this$put.put(buffer);
        buffer.limit(limit);
    }

    @NotNull
    public static final List<Integer> indicesOf(@NotNull ByteBuffer $this$indicesOf, @NotNull byte[] prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$indicesOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (prefix.length == 0) {
            return CollectionsKt.emptyList();
        }
        List indices = new ArrayList();
        int n = 0;
        int n2 = $this$indicesOf.limit() - prefix.length + 1;
        block0: while (n < n2) {
            int i = n++;
            int n3 = 0;
            int n4 = prefix.length;
            while (n3 < n4) {
                int j;
                if ($this$indicesOf.get(i + (j = n3++)) == prefix[j]) continue;
                continue block0;
            }
            indices.add(i);
        }
        return indices;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ByteBuffer> slices(@NotNull ByteBuffer $this$slices, @NotNull byte[] prefix) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$slices, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        List slices = new ArrayList();
        List<Integer> indexes = ByteBufferExtensionsKt.indicesOf($this$slices, prefix);
        Iterable $this$forEachIndexed$iv = indexes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void i;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv).intValue();
            int index = n;
            boolean bl = false;
            int nextPosition = CollectionsKt.getIndices((Collection)indexes).contains(index + 1) ? ((Number)indexes.get(index + 1)).intValue() - 1 : $this$slices.limit() - 1;
            slices.add(new Pair((Object)((int)i), (Object)nextPosition));
        }
        byte[] array = $this$slices.array();
        Iterable $this$map$iv = slices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)array, (String)"array");
            collection.add(ByteBuffer.wrap(ArraysKt.sliceArray((byte[])array, (IntRange)new IntRange(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue()))));
        }
        return (List)destination$iv$iv;
    }

    public static final boolean startsWith(@NotNull ByteBuffer $this$startsWith, @NotNull byte[] prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$startsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        int n = 0;
        int n2 = prefix.length;
        while (n < n2) {
            int i;
            if ($this$startsWith.get(i = n++) == prefix[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] extractArray(@NotNull ByteBuffer $this$extractArray) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$extractArray, (String)"<this>");
        if ($this$extractArray.hasArray() && !$this$extractArray.isDirect()) {
            byte[] byArray2 = $this$extractArray.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n        this.array()\n    }");
            byArray = byArray2;
        } else {
            void var1_2;
            byte[] byteArray = new byte[$this$extractArray.remaining()];
            $this$extractArray.get(byteArray);
            byArray = var1_2;
        }
        return byArray;
    }

    @NotNull
    public static final ByteBuffer extractRbsp(@NotNull ByteBuffer $this$extractRbsp, int headerLength) {
        Intrinsics.checkNotNullParameter((Object)$this$extractRbsp, (String)"<this>");
        ByteBuffer rbsp = ByteBuffer.allocateDirect($this$extractRbsp.remaining());
        byte[] byArray = new byte[]{0, 0, 3};
        List<Integer> indices = ByteBufferExtensionsKt.indicesOf($this$extractRbsp, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)rbsp, (String)"rbsp");
        ByteBufferExtensionsKt.put(rbsp, $this$extractRbsp, H26XKt.getStartCodeSize($this$extractRbsp), headerLength);
        int previous = 0;
        previous = $this$extractRbsp.position();
        Iterable $this$forEach$iv = indices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            ByteBufferExtensionsKt.put(rbsp, $this$extractRbsp, previous, it + 2 - previous);
            previous = it + 3;
        }
        ByteBufferExtensionsKt.put(rbsp, $this$extractRbsp, previous, $this$extractRbsp.limit() - previous);
        rbsp.limit(rbsp.position());
        rbsp.rewind();
        return rbsp;
    }
}

