/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.data;

import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Size;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecHelper;
import io.github.thibaultbee.streampack.internal.utils.OrientationExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.StringExtensionsKt;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"BA\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rBK\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0010\u00a2\u0006\u0002\b\u001dJ\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u0003H\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lio/github/thibaultbee/streampack/data/VideoConfig;", "Lio/github/thibaultbee/streampack/data/Config;", "mimeType", "", "startBitrate", "", "resolution", "Landroid/util/Size;", "fps", "profileLevel", "Landroid/media/MediaCodecInfo$CodecProfileLevel;", "gopSize", "", "(Ljava/lang/String;ILandroid/util/Size;ILandroid/media/MediaCodecInfo$CodecProfileLevel;F)V", "profile", "level", "(Ljava/lang/String;ILandroid/util/Size;IIIF)V", "getFps", "()I", "getGopSize", "()F", "getLevel", "getProfile", "getResolution", "()Landroid/util/Size;", "getFormat", "Landroid/media/MediaFormat;", "withProfileLevel", "", "getFormat$core_release", "getOrientedResolution", "context", "Landroid/content/Context;", "toString", "Companion", "core_release"})
public final class VideoConfig
extends Config {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Size resolution;
    private final int fps;
    private final int profile;
    private final int level;
    private final float gopSize;
    @NotNull
    private static final List<Integer> avcProfilePriority;
    @NotNull
    private static final List<Integer> hevcProfilePriority;

    public VideoConfig(@NotNull String mimeType, int startBitrate, @NotNull Size resolution, int fps, int profile, int level, float gopSize) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        super(mimeType, startBitrate);
        this.resolution = resolution;
        this.fps = fps;
        this.profile = profile;
        this.level = level;
        this.gopSize = gopSize;
        if (!StringExtensionsKt.isVideo(mimeType)) {
            boolean bl = false;
            String string = "MimeType must be video";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ VideoConfig(String string, int n, Size size, int n2, int n3, int n4, float f, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            string = "video/avc";
        }
        if ((n5 & 2) != 0) {
            n = 2000000;
        }
        if ((n5 & 4) != 0) {
            size = new Size(1280, 720);
        }
        if ((n5 & 8) != 0) {
            n2 = 30;
        }
        if ((n5 & 0x10) != 0) {
            n3 = Companion.getBestProfile(string);
        }
        if ((n5 & 0x20) != 0) {
            n4 = Companion.getBestLevel(string, n3);
        }
        if ((n5 & 0x40) != 0) {
            f = 1.0f;
        }
        this(string, n, size, n2, n3, n4, f);
    }

    @NotNull
    public final Size getResolution() {
        return this.resolution;
    }

    public final int getFps() {
        return this.fps;
    }

    public final int getProfile() {
        return this.profile;
    }

    public final int getLevel() {
        return this.level;
    }

    public final float getGopSize() {
        return this.gopSize;
    }

    public VideoConfig(@NotNull String mimeType, int startBitrate, @NotNull Size resolution, int fps, @NotNull MediaCodecInfo.CodecProfileLevel profileLevel, float gopSize) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        Intrinsics.checkNotNullParameter((Object)profileLevel, (String)"profileLevel");
        this(mimeType, startBitrate, resolution, fps, profileLevel.profile, profileLevel.level, gopSize);
    }

    public /* synthetic */ VideoConfig(String string, int n, Size size, int n2, MediaCodecInfo.CodecProfileLevel codecProfileLevel, float f, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            string = "video/avc";
        }
        if ((n3 & 2) != 0) {
            n = 2000000;
        }
        if ((n3 & 4) != 0) {
            size = new Size(1280, 720);
        }
        if ((n3 & 8) != 0) {
            n2 = 30;
        }
        if ((n3 & 0x20) != 0) {
            f = 1.0f;
        }
        this(string, n, size, n2, codecProfileLevel, f);
    }

    @NotNull
    public final Size getOrientedResolution(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return OrientationExtensionsKt.isDevicePortrait(context) ? new Size(this.resolution.getHeight(), this.resolution.getWidth()) : new Size(this.resolution.getWidth(), this.resolution.getHeight());
    }

    @Override
    @NotNull
    public MediaFormat getFormat$core_release(boolean withProfileLevel) {
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)this.getMimeType(), (int)this.resolution.getWidth(), (int)this.resolution.getHeight());
        Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"createVideoFormat(\n     \u2026solution.height\n        )");
        MediaFormat format = mediaFormat;
        format.setInteger("bitrate", this.getStartBitrate());
        format.setInteger("frame-rate", this.fps);
        if (Build.VERSION.SDK_INT >= 25) {
            format.setFloat("i-frame-interval", this.gopSize);
        } else {
            format.setInteger("i-frame-interval", MathKt.roundToInt((float)this.gopSize));
        }
        if (withProfileLevel) {
            format.setInteger("profile", this.profile);
            if (Build.VERSION.SDK_INT >= 23) {
                format.setInteger("level", this.level);
            }
        }
        return format;
    }

    @Override
    @NotNull
    public String toString() {
        return "VideoConfig(mimeType='" + this.getMimeType() + "', startBitrate=" + this.getStartBitrate() + ", resolution=" + this.resolution + ", fps=" + this.fps + ", profile=" + this.profile + ", level=" + this.level + ')';
    }

    public VideoConfig() {
        this(null, 0, null, 0, 0, 0, 0.0f, 127, null);
    }

    static {
        Object[] objectArray = new Integer[]{8, 2, 4, 1, 524288, 65536};
        avcProfilePriority = CollectionsKt.listOf((Object[])objectArray);
        hevcProfilePriority = CollectionsKt.listOf((Object)1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/thibaultbee/streampack/data/VideoConfig$Companion;", "", "()V", "avcProfilePriority", "", "", "hevcProfilePriority", "getBestLevel", "mimeType", "", "profile", "getBestProfile", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getBestProfile(@NotNull String mimeType) {
            List list;
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            String string = mimeType;
            if (Intrinsics.areEqual((Object)string, (Object)"video/avc")) {
                list = avcProfilePriority;
            } else if (Intrinsics.areEqual((Object)string, (Object)"video/hevc")) {
                list = hevcProfilePriority;
            } else {
                throw new InvalidParameterException("Profile for " + mimeType + " is not supported");
            }
            List profilePriority = list;
            List<MediaCodecInfo.CodecProfileLevel> profileLevelList = MediaCodecHelper.INSTANCE.getProfileLevel(mimeType);
            Iterator iterator = profilePriority.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                int profile;
                block8: {
                    profile = ((Number)iterator.next()).intValue();
                    Iterable $this$any$iv = profileLevelList;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            MediaCodecInfo.CodecProfileLevel it = (MediaCodecInfo.CodecProfileLevel)element$iv;
                            boolean bl2 = false;
                            if (!(it.profile == profile)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                return profile;
            }
            throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Failed to find a profile for ", (Object)mimeType));
        }

        public final int getBestLevel(@NotNull String mimeType, int profile) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return MediaCodecHelper.INSTANCE.getMaxLevel(mimeType, profile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

