/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.gl;

import android.opengl.GLES20;
import io.github.thibaultbee.streampack.internal.gl.GlUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0002J\u0006\u0010\u0011\u001a\u00020\u0004JV\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u001a\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\rH\u0002J\u0006\u0010\"\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/github/thibaultbee/streampack/internal/gl/Texture2DProgram;", "", "()V", "aPositionLoc", "", "aTextureCoordLoc", "programHandle", "uMVPMatrixLoc", "uTexMatrixLoc", "checkLocation", "", "location", "label", "", "createProgram", "vertexSource", "fragmentSource", "createTextureObject", "draw", "mvpMatrix", "", "vertexBuffer", "Ljava/nio/FloatBuffer;", "firstVertex", "vertexCount", "coordsPerVertex", "vertexStride", "texMatrix", "texBuffer", "textureId", "texStride", "loadShader", "shaderType", "source", "release", "Companion", "core_release"})
public final class Texture2DProgram {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int programHandle = this.createProgram("uniform mat4 uMVPMatrix;\n    uniform mat4 uTexMatrix;\n    attribute vec4 aPosition;\n    attribute vec4 aTextureCoord;\n    varying vec2 vTextureCoord;\n    void main() {\n        gl_Position = uMVPMatrix * aPosition;\n        vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n    }\n    ", "#extension GL_OES_EGL_image_external : require\n    precision mediump float;\n    varying vec2 vTextureCoord;\n    uniform samplerExternalOES sTexture;\n    void main() {\n        gl_FragColor = texture2D(sTexture, vTextureCoord);\n    }\n    ");
    private final int uMVPMatrixLoc;
    private final int uTexMatrixLoc;
    private final int aPositionLoc;
    private final int aTextureCoordLoc;
    @NotNull
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\n    uniform mat4 uTexMatrix;\n    attribute vec4 aPosition;\n    attribute vec4 aTextureCoord;\n    varying vec2 vTextureCoord;\n    void main() {\n        gl_Position = uMVPMatrix * aPosition;\n        vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n    }\n    ";
    @NotNull
    private static final String FRAGMENT_SHADER_EXT = "#extension GL_OES_EGL_image_external : require\n    precision mediump float;\n    varying vec2 vTextureCoord;\n    uniform samplerExternalOES sTexture;\n    void main() {\n        gl_FragColor = texture2D(sTexture, vTextureCoord);\n    }\n    ";

    public Texture2DProgram() {
        if (this.programHandle == 0) {
            throw new RuntimeException("Unable to create program");
        }
        this.aPositionLoc = GLES20.glGetAttribLocation((int)this.programHandle, (String)"aPosition");
        this.checkLocation(this.aPositionLoc, "aPosition");
        this.aTextureCoordLoc = GLES20.glGetAttribLocation((int)this.programHandle, (String)"aTextureCoord");
        this.checkLocation(this.aTextureCoordLoc, "aTextureCoord");
        this.uMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.programHandle, (String)"uMVPMatrix");
        this.checkLocation(this.uMVPMatrixLoc, "uMVPMatrix");
        this.uTexMatrixLoc = GLES20.glGetUniformLocation((int)this.programHandle, (String)"uTexMatrix");
        this.checkLocation(this.uTexMatrixLoc, "uTexMatrix");
    }

    public final void release() {
        GLES20.glDeleteProgram((int)this.programHandle);
    }

    public final int createTextureObject() {
        int[] textureID = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureID, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)textureID[0]);
        GlUtils.INSTANCE.checkGlError("glBindTexture mTextureID");
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtils.INSTANCE.checkGlError("glTexParameter");
        return textureID[0];
    }

    private final int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = this.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int pixelShader = this.loadShader(35632, fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        GlUtils.INSTANCE.checkGlError("glCreateProgram");
        if (program == 0) {
            throw new Exception("Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vertexShader);
        GlUtils.INSTANCE.checkGlError("glAttachShader");
        GLES20.glAttachShader((int)program, (int)pixelShader);
        GlUtils.INSTANCE.checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            String info = GLES20.glGetProgramInfoLog((int)program);
            GLES20.glDeleteProgram((int)program);
            throw new Exception(Intrinsics.stringPlus((String)"Could not link program: ", (Object)info));
        }
        return program;
    }

    private final int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        GlUtils.INSTANCE.checkGlError(Intrinsics.stringPlus((String)"glCreateShader type=", (Object)shaderType));
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            String info = GLES20.glGetShaderInfoLog((int)shader);
            GLES20.glDeleteShader((int)shader);
            throw new Exception("Could not compile shader " + shaderType + ": " + info);
        }
        return shader;
    }

    private final void checkLocation(int location, String label) {
        if (location < 0) {
            throw new RuntimeException("Unable to locate '" + label + "' in program");
        }
    }

    public final void draw(@NotNull float[] mvpMatrix, @NotNull FloatBuffer vertexBuffer, int firstVertex, int vertexCount, int coordsPerVertex, int vertexStride, @NotNull float[] texMatrix, @NotNull FloatBuffer texBuffer, int textureId, int texStride) {
        Intrinsics.checkNotNullParameter((Object)mvpMatrix, (String)"mvpMatrix");
        Intrinsics.checkNotNullParameter((Object)vertexBuffer, (String)"vertexBuffer");
        Intrinsics.checkNotNullParameter((Object)texMatrix, (String)"texMatrix");
        Intrinsics.checkNotNullParameter((Object)texBuffer, (String)"texBuffer");
        GlUtils.INSTANCE.checkGlError("draw start");
        GLES20.glUseProgram((int)this.programHandle);
        GlUtils.INSTANCE.checkGlError("glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)textureId);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixLoc, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        GlUtils.INSTANCE.checkGlError("glUniformMatrix4fv");
        GLES20.glUniformMatrix4fv((int)this.uTexMatrixLoc, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        GlUtils.INSTANCE.checkGlError("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)this.aPositionLoc);
        GlUtils.INSTANCE.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.aPositionLoc, (int)coordsPerVertex, (int)5126, (boolean)false, (int)vertexStride, (Buffer)vertexBuffer);
        GlUtils.INSTANCE.checkGlError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.aTextureCoordLoc);
        GlUtils.INSTANCE.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.aTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)texStride, (Buffer)texBuffer);
        GlUtils.INSTANCE.checkGlError("glVertexAttribPointer");
        GLES20.glDrawArrays((int)5, (int)firstVertex, (int)vertexCount);
        GlUtils.INSTANCE.checkGlError("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.aPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.aTextureCoordLoc);
        GLES20.glBindTexture((int)36197, (int)0);
        GLES20.glUseProgram((int)0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/thibaultbee/streampack/internal/gl/Texture2DProgram$Companion;", "", "()V", "FRAGMENT_SHADER_EXT", "", "VERTEX_SHADER", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

