/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.audio;

import android.media.MediaFormat;
import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.internal.utils.ByteBufferExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.av.audio.AudioObjectType;
import io.github.thibaultbee.streampack.internal.utils.av.audio.ChannelConfiguration;
import io.github.thibaultbee.streampack.internal.utils.av.audio.SamplingFrequencyIndex;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u0015\u001a\u00020\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioDecoderSpecificInformation;", "", "audioObjectType", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;", "sampleRate", "", "channelCount", "(Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;II)V", "getAudioObjectType", "()Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;", "getChannelCount", "()I", "getSampleRate", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toByteBuffer", "Ljava/nio/ByteBuffer;", "toString", "", "Companion", "core_release"})
public final class AudioDecoderSpecificInformation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioObjectType audioObjectType;
    private final int sampleRate;
    private final int channelCount;

    public AudioDecoderSpecificInformation(@NotNull AudioObjectType audioObjectType, int sampleRate, int channelCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioObjectType), (String)"audioObjectType");
        this.audioObjectType = audioObjectType;
        this.sampleRate = sampleRate;
        this.channelCount = channelCount;
    }

    @NotNull
    public final AudioObjectType getAudioObjectType() {
        return this.audioObjectType;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getChannelCount() {
        return this.channelCount;
    }

    @NotNull
    public final ByteBuffer toByteBuffer() {
        ByteBuffer decoderSpecificInfo = ByteBuffer.allocate(2);
        int frequencyIndex = SamplingFrequencyIndex.Companion.fromSampleRate(this.sampleRate).getValue();
        if (this.audioObjectType.getValue() > 31) {
            throw new NotImplementedError("Codec not supported");
        }
        Intrinsics.checkNotNullExpressionValue((Object)decoderSpecificInfo, (String)"decoderSpecificInfo");
        ByteBufferExtensionsKt.put(decoderSpecificInfo, this.audioObjectType.getValue() << 3 | frequencyIndex >> 1);
        if (frequencyIndex == 15) {
            throw new NotImplementedError("Explicit frequency is not supported");
        }
        ByteBufferExtensionsKt.put(decoderSpecificInfo, (frequencyIndex & 1) << 7 | ChannelConfiguration.Companion.fromChannelCount(this.channelCount).getValue() << 3);
        decoderSpecificInfo.rewind();
        return decoderSpecificInfo;
    }

    @NotNull
    public final AudioObjectType component1() {
        return this.audioObjectType;
    }

    public final int component2() {
        return this.sampleRate;
    }

    public final int component3() {
        return this.channelCount;
    }

    @NotNull
    public final AudioDecoderSpecificInformation copy(@NotNull AudioObjectType audioObjectType, int sampleRate, int channelCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioObjectType), (String)"audioObjectType");
        return new AudioDecoderSpecificInformation(audioObjectType, sampleRate, channelCount);
    }

    public static /* synthetic */ AudioDecoderSpecificInformation copy$default(AudioDecoderSpecificInformation audioDecoderSpecificInformation, AudioObjectType audioObjectType, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            audioObjectType = audioDecoderSpecificInformation.audioObjectType;
        }
        if ((n3 & 2) != 0) {
            n = audioDecoderSpecificInformation.sampleRate;
        }
        if ((n3 & 4) != 0) {
            n2 = audioDecoderSpecificInformation.channelCount;
        }
        return audioDecoderSpecificInformation.copy(audioObjectType, n, n2);
    }

    @NotNull
    public String toString() {
        return "AudioDecoderSpecificInformation(audioObjectType=" + (Object)((Object)this.audioObjectType) + ", sampleRate=" + this.sampleRate + ", channelCount=" + this.channelCount + ')';
    }

    public int hashCode() {
        int result = this.audioObjectType.hashCode();
        result = result * 31 + Integer.hashCode(this.sampleRate);
        result = result * 31 + Integer.hashCode(this.channelCount);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AudioDecoderSpecificInformation)) {
            return false;
        }
        AudioDecoderSpecificInformation audioDecoderSpecificInformation = (AudioDecoderSpecificInformation)other;
        if (this.audioObjectType != audioDecoderSpecificInformation.audioObjectType) {
            return false;
        }
        if (this.sampleRate != audioDecoderSpecificInformation.sampleRate) {
            return false;
        }
        return this.channelCount == audioDecoderSpecificInformation.channelCount;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioDecoderSpecificInformation$Companion;", "", "()V", "fromAudioConfig", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioDecoderSpecificInformation;", "config", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "fromMediaFormat", "format", "Landroid/media/MediaFormat;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AudioDecoderSpecificInformation fromMediaFormat(@NotNull MediaFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            String string = format.getString("mime");
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.getString(MediaFormat.KEY_MIME)!!");
            return new AudioDecoderSpecificInformation(AudioObjectType.Companion.fromMimeType(string2), format.getInteger("sample-rate"), format.getInteger("channel-count"));
        }

        @NotNull
        public final AudioDecoderSpecificInformation fromAudioConfig(@NotNull AudioConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new AudioDecoderSpecificInformation(AudioObjectType.Companion.fromMimeType(config.getMimeType()), config.getSampleRate(), AudioConfig.Companion.getNumberOfChannels(config.getChannelConfig()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

