/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup;

import io.github.swagger2markup.Swagger2MarkupConfig;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.builder.Swagger2MarkupConfigBuilder;
import io.github.swagger2markup.utils.URIUtils;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="convertSwagger2markup")
public class Swagger2MarkupMojo
extends AbstractMojo {
    @Parameter(property="swaggerInput", required=true)
    protected String swaggerInput;
    @Parameter(property="outputDir")
    protected File outputDir;
    @Parameter(property="outputFile")
    protected File outputFile;
    @Parameter
    protected Map<String, String> config = new HashMap<String, String>();
    @Parameter(property="skip")
    protected boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"convertSwagger2markup is skipped.");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"convertSwagger2markup goal started");
            this.getLog().debug((CharSequence)("swaggerInput: " + this.swaggerInput));
            this.getLog().debug((CharSequence)("outputDir: " + this.outputDir));
            this.getLog().debug((CharSequence)("outputFile: " + this.outputFile));
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                this.getLog().debug((CharSequence)(entry.getKey() + ": " + entry.getValue()));
            }
        }
        try {
            Swagger2MarkupConfig swagger2MarkupConfig = new Swagger2MarkupConfigBuilder(this.config).build();
            if (this.isLocalFolder(this.swaggerInput)) {
                this.getSwaggerFiles(new File(this.swaggerInput), true).forEach(f -> {
                    Swagger2MarkupConverter converter = Swagger2MarkupConverter.from((URI)f.toURI()).withConfig(swagger2MarkupConfig).build();
                    this.swaggerToMarkup(converter, true);
                });
            } else {
                Swagger2MarkupConverter converter = Swagger2MarkupConverter.from((URI)URIUtils.create((String)this.swaggerInput)).withConfig(swagger2MarkupConfig).build();
                this.swaggerToMarkup(converter, false);
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to execute goal 'convertSwagger2markup'", (Throwable)e);
        }
        this.getLog().debug((CharSequence)"convertSwagger2markup goal finished");
    }

    private boolean isLocalFolder(String swaggerInput) {
        return !swaggerInput.toLowerCase().startsWith("http") && new File(swaggerInput).isDirectory();
    }

    private void swaggerToMarkup(Swagger2MarkupConverter converter, boolean inputIsLocalFolder) {
        if (this.outputFile != null) {
            converter.toFile(this.outputFile.toPath());
        } else if (this.outputDir != null) {
            File effectiveOutputDir = this.outputDir;
            if (inputIsLocalFolder) {
                effectiveOutputDir = this.getEffectiveOutputDirWhenInputIsAFolder(converter);
            }
            converter.toFolder(effectiveOutputDir.toPath());
        } else {
            throw new IllegalArgumentException("Either outputFile or outputDir parameter must be used");
        }
    }

    private File getEffectiveOutputDirWhenInputIsAFolder(Swagger2MarkupConverter converter) {
        String outputDirAddendum = this.getInputDirStructurePath(converter);
        if (this.multipleSwaggerFilesInSwaggerLocationFolder(converter)) {
            outputDirAddendum = outputDirAddendum + File.separator + this.extracSwaggerFileNameWithoutExtension(converter);
        }
        return new File(this.outputDir, outputDirAddendum);
    }

    private String getInputDirStructurePath(Swagger2MarkupConverter converter) {
        String swaggerFilePath = new File(converter.getContext().getSwaggerLocation()).getAbsolutePath();
        String swaggerFileFolder = StringUtils.substringBeforeLast((String)swaggerFilePath, (String)File.separator);
        return StringUtils.remove((String)swaggerFileFolder, (String)this.swaggerInput);
    }

    private boolean multipleSwaggerFilesInSwaggerLocationFolder(Swagger2MarkupConverter converter) {
        Collection<File> swaggerFiles = this.getSwaggerFiles(new File(converter.getContext().getSwaggerLocation()).getParentFile(), false);
        return swaggerFiles != null && swaggerFiles.size() > 1;
    }

    private String extracSwaggerFileNameWithoutExtension(Swagger2MarkupConverter converter) {
        return FilenameUtils.removeExtension((String)new File(converter.getContext().getSwaggerLocation()).getName());
    }

    private Collection<File> getSwaggerFiles(File directory, boolean recursive) {
        return FileUtils.listFiles((File)directory, (String[])new String[]{"yaml", "yml", "json"}, (boolean)recursive);
    }
}

