/*
 * Decompiled with CFR 0.152.
 */
package io.github.stephenc.crypto.sscg.internal.bc.math.ec.custom.djb;

import io.github.stephenc.crypto.sscg.internal.bc.math.ec.ECCurve;
import io.github.stephenc.crypto.sscg.internal.bc.math.ec.ECFieldElement;
import io.github.stephenc.crypto.sscg.internal.bc.math.ec.ECPoint;
import io.github.stephenc.crypto.sscg.internal.bc.math.ec.custom.djb.Curve25519Field;
import io.github.stephenc.crypto.sscg.internal.bc.math.ec.custom.djb.Curve25519FieldElement;
import io.github.stephenc.crypto.sscg.internal.bc.math.ec.custom.djb.Curve25519Point;
import io.github.stephenc.crypto.sscg.internal.bc.math.raw.Nat256;
import io.github.stephenc.crypto.sscg.internal.bc.util.encoders.Hex;
import java.math.BigInteger;

public class Curve25519
extends ECCurve.AbstractFp {
    public static final BigInteger q = Nat256.toBigInteger(Curve25519Field.P);
    private static final int Curve25519_DEFAULT_COORDS = 4;
    protected Curve25519Point infinity = new Curve25519Point(this, null, null);

    public Curve25519() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA984914A144")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("7B425ED097B425ED097B425ED097B425ED097B425ED097B4260B5E9C7710C864")));
        this.order = new BigInteger(1, Hex.decode("1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED"));
        this.cofactor = BigInteger.valueOf(8L);
        this.coord = 4;
    }

    protected ECCurve cloneCurve() {
        return new Curve25519();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new Curve25519FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
        return new Curve25519Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
        return new Curve25519Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }
}

