/*
 * Decompiled with CFR 0.152.
 */
package io.github.stephenc.crypto.sscg.internal.bc.jce.provider;

import io.github.stephenc.crypto.sscg.internal.bc.asn1.ASN1ObjectIdentifier;
import io.github.stephenc.crypto.sscg.internal.bc.asn1.pkcs.PrivateKeyInfo;
import io.github.stephenc.crypto.sscg.internal.bc.asn1.x509.SubjectPublicKeyInfo;
import io.github.stephenc.crypto.sscg.internal.bc.jcajce.provider.config.ConfigurableProvider;
import io.github.stephenc.crypto.sscg.internal.bc.jcajce.provider.config.ProviderConfiguration;
import io.github.stephenc.crypto.sscg.internal.bc.jcajce.provider.util.AlgorithmProvider;
import io.github.stephenc.crypto.sscg.internal.bc.jcajce.provider.util.AsymmetricKeyInfoConverter;
import io.github.stephenc.crypto.sscg.internal.bc.jce.provider.BouncyCastleProviderConfiguration;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public final class BouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static String info = "BouncyCastle Security Provider v1.54";
    public static final String PROVIDER_NAME = "BC";
    public static final ProviderConfiguration CONFIGURATION = new BouncyCastleProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final String SYMMETRIC_PACKAGE = "io.github.stephenc.crypto.sscg.internal.bc.jcajce.provider.symmetric.";
    private static final String[] SYMMETRIC_GENERIC = new String[]{"PBEPBKDF2", "PBEPKCS12"};
    private static final String[] SYMMETRIC_MACS = new String[]{"SipHash"};
    private static final String[] SYMMETRIC_CIPHERS = new String[]{"AES", "ARC4", "Blowfish", "Camellia", "CAST5", "CAST6", "ChaCha", "DES", "DESede", "GOST28147", "Grainv1", "Grain128", "HC128", "HC256", "IDEA", "Noekeon", "RC2", "RC5", "RC6", "Rijndael", "Salsa20", "SEED", "Serpent", "Shacal2", "Skipjack", "SM4", "TEA", "Twofish", "Threefish", "VMPC", "VMPCKSA3", "XTEA", "XSalsa20", "OpenSSLPBKDF"};
    private static final String ASYMMETRIC_PACKAGE = "io.github.stephenc.crypto.sscg.internal.bc.jcajce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_GENERIC = new String[]{"X509", "IES"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"DSA", "DH", "EC", "RSA", "GOST", "ECGOST", "ElGamal", "DSTU4145"};
    private static final String DIGEST_PACKAGE = "io.github.stephenc.crypto.sscg.internal.bc.jcajce.provider.digest.";
    private static final String[] DIGESTS = new String[]{"GOST3411", "Keccak", "MD2", "MD4", "MD5", "SHA1", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3", "Skein", "SM3", "Tiger", "Whirlpool", "Blake2b"};
    private static final String KEYSTORE_PACKAGE = "io.github.stephenc.crypto.sscg.internal.bc.jcajce.provider.keystore.";
    private static final String[] KEYSTORES = new String[]{"BC", "PKCS12"};

    public BouncyCastleProvider() {
        super(PROVIDER_NAME, 1.54, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                BouncyCastleProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        this.loadAlgorithms(DIGEST_PACKAGE, DIGESTS);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_GENERIC);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_MACS);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_CIPHERS);
        this.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_GENERIC);
        this.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_CIPHERS);
        this.loadAlgorithms(KEYSTORE_PACKAGE, KEYSTORES);
        this.put("X509Store.CERTIFICATE/COLLECTION", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509StoreCertCollection");
        this.put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509StoreAttrCertCollection");
        this.put("X509Store.CRL/COLLECTION", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509StoreCRLCollection");
        this.put("X509Store.CERTIFICATEPAIR/COLLECTION", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509StoreCertPairCollection");
        this.put("X509Store.CERTIFICATE/LDAP", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509StoreLDAPCerts");
        this.put("X509Store.CRL/LDAP", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509StoreLDAPCRLs");
        this.put("X509Store.ATTRIBUTECERTIFICATE/LDAP", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509StoreLDAPAttrCerts");
        this.put("X509Store.CERTIFICATEPAIR/LDAP", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509StoreLDAPCertPairs");
        this.put("X509StreamParser.CERTIFICATE", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509CertParser");
        this.put("X509StreamParser.ATTRIBUTECERTIFICATE", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509AttrCertParser");
        this.put("X509StreamParser.CRL", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509CRLParser");
        this.put("X509StreamParser.CERTIFICATEPAIR", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509CertPairParser");
        this.put("Cipher.BROKENPBEWITHMD5ANDDES", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        this.put("Cipher.BROKENPBEWITHSHA1ANDDES", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        this.put("Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        this.put("CertPathValidator.RFC3281", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.PKIXAttrCertPathValidatorSpi");
        this.put("CertPathBuilder.RFC3281", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.PKIXAttrCertPathBuilderSpi");
        this.put("CertPathValidator.RFC3280", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.PKIXCertPathValidatorSpi");
        this.put("CertPathBuilder.RFC3280", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.PKIXCertPathBuilderSpi");
        this.put("CertPathValidator.PKIX", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.PKIXCertPathValidatorSpi");
        this.put("CertPathBuilder.PKIX", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.PKIXCertPathBuilderSpi");
        this.put("CertStore.Collection", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.CertStoreCollectionSpi");
        this.put("CertStore.LDAP", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.X509LDAPCertStoreSpi");
        this.put("CertStore.Multi", "io.github.stephenc.crypto.sscg.internal.bc.jce.provider.MultiCertStoreSpi");
        this.put("Alg.Alias.CertStore.X509LDAP", "LDAP");
    }

    private void loadAlgorithms(String string, String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            Class<?> clazz = null;
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                clazz = classLoader != null ? classLoader.loadClass(string + stringArray[i] + "$Mappings") : Class.forName(string + stringArray[i] + "$Mappings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) continue;
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure(this);
                continue;
            }
            catch (Exception exception) {
                throw new InternalError("cannot create instance of " + string + stringArray[i] + "$Mappings : " + exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String string, Object object) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((BouncyCastleProviderConfiguration)CONFIGURATION).setParameter(string, object);
        }
    }

    public boolean hasAlgorithm(String string, String string2) {
        return this.containsKey(string + "." + string2) || this.containsKey("Alg.Alias." + string + "." + string2);
    }

    public void addAlgorithm(String string, String string2) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put(string, string2);
    }

    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        this.addAlgorithm(string + "." + aSN1ObjectIdentifier, string2);
        this.addAlgorithm(string + ".OID." + aSN1ObjectIdentifier, string2);
    }

    public void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        keyInfoConverters.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = (AsymmetricKeyInfoConverter)keyInfoConverters.get(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePublic(subjectPublicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = (AsymmetricKeyInfoConverter)keyInfoConverters.get(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePrivate(privateKeyInfo);
    }
}

