/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.utils;

import io.github.sskorol.core.DataSupplier;
import io.github.sskorol.data.FieldName;
import io.github.sskorol.data.Source;
import io.github.sskorol.model.TypeMappings;
import io.vavr.CheckedFunction0;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.joor.Reflect;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.testng.ITestNGMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.testng.internal.annotations.IDataProvidable;

public final class ReflectionUtils {
    public static Class<?> getDataSupplierClass(IDataProvidable annotation, Class testClass, Method testMethod) {
        return Optional.ofNullable(annotation.getDataProviderClass()).map(dataProviderClass -> dataProviderClass).orElseGet(() -> ReflectionUtils.findParentDataSupplierClass(testMethod, testClass));
    }

    public static Method getDataSupplierMethod(Class<?> targetClass, String targetMethodName) {
        Tuple2 methodMetaData = ((StreamEx)StreamEx.of((Object[])targetClass.getMethods()).map(method -> Tuple.of((Object)method, (Object)method.getDeclaredAnnotation(DataSupplier.class))).filter(ReflectionUtils.hasDataSupplierMethod(targetMethodName))).map(metaData -> Tuple.of((Object)((Method)metaData._1).getName(), ((Method)metaData._1).getParameterTypes())).findFirst().orElseGet(() -> Tuple.of((Object)targetMethodName, (Object)new Class[0]));
        return targetClass.getMethod((String)methodMetaData._1, (Class[])methodMetaData._2);
    }

    public static DataSupplier getDataSupplierAnnotation(Class<?> targetClass, String targetMethodName) {
        return (DataSupplier)Try.of((CheckedFunction0 & Serializable)() -> ReflectionUtils.getDataSupplierMethod(targetClass, targetMethodName)).map(method -> method.getDeclaredAnnotation(DataSupplier.class)).filter(Objects::nonNull).getOrElse((Object)null);
    }

    public static Object invokeDataSupplier(Tuple2<Method, Object[]> methodMetaData) {
        return Reflect.on(((Method)methodMetaData._1).getDeclaringClass()).create().call(((Method)methodMetaData._1).getName(), (Object[])methodMetaData._2).get();
    }

    public static Method findDataSupplier(ITestNGMethod testMethod) {
        Tuple2<Class<?>, String> annotationMetaData = testMethod.isTest() ? ReflectionUtils.getTestAnnotationMetaData(testMethod) : ReflectionUtils.getFactoryAnnotationMetaData(testMethod);
        return ReflectionUtils.getDataSupplierMethod((Class)annotationMetaData._1, (String)annotationMetaData._2);
    }

    private static Tuple2<Class<?>, String> getTestAnnotationMetaData(ITestNGMethod testMethod) {
        Class declaringClass = testMethod.getConstructorOrMethod().getDeclaringClass();
        Class<?> parentClass = ReflectionUtils.findParentDataSupplierClass(testMethod.getConstructorOrMethod().getMethod(), declaringClass);
        Test testAnnotation = Optional.ofNullable(testMethod.getConstructorOrMethod().getMethod().getDeclaredAnnotation(Test.class)).orElseGet(() -> declaringClass.getDeclaredAnnotation(Test.class));
        Class<?> dataSupplierClass = Optional.ofNullable(testAnnotation).map(Test::dataProviderClass).filter(dp -> dp != Object.class).orElse(parentClass);
        return Tuple.of(dataSupplierClass, (Object)testAnnotation.dataProvider());
    }

    public static Tuple2<Class<?>, String> getFactoryAnnotationMetaData(ITestNGMethod testMethod) {
        Constructor constructor = testMethod.getConstructorOrMethod().getConstructor();
        Method method = testMethod.getConstructorOrMethod().getMethod();
        Optional<Factory> factoryAnnotation = Objects.nonNull(method) ? Optional.ofNullable(method.getDeclaredAnnotation(Factory.class)) : Optional.ofNullable(constructor.getDeclaredAnnotation(Factory.class));
        Class dataProviderClass = factoryAnnotation.map(fa -> fa.dataProviderClass()).filter(cl -> cl != Object.class).orElseGet(() -> testMethod.getConstructorOrMethod().getDeclaringClass());
        String dataProviderMethod = factoryAnnotation.map(Factory::dataProvider).orElse("");
        return Tuple.of((Object)dataProviderClass, (Object)dataProviderMethod);
    }

    public static Class<?> findParentDataSupplierClass(Method testMethod, Class testClass) {
        return Optional.ofNullable(testMethod).map(m -> Tuple.of((Object)m, (Object)new Reflections(m.getDeclaringClass().getPackage().getName(), new Scanner[0]))).map(ReflectionUtils.findParentDataSupplierClass()).orElse(testClass);
    }

    public static Function<Tuple2<Method, Reflections>, Class<?>> findParentDataSupplierClass() {
        return t -> StreamEx.of((Collection)((Reflections)t._2).getSubTypesOf(((Method)t._1).getDeclaringClass())).findFirst(c -> c.isAnnotationPresent(Test.class)).map(c -> c.getDeclaredAnnotation(Test.class)).map(a -> a.dataProviderClass()).orElse(((Method)t._1).getDeclaringClass());
    }

    public static Predicate<Tuple2<Method, DataSupplier>> hasDataSupplierMethod(String targetMethodName) {
        return metaData -> Objects.nonNull(metaData._2) && (((DataSupplier)metaData._2).name().equals(targetMethodName) || ((Method)metaData._1).getName().equals(targetMethodName));
    }

    public static <T> Class<T[]> castToArray(Class<T> entityClass) {
        return entityClass.isArray() ? entityClass : Array.newInstance(entityClass, 1).getClass();
    }

    public static <T> Class<T> castToObject(Class<T> entityClass) {
        return entityClass.isArray() ? entityClass.getComponentType() : entityClass;
    }

    public static String getFieldName(Field field) {
        FieldName fieldAnnotation = field.getDeclaredAnnotation(FieldName.class);
        return Objects.isNull(fieldAnnotation) ? field.getName() : fieldAnnotation.value();
    }

    public static <T> URL getSourcePath(Class<T> entity) throws IOException {
        return ReflectionUtils.getSourcePath(Optional.ofNullable(entity.getDeclaredAnnotation(Source.class)).map(Source::path).orElse(""));
    }

    public static URL getSourcePath(String path) throws IOException {
        return Optional.ofNullable((URL)Try.of((CheckedFunction0 & Serializable)() -> new URL(path)).getOrElseGet(ex -> ClassLoader.getSystemResource(path))).orElseThrow(() -> new IOException("Unable to access resource specified by " + path + " path"));
    }

    public static <T> StreamEx<T> streamOf(T data) {
        if (Objects.isNull(data)) {
            throw new IllegalArgumentException("Nothing to return from data supplier. Test will be skipped.");
        }
        return StreamEx.of((Object[])TypeMappings.values()).findFirst(type -> type.isInstanceOf(data)).map(type -> type.streamOf(data)).orElseGet(() -> StreamEx.of((Object)data));
    }

    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

